/*
 * Decompiled with CFR 0.152.
 */
package is.codion.plugin.jasperreports;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class JasperReportsDataSource<T>
implements JRDataSource {
    private final Iterator<T> reportIterator;
    private final BiFunction<T, JRField, Object> valueProvider;
    private final Consumer<T> onNext;
    private T currentItem = null;

    public JasperReportsDataSource(Iterator<T> reportIterator, BiFunction<T, JRField, Object> valueProvider) {
        this(reportIterator, valueProvider, null);
    }

    public JasperReportsDataSource(Iterator<T> reportIterator, BiFunction<T, JRField, Object> valueProvider, Consumer<T> onNext) {
        this.reportIterator = Objects.requireNonNull(reportIterator, "reportIterator");
        this.valueProvider = Objects.requireNonNull(valueProvider, "valueProvider");
        this.onNext = onNext == null ? next -> {} : onNext;
    }

    public final boolean next() {
        boolean hasNext = this.reportIterator.hasNext();
        if (hasNext) {
            this.currentItem = this.reportIterator.next();
            this.onNext.accept(this.currentItem);
        }
        return hasNext;
    }

    public final Object getFieldValue(JRField field) throws JRException {
        Objects.requireNonNull(field, "field");
        try {
            return this.valueProvider.apply(this.currentItem, field);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new JRException("Unable to get field value: " + field.getName(), (Throwable)e);
        }
    }

    public final T currentItem() {
        if (this.currentItem == null) {
            throw new IllegalStateException("Next has not been called, no current item available");
        }
        return this.currentItem;
    }
}

