/*
 * Decompiled with CFR 0.152.
 */
package is.codion.plugin.imagepanel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class NavigableImagePanel
extends JPanel {
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle(NavigableImagePanel.class.getName());
    public static final String ZOOM_LEVEL_CHANGED_PROPERTY = "zoomLevel";
    public static final String ZOOM_INCREMENT_CHANGED_PROPERTY = "zoomIncrement";
    public static final String IMAGE_CHANGED_PROPERTY = "image";
    private static final double SCREEN_NAV_IMAGE_FACTOR = 0.15;
    private static final double NAV_IMAGE_FACTOR = 0.3;
    private static final double HIGH_QUALITY_RENDERING_SCALE_THRESHOLD = 1.0;
    private static final double DEFAULT_ZOOM_INCREMENT = 0.2;
    private static final Object INTERPOLATION_TYPE = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private double zoomIncrement = 0.2;
    private double zoomFactor = 1.0 + this.zoomIncrement;
    private double navZoomFactor = 1.0 + this.zoomIncrement;
    private BufferedImage image;
    private BufferedImage navigationImage;
    private int navImageWidth;
    private int navImageHeight;
    private double initialScale = 0.0;
    private double scale = 0.0;
    private double navScale = 0.0;
    private int originX = 0;
    private int originY = 0;
    private Point mousePosition;
    private Dimension previousPanelSize;
    private boolean navigationImageEnabled = true;
    private boolean highQualityRenderingEnabled = true;
    private boolean moveImageEnabled = true;
    private WheelZoomDevice wheelZoomDevice = null;
    private ButtonZoomDevice buttonZoomDevice = null;

    public NavigableImagePanel() {
        this.setOpaque(false);
        this.previousPanelSize = this.getSize();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (NavigableImagePanel.this.scale > 0.0) {
                    if (NavigableImagePanel.this.isFullImageInPanel()) {
                        NavigableImagePanel.this.centerImage();
                    } else if (NavigableImagePanel.this.isImageEdgeInPanel()) {
                        NavigableImagePanel.this.scaleOrigin();
                    }
                    if (NavigableImagePanel.this.isNavigationImageEnabled()) {
                        NavigableImagePanel.this.createNavigationImage();
                    }
                    NavigableImagePanel.this.repaint();
                }
                NavigableImagePanel.this.previousPanelSize = NavigableImagePanel.this.getSize();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && NavigableImagePanel.this.isInNavigationImage(e.getPoint())) {
                    NavigableImagePanel.this.displayImageAt(e.getPoint());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (NavigableImagePanel.this.moveImageEnabled && SwingUtilities.isLeftMouseButton(e) && !NavigableImagePanel.this.isInNavigationImage(e.getPoint())) {
                    NavigableImagePanel.this.moveImage(e.getPoint());
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                NavigableImagePanel.this.mousePosition = e.getPoint();
            }
        });
        this.setZoomDevice(ZoomDevice.MOUSE_WHEEL);
    }

    public NavigableImagePanel(BufferedImage image) {
        this();
        this.setImage(image);
    }

    public static BufferedImage readImage(String imagePath) throws IOException {
        if (imagePath.toLowerCase().startsWith("http")) {
            return ImageIO.read(new URL(imagePath));
        }
        File imageFile = new File(imagePath);
        if (!imageFile.exists()) {
            throw new FileNotFoundException(MESSAGES.getString("file_not_found") + ": " + imagePath);
        }
        return ImageIO.read(imageFile);
    }

    public final int getImageWidth() {
        return this.image.getWidth();
    }

    public final int getImageHeight() {
        return this.image.getHeight();
    }

    private void addWheelZoomDevice() {
        if (this.wheelZoomDevice == null) {
            this.wheelZoomDevice = new WheelZoomDevice();
            this.addMouseWheelListener(this.wheelZoomDevice);
        }
    }

    private void addButtonZoomDevice() {
        if (this.buttonZoomDevice == null) {
            this.buttonZoomDevice = new ButtonZoomDevice();
            this.addMouseListener(this.buttonZoomDevice);
        }
    }

    private void removeWheelZoomDevice() {
        if (this.wheelZoomDevice != null) {
            this.removeMouseWheelListener(this.wheelZoomDevice);
            this.wheelZoomDevice = null;
        }
    }

    private void removeButtonZoomDevice() {
        if (this.buttonZoomDevice != null) {
            this.removeMouseListener(this.buttonZoomDevice);
            this.buttonZoomDevice = null;
        }
    }

    public final void setZoomDevice(ZoomDevice newZoomDevice) {
        if (newZoomDevice == ZoomDevice.NONE) {
            this.removeWheelZoomDevice();
            this.removeButtonZoomDevice();
        } else if (newZoomDevice == ZoomDevice.MOUSE_BUTTON) {
            this.removeWheelZoomDevice();
            this.addButtonZoomDevice();
        } else if (newZoomDevice == ZoomDevice.MOUSE_WHEEL) {
            this.removeButtonZoomDevice();
            this.addWheelZoomDevice();
        }
    }

    public final ZoomDevice getZoomDevice() {
        if (this.buttonZoomDevice != null) {
            return ZoomDevice.MOUSE_BUTTON;
        }
        if (this.wheelZoomDevice != null) {
            return ZoomDevice.MOUSE_WHEEL;
        }
        return ZoomDevice.NONE;
    }

    private void initializeParams() {
        double xScale = (double)this.getWidth() / (double)this.image.getWidth();
        double yScale = (double)this.getHeight() / (double)this.image.getHeight();
        this.scale = this.initialScale = Math.min(xScale, yScale);
        this.centerImage();
        if (this.navigationImageEnabled) {
            this.createNavigationImage();
        }
    }

    private void centerImage() {
        this.originX = (this.getWidth() - this.getScreenImageWidth()) / 2;
        this.originY = (this.getHeight() - this.getScreenImageHeight()) / 2;
    }

    public final void centerImage(Point2D.Double imagePoint) {
        this.centerImage(NavigableImagePanel.toPoint(this.imageToPanelPoint(imagePoint)));
    }

    public final void centerImage(Point panelPoint) {
        if (this.isWithinImage(panelPoint)) {
            Point currentCenter = new Point(this.getWidth() / 2, this.getHeight() / 2);
            this.originX = (int)((double)this.originX + (currentCenter.getX() - panelPoint.getX()));
            this.originY = (int)((double)this.originY + (currentCenter.getY() - panelPoint.getY()));
            this.repaint();
        }
    }

    public final boolean isWithinImage(Point panelPoint) {
        Point2D.Double imagePoint = this.panelToImagePoint(panelPoint);
        double width = this.getImageWidth();
        double height = this.getImageHeight();
        return imagePoint.getX() >= 0.0 && imagePoint.getX() <= width && imagePoint.getY() >= 0.0 && imagePoint.getY() <= height;
    }

    private void createNavigationImage() {
        this.navImageWidth = (int)((double)this.getWidth() * 0.3);
        this.navImageHeight = this.navImageWidth * this.image.getHeight() / this.image.getWidth();
        int scrNavImageWidth = (int)((double)this.getWidth() * 0.15);
        this.navScale = (double)scrNavImageWidth / (double)this.navImageWidth;
        ColorModel colorModel = this.image.getColorModel();
        WritableRaster raster = colorModel.createCompatibleWritableRaster(this.navImageWidth, this.navImageHeight);
        this.navigationImage = new BufferedImage(colorModel, raster, false, NavigableImagePanel.getProperties(this.image));
        this.navigationImage.getGraphics().drawImage(this.image, 0, 0, this.navImageWidth, this.navImageHeight, null);
    }

    public final void setImage(BufferedImage image) {
        if (image != null && (image.getHeight() == 0 || image.getWidth() == 0)) {
            throw new IllegalArgumentException("Only images of non-zero size can be viewed");
        }
        BufferedImage oldImage = this.image;
        this.image = image;
        this.scale = 0.0;
        this.firePropertyChange(IMAGE_CHANGED_PROPERTY, oldImage, image);
        this.repaint();
    }

    public final BufferedImage getImage() {
        return this.image;
    }

    public final double getScale() {
        return this.scale;
    }

    public final void resetView() {
        this.scale = 0.0;
        this.repaint();
    }

    public final Point2D.Double panelToImagePoint(Point panelPoint) {
        return new Point2D.Double((double)(panelPoint.x - this.originX) / this.scale, (double)(panelPoint.y - this.originY) / this.scale);
    }

    public final Point2D.Double imageToPanelPoint(Point2D.Double imagePoint) {
        return new Point2D.Double(imagePoint.x * this.scale + (double)this.originX, imagePoint.y * this.scale + (double)this.originY);
    }

    private Point navigationToZoomedImagePoint(Point panelPoint) {
        int x = panelPoint.x * this.getScreenImageWidth() / this.getScreenNavImageWidth();
        int y = panelPoint.y * this.getScreenImageHeight() / this.getScreenNavImageHeight();
        return new Point(x, y);
    }

    private void displayImageAt(Point panelPoint) {
        Point scrImagePoint = this.navigationToZoomedImagePoint(panelPoint);
        this.originX = -(scrImagePoint.x - this.getWidth() / 2);
        this.originY = -(scrImagePoint.y - this.getHeight() / 2);
        this.repaint();
    }

    private boolean isInNavigationImage(Point panelPoint) {
        return this.navigationImageEnabled && panelPoint.x < this.getScreenNavImageWidth() && panelPoint.y < this.getScreenNavImageHeight();
    }

    private boolean isImageEdgeInPanel() {
        boolean originXOK = this.originX > 0 && this.originX < this.previousPanelSize.width;
        boolean originYOK = this.originY > 0 && this.originY < this.previousPanelSize.height;
        return this.previousPanelSize != null && (originXOK || originYOK);
    }

    private boolean isFullImageInPanel() {
        return this.originX >= 0 && this.originX + this.getScreenImageWidth() < this.getWidth() && this.originY >= 0 && this.originY + this.getScreenImageHeight() < this.getHeight();
    }

    public final boolean isHighQualityRenderingEnabled() {
        return this.highQualityRenderingEnabled;
    }

    public final void setHighQualityRenderingEnabled(boolean enabled) {
        this.highQualityRenderingEnabled = enabled;
    }

    private boolean isHighQualityRendering() {
        return this.highQualityRenderingEnabled && this.scale > 1.0;
    }

    public final boolean isNavigationImageEnabled() {
        return this.navigationImageEnabled;
    }

    public final void setNavigationImageEnabled(boolean enabled) {
        this.navigationImageEnabled = enabled;
        this.repaint();
    }

    public final boolean isMoveImageEnabled() {
        return this.moveImageEnabled;
    }

    public final void setMoveImageEnabled(boolean moveImageEnabled) {
        this.moveImageEnabled = moveImageEnabled;
    }

    private void scaleOrigin() {
        this.originX = this.originX * this.getWidth() / this.previousPanelSize.width;
        this.originY = this.originY * this.getHeight() / this.previousPanelSize.height;
        this.repaint();
    }

    private double zoomToScale(double zoom) {
        return this.initialScale * zoom;
    }

    public final double getZoom() {
        return this.scale / this.initialScale;
    }

    public final void setZoom(double newZoom) {
        this.setZoom(newZoom, new Point(this.getWidth() / 2, this.getHeight() / 2));
    }

    public final void setZoom(double newZoom, Point zoomingCenter) {
        Point2D.Double imageP = this.panelToImagePoint(zoomingCenter);
        if (imageP.x < 0.0) {
            imageP = new Point2D.Double(0.0, imageP.getY());
        }
        if (imageP.y < 0.0) {
            imageP = new Point2D.Double(imageP.getX(), 0.0);
        }
        if (imageP.x >= (double)this.image.getWidth()) {
            imageP = new Point2D.Double((double)this.image.getWidth() - 1.0, imageP.getY());
        }
        if (imageP.y >= (double)this.image.getHeight()) {
            imageP = new Point2D.Double(imageP.getX(), (double)this.image.getHeight() - 1.0);
        }
        Point2D.Double correctedP = this.imageToPanelPoint(imageP);
        double oldZoom = this.getZoom();
        this.scale = this.zoomToScale(newZoom);
        Point2D.Double panelP = this.imageToPanelPoint(imageP);
        this.originX = (int)((long)this.originX + (Math.round(correctedP.getX()) - (long)((int)panelP.x)));
        this.originY = (int)((long)this.originY + (Math.round(correctedP.getY()) - (long)((int)panelP.y)));
        this.firePropertyChange(ZOOM_LEVEL_CHANGED_PROPERTY, (Object)oldZoom, (Object)this.getZoom());
        this.repaint();
    }

    public final double getZoomIncrement() {
        return this.zoomIncrement;
    }

    public final void setZoomIncrement(double newZoomIncrement) {
        double oldZoomIncrement = this.zoomIncrement;
        this.zoomIncrement = newZoomIncrement;
        this.firePropertyChange(ZOOM_INCREMENT_CHANGED_PROPERTY, (Object)oldZoomIncrement, (Object)this.zoomIncrement);
    }

    private void zoomImage() {
        Point2D.Double imagePoint = this.panelToImagePoint(this.mousePosition);
        double oldZoom = this.getZoom();
        this.scale *= this.zoomFactor;
        Point2D.Double panelPoint = this.imageToPanelPoint(imagePoint);
        this.originX += this.mousePosition.x - (int)panelPoint.x;
        this.originY += this.mousePosition.y - (int)panelPoint.y;
        this.firePropertyChange(ZOOM_LEVEL_CHANGED_PROPERTY, (Object)oldZoom, (Object)this.getZoom());
        this.repaint();
    }

    private void zoomNavigationImage() {
        this.navScale *= this.navZoomFactor;
        this.repaint();
    }

    public final Point getImageOrigin() {
        return new Point(this.originX, this.originY);
    }

    public final void setImageOrigin(int x, int y) {
        this.setImageOrigin(new Point(x, y));
    }

    public final void setImageOrigin(Point newOrigin) {
        this.originX = newOrigin.x;
        this.originY = newOrigin.y;
        this.repaint();
    }

    private void moveImage(Point panelPoint) {
        int xDelta = panelPoint.x - this.mousePosition.x;
        int yDelta = panelPoint.y - this.mousePosition.y;
        this.originX += xDelta;
        this.originY += yDelta;
        this.mousePosition = panelPoint;
        this.repaint();
    }

    private Rectangle getImageClipBounds() {
        Point2D.Double startPoint = this.panelToImagePoint(new Point(0, 0));
        Point2D.Double endPoint = this.panelToImagePoint(new Point(this.getWidth() - 1, this.getHeight() - 1));
        int panelX1 = (int)Math.round(startPoint.getX());
        int panelY1 = (int)Math.round(startPoint.getY());
        int panelX2 = (int)Math.round(endPoint.getX());
        int panelY2 = (int)Math.round(endPoint.getY());
        if (panelX1 >= this.image.getWidth() || panelX2 < 0 || panelY1 >= this.image.getHeight() || panelY2 < 0) {
            return null;
        }
        int x1 = Math.max(panelX1, 0);
        int y1 = Math.max(panelY1, 0);
        int x2 = panelX2 >= this.image.getWidth() ? this.image.getWidth() - 1 : panelX2;
        int y2 = panelY2 >= this.image.getHeight() ? this.image.getHeight() - 1 : panelY2;
        return new Rectangle(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            return;
        }
        if (Double.compare(this.scale, 0.0) == 0) {
            this.initializeParams();
        }
        if (this.isHighQualityRendering()) {
            Rectangle rect = this.getImageClipBounds();
            if (rect == null || rect.width == 0 || rect.height == 0) {
                return;
            }
            BufferedImage subimage = this.image.getSubimage(rect.x, rect.y, rect.width, rect.height);
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, INTERPOLATION_TYPE);
            g2.drawImage(subimage, Math.max(0, this.originX), Math.max(0, this.originY), Math.min((int)((double)subimage.getWidth() * this.scale), this.getWidth()), Math.min((int)((double)subimage.getHeight() * this.scale), this.getHeight()), null);
        } else {
            g.drawImage(this.image, this.originX, this.originY, this.getScreenImageWidth(), this.getScreenImageHeight(), null);
        }
        if (this.navigationImageEnabled) {
            g.drawImage(this.navigationImage, 0, 0, this.getScreenNavImageWidth(), this.getScreenNavImageHeight(), null);
            this.drawZoomAreaOutline(g);
        }
    }

    private void drawZoomAreaOutline(Graphics g) {
        if (this.isFullImageInPanel()) {
            return;
        }
        int x = -this.originX * this.getScreenNavImageWidth() / this.getScreenImageWidth();
        int y = -this.originY * this.getScreenNavImageHeight() / this.getScreenImageHeight();
        int width = this.getWidth() * this.getScreenNavImageWidth() / this.getScreenImageWidth();
        int height = this.getHeight() * this.getScreenNavImageHeight() / this.getScreenImageHeight();
        g.setColor(Color.white);
        g.drawRect(x, y, width, height);
    }

    private int getScreenImageWidth() {
        return (int)(this.scale * (double)this.image.getWidth());
    }

    private int getScreenImageHeight() {
        return (int)(this.scale * (double)this.image.getHeight());
    }

    private int getScreenNavImageWidth() {
        return (int)(this.navScale * (double)this.navImageWidth);
    }

    private int getScreenNavImageHeight() {
        return (int)(this.navScale * (double)this.navImageHeight);
    }

    private static Hashtable<String, Object> getProperties(BufferedImage image) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] propertyNames = image.getPropertyNames();
        if (propertyNames != null && propertyNames.length > 0) {
            Arrays.asList(propertyNames).forEach(propertyName -> properties.put((String)propertyName, image.getProperty((String)propertyName)));
        }
        return properties;
    }

    private static Point toPoint(Point2D.Double doublePoint) {
        return new Point((int)Math.round(doublePoint.x), (int)Math.round(doublePoint.y));
    }

    private final class WheelZoomDevice
    implements MouseWheelListener {
        private WheelZoomDevice() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            boolean zoomIn;
            Point point = event.getPoint();
            boolean bl = zoomIn = event.getWheelRotation() < 0;
            if (NavigableImagePanel.this.isInNavigationImage(point)) {
                NavigableImagePanel.this.navZoomFactor = zoomIn ? 1.0 + NavigableImagePanel.this.zoomIncrement : 1.0 - NavigableImagePanel.this.zoomIncrement;
                NavigableImagePanel.this.zoomNavigationImage();
            } else if (NavigableImagePanel.this.isWithinImage(point)) {
                NavigableImagePanel.this.zoomFactor = zoomIn ? 1.0 + NavigableImagePanel.this.zoomIncrement : 1.0 - NavigableImagePanel.this.zoomIncrement;
                NavigableImagePanel.this.zoomImage();
            }
        }
    }

    private final class ButtonZoomDevice
    extends MouseAdapter {
        private ButtonZoomDevice() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Point point = event.getPoint();
            if (SwingUtilities.isRightMouseButton(event)) {
                if (NavigableImagePanel.this.isInNavigationImage(point)) {
                    NavigableImagePanel.this.navZoomFactor = 1.0 - NavigableImagePanel.this.zoomIncrement;
                    NavigableImagePanel.this.zoomNavigationImage();
                } else if (NavigableImagePanel.this.isWithinImage(point)) {
                    NavigableImagePanel.this.zoomFactor = 1.0 - NavigableImagePanel.this.zoomIncrement;
                    NavigableImagePanel.this.zoomImage();
                }
            } else if (NavigableImagePanel.this.isInNavigationImage(point)) {
                NavigableImagePanel.this.navZoomFactor = 1.0 + NavigableImagePanel.this.zoomIncrement;
                NavigableImagePanel.this.zoomNavigationImage();
            } else if (NavigableImagePanel.this.isWithinImage(point)) {
                NavigableImagePanel.this.zoomFactor = 1.0 + NavigableImagePanel.this.zoomIncrement;
                NavigableImagePanel.this.zoomImage();
            }
        }
    }

    public static final class ZoomDevice {
        public static final ZoomDevice NONE = new ZoomDevice("none");
        public static final ZoomDevice MOUSE_BUTTON = new ZoomDevice("mouseButton");
        public static final ZoomDevice MOUSE_WHEEL = new ZoomDevice("mouseWheel");
        private final String zoomDeviceType;

        private ZoomDevice(String zoomDeviceType) {
            this.zoomDeviceType = zoomDeviceType;
        }

        public String toString() {
            return this.zoomDeviceType;
        }
    }
}

