/*
 * Decompiled with CFR 0.152.
 */
package is.codion.plugin.hikari.pool;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.pool.HikariPool;
import com.zaxxer.hikari.util.DriverDataSource;
import is.codion.common.db.connection.ConnectionFactory;
import is.codion.common.db.pool.AbstractConnectionPoolWrapper;
import is.codion.common.db.pool.ConnectionPoolFactory;
import is.codion.common.db.pool.ConnectionPoolWrapper;
import is.codion.common.user.User;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public final class HikariConnectionPoolFactory
implements ConnectionPoolFactory {
    public ConnectionPoolWrapper createConnectionPool(ConnectionFactory connectionFactory, User user) {
        return new HikariConnectionPoolWrapper(connectionFactory, user, HikariConnectionPoolFactory.createConfig(connectionFactory, user));
    }

    private static HikariConfig createConfig(ConnectionFactory connectionFactory, User user) {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(connectionFactory.url());
        config.setAutoCommit(false);
        config.setUsername(user.username());
        config.setMaximumPoolSize(((Integer)ConnectionPoolWrapper.DEFAULT_MAXIMUM_POOL_SIZE.get()).intValue());
        config.setMinimumIdle(((Integer)ConnectionPoolWrapper.DEFAULT_MINIMUM_POOL_SIZE.get()).intValue());
        config.setIdleTimeout((long)((Integer)ConnectionPoolWrapper.DEFAULT_IDLE_TIMEOUT.get()).intValue());
        return config;
    }

    private static final class HikariConnectionPoolWrapper
    extends AbstractConnectionPoolWrapper<HikariPool> {
        private final HikariConfig config;

        private HikariConnectionPoolWrapper(ConnectionFactory connectionFactory, User user, HikariConfig config) {
            super(connectionFactory, user, (DataSource)new DriverDataSource(connectionFactory.url(), null, new Properties(), user.username(), String.valueOf(user.password())), dataSourceProxy -> {
                config.setDataSource(dataSourceProxy);
                return new HikariPool(config);
            });
            this.config = config;
        }

        public void close() {
            try {
                ((HikariPool)this.connectionPool()).shutdown();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public int getCleanupInterval() {
            return 0;
        }

        public void setCleanupInterval(int poolCleanupInterval) {
        }

        public int getIdleConnectionTimeout() {
            return (int)this.config.getIdleTimeout();
        }

        public void setIdleConnectionTimeout(int idleConnectionTimeout) {
            this.config.setIdleTimeout((long)idleConnectionTimeout);
        }

        public int getMinimumPoolSize() {
            return this.config.getMinimumIdle();
        }

        public void setMinimumPoolSize(int minimumPoolSize) {
            this.config.setMinimumIdle(minimumPoolSize);
        }

        public int getMaximumPoolSize() {
            return this.config.getMaximumPoolSize();
        }

        public void setMaximumPoolSize(int maximumPoolSize) {
            this.config.setMaximumPoolSize(maximumPoolSize);
        }

        protected int available() {
            return ((HikariPool)this.connectionPool()).getIdleConnections();
        }

        protected int inUse() {
            return ((HikariPool)this.connectionPool()).getActiveConnections();
        }

        public int getMaximumCheckOutTime() {
            return (int)this.config.getConnectionTimeout();
        }

        public void setMaximumCheckOutTime(int maximumCheckOutTime) {
            this.config.setConnectionTimeout((long)maximumCheckOutTime);
        }

        protected Connection fetchConnection() throws SQLException {
            return ((HikariPool)this.connectionPool()).getConnection();
        }

        protected int waiting() {
            return ((HikariPool)this.connectionPool()).getThreadsAwaitingConnection();
        }
    }
}

