/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.servlet;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.javalin.Javalin;
import io.javalin.community.ssl.SslConfig;
import io.javalin.community.ssl.SslPlugin;
import io.javalin.config.JavalinConfig;
import io.javalin.http.ContentType;
import io.javalin.http.Context;
import io.javalin.plugin.Plugin;
import is.codion.common.Configuration;
import is.codion.common.Serializer;
import is.codion.common.Text;
import is.codion.common.db.operation.FunctionType;
import is.codion.common.db.operation.ProcedureType;
import is.codion.common.db.report.ReportType;
import is.codion.common.property.PropertyValue;
import is.codion.common.rmi.client.ConnectionRequest;
import is.codion.common.rmi.server.AuxiliaryServer;
import is.codion.common.rmi.server.Server;
import is.codion.common.rmi.server.ServerAdmin;
import is.codion.common.rmi.server.exception.ServerAuthenticationException;
import is.codion.common.rmi.server.exception.ServerException;
import is.codion.common.user.User;
import is.codion.common.version.Version;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.rmi.RemoteEntityConnection;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.json.db.DatabaseObjectMapper;
import is.codion.framework.json.domain.EntityObjectMapper;
import is.codion.framework.json.domain.EntityObjectMapperFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.rmi.RemoteException;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityService
implements AuxiliaryServer {
    private static final Logger LOG = LoggerFactory.getLogger(EntityService.class);
    public static final PropertyValue<Integer> HTTP_SERVER_PORT = Configuration.integerValue((String)"codion.server.http.port", (int)8080);
    public static final PropertyValue<Integer> HTTP_SERVER_SECURE_PORT = Configuration.integerValue((String)"codion.server.http.securePort", (int)4443);
    public static final PropertyValue<Boolean> HTTP_SERVER_SECURE = Configuration.booleanValue((String)"codion.server.http.secure", (boolean)true);
    public static final PropertyValue<String> HTTP_SERVER_CLASSPATH_KEYSTORE = Configuration.stringValue((String)"codion.server.http.classpathKeyStore");
    public static final PropertyValue<String> HTTP_SERVER_KEYSTORE_PATH = Configuration.stringValue((String)"codion.server.http.keyStore");
    public static final PropertyValue<String> HTTP_SERVER_KEYSTORE_PASSWORD = Configuration.stringValue((String)"codion.server.http.keyStorePassword");
    static final String DOMAIN_TYPE_NAME = "domainTypeName";
    static final String CLIENT_TYPE_ID = "clientTypeId";
    static final String CLIENT_ID = "clientId";
    private static final String AUTHORIZATION = "Authorization";
    private static final String BASIC_PREFIX = "basic ";
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final int BASIC_PREFIX_LENGTH = "basic ".length();
    private static final String URL_SERIAL = "entities/serial/";
    private static final String URL_JSON = "entities/json/";
    private final EntitiesHandler entitiesHandler = new EntitiesHandler();
    private final CloseHandler closeHandler = new CloseHandler();
    private final StartTransactionHandler startTransactionHandler = new StartTransactionHandler();
    private final CommitTransactionHandler commitTransactionHandler = new CommitTransactionHandler();
    private final RollbackTransactionHandler rollbackTransactionHandler = new RollbackTransactionHandler();
    private final IsTransactionOpenHandler isTransactionOpenHandler = new IsTransactionOpenHandler();
    private final IsQueryCacheEnabledHandler isQueryCacheEnabledHandler = new IsQueryCacheEnabledHandler();
    private final SetQueryCacheEnabledHandler setQueryCacheEnabledHandler = new SetQueryCacheEnabledHandler();
    private final SelectHandler selectHandler = new SelectHandler();
    private final SelectByKeyHandler selectByKeyHandler = new SelectByKeyHandler();
    private final InsertHandler insertHandler = new InsertHandler();
    private final InsertSelectHandler insertSelectHandler = new InsertSelectHandler();
    private final UpdateHandler updateHandler = new UpdateHandler();
    private final UpdateSelectHandler updateSelectHandler = new UpdateSelectHandler();
    private final UpdateByConditionHandler updateByConditionHandler = new UpdateByConditionHandler();
    private final DeleteHandler deleteHandler = new DeleteHandler();
    private final DeleteByKeyHandler deleteByKeyHandler = new DeleteByKeyHandler();
    private final ValuesHandler valuesHandler = new ValuesHandler();
    private final CountHandler countHandler = new CountHandler();
    private final DependenciesHandler dependenciesHandler = new DependenciesHandler();
    private final ProcedureHandler procedureHandler = new ProcedureHandler();
    private final FunctionHandler functionHandler = new FunctionHandler();
    private final ReportHandler reportHandler = new ReportHandler();
    private final Server<RemoteEntityConnection, ? extends ServerAdmin> server;
    private final Javalin javalin;
    private final int port;
    private final int securePort;
    private final boolean sslEnabled;
    private final Map<DomainType, ObjectMapper> domainObjectMappers = new ConcurrentHashMap<DomainType, ObjectMapper>();

    EntityService(Server<RemoteEntityConnection, ? extends ServerAdmin> server) {
        this(server, (Integer)HTTP_SERVER_PORT.getOrThrow(), (Integer)HTTP_SERVER_SECURE_PORT.getOrThrow(), (Boolean)HTTP_SERVER_SECURE.getOrThrow());
    }

    EntityService(Server<RemoteEntityConnection, ? extends ServerAdmin> server, int port, int securePort, boolean sslEnabled) {
        this.server = Objects.requireNonNull(server);
        this.port = port;
        this.securePort = securePort;
        this.sslEnabled = sslEnabled;
        this.javalin = Javalin.create((Consumer)new JavalinConfigurer());
    }

    public void startServer() {
        this.javalin.start(this.sslEnabled ? this.securePort : this.port);
        this.setupHandlers();
    }

    public void stopServer() {
        if (this.javalin != null) {
            this.javalin.stop();
        }
    }

    public String serverInformation() {
        return "Entity Service " + Version.version() + " started on port: " + this.port + ", securePort: " + this.securePort + ", sslEnabled: " + this.sslEnabled;
    }

    private void setupHandlers() {
        this.javalin.post("entities/serial/entities", this.entitiesHandler::serial);
        this.javalin.post("entities/json/entities", this.entitiesHandler::serial);
        this.javalin.post("entities/serial/close", this.closeHandler::serial);
        this.javalin.post("entities/json/close", this.closeHandler::serial);
        this.javalin.post("entities/serial/isTransactionOpen", this.isTransactionOpenHandler::serial);
        this.javalin.post("entities/json/isTransactionOpen", this.isTransactionOpenHandler::json);
        this.javalin.post("entities/serial/startTransaction", this.startTransactionHandler::serial);
        this.javalin.post("entities/json/startTransaction", this.startTransactionHandler::serial);
        this.javalin.post("entities/serial/rollbackTransaction", this.rollbackTransactionHandler::serial);
        this.javalin.post("entities/json/rollbackTransaction", this.rollbackTransactionHandler::serial);
        this.javalin.post("entities/serial/commitTransaction", this.commitTransactionHandler::serial);
        this.javalin.post("entities/json/commitTransaction", this.commitTransactionHandler::serial);
        this.javalin.post("entities/serial/isQueryCacheEnabled", this.isQueryCacheEnabledHandler::serial);
        this.javalin.post("entities/json/isQueryCacheEnabled", this.isQueryCacheEnabledHandler::json);
        this.javalin.post("entities/serial/setQueryCacheEnabled", this.setQueryCacheEnabledHandler::serial);
        this.javalin.post("entities/json/setQueryCacheEnabled", this.setQueryCacheEnabledHandler::json);
        this.javalin.post("entities/serial/procedure", this.procedureHandler::serial);
        this.javalin.post("entities/json/procedure", this.procedureHandler::serial);
        this.javalin.post("entities/serial/function", this.functionHandler::serial);
        this.javalin.post("entities/json/function", this.functionHandler::serial);
        this.javalin.post("entities/serial/report", this.reportHandler::serial);
        this.javalin.post("entities/json/report", this.reportHandler::serial);
        this.javalin.post("entities/serial/dependencies", this.dependenciesHandler::serial);
        this.javalin.post("entities/json/dependencies", this.dependenciesHandler::json);
        this.javalin.post("entities/serial/count", this.countHandler::serial);
        this.javalin.post("entities/json/count", this.countHandler::json);
        this.javalin.post("entities/serial/values", this.valuesHandler::serial);
        this.javalin.post("entities/json/values", this.valuesHandler::json);
        this.javalin.post("entities/serial/selectByKey", this.selectByKeyHandler::serial);
        this.javalin.post("entities/json/selectByKey", this.selectByKeyHandler::json);
        this.javalin.post("entities/serial/select", this.selectHandler::serial);
        this.javalin.post("entities/json/select", this.selectHandler::json);
        this.javalin.post("entities/serial/insert", this.insertHandler::serial);
        this.javalin.post("entities/serial/insertSelect", this.insertSelectHandler::serial);
        this.javalin.post("entities/json/insert", this.insertHandler::json);
        this.javalin.post("entities/json/insertSelect", this.insertSelectHandler::json);
        this.javalin.post("entities/serial/update", this.updateHandler::serial);
        this.javalin.post("entities/serial/updateSelect", this.updateSelectHandler::serial);
        this.javalin.post("entities/json/update", this.updateHandler::json);
        this.javalin.post("entities/json/updateSelect", this.updateSelectHandler::json);
        this.javalin.post("entities/serial/updateByCondition", this.updateByConditionHandler::serial);
        this.javalin.post("entities/json/updateByCondition", this.updateByConditionHandler::json);
        this.javalin.post("entities/serial/delete", this.deleteHandler::serial);
        this.javalin.post("entities/json/delete", this.deleteHandler::json);
        this.javalin.post("entities/serial/deleteByKey", this.deleteByKeyHandler::serial);
        this.javalin.post("entities/json/deleteByKey", this.deleteByKeyHandler::json);
    }

    private RemoteEntityConnection authenticate(Context context) throws RemoteException, ServerException {
        if (this.server == null) {
            throw new IllegalStateException("EntityServer has not been set for EntityService");
        }
        String domainTypeName = EntityService.domainTypeName(context);
        String clientTypeId = EntityService.clientTypeId(context);
        UUID clientId = EntityService.clientId(context);
        User user = EntityService.user(context);
        return (RemoteEntityConnection)this.server.connect(ConnectionRequest.builder().user(user).clientId(clientId).clientTypeId(clientTypeId).parameter("codion.client.domainType", (Object)domainTypeName).parameter("clientHost", (Object)EntityService.remoteHost(context.req())).build());
    }

    private ObjectMapper objectMapper(Entities entities) {
        return this.domainObjectMappers.computeIfAbsent(entities.domainType(), domainType -> DatabaseObjectMapper.databaseObjectMapper((EntityObjectMapper)EntityObjectMapperFactory.instance((DomainType)domainType).entityObjectMapper(entities)));
    }

    private static String remoteHost(HttpServletRequest request) {
        String forwardHeader = request.getHeader(X_FORWARDED_FOR);
        if (forwardHeader == null) {
            return request.getRemoteAddr();
        }
        return forwardHeader.split(",")[0];
    }

    private static String domainTypeName(Context context) throws ServerAuthenticationException {
        return EntityService.checkHeaderParameter(context.header(DOMAIN_TYPE_NAME), DOMAIN_TYPE_NAME);
    }

    private static String clientTypeId(Context context) throws ServerAuthenticationException {
        return EntityService.checkHeaderParameter(context.header(CLIENT_TYPE_ID), CLIENT_TYPE_ID);
    }

    private static UUID clientId(Context context) throws ServerAuthenticationException {
        UUID headerClientId = UUID.fromString(EntityService.checkHeaderParameter(context.header(CLIENT_ID), CLIENT_ID));
        HttpSession session = context.req().getSession();
        if (session.isNew()) {
            session.setAttribute(CLIENT_ID, (Object)headerClientId);
        } else {
            UUID sessionClientId = (UUID)session.getAttribute(CLIENT_ID);
            if (sessionClientId == null || !sessionClientId.equals(headerClientId)) {
                session.invalidate();
                throw new ServerAuthenticationException("Invalid client id");
            }
        }
        return headerClientId;
    }

    private static User user(Context context) throws ServerAuthenticationException {
        String basicAuth = context.header(AUTHORIZATION);
        if (Text.nullOrEmpty((String)basicAuth)) {
            throw new ServerAuthenticationException("Authorization information missing");
        }
        if (basicAuth.length() > BASIC_PREFIX_LENGTH && BASIC_PREFIX.equalsIgnoreCase(basicAuth.substring(0, BASIC_PREFIX_LENGTH))) {
            return User.parse((String)new String(Base64.getDecoder().decode(basicAuth.substring(BASIC_PREFIX_LENGTH))));
        }
        throw new ServerAuthenticationException("Invalid authorization format");
    }

    private static String checkHeaderParameter(String header, String headerParameter) throws ServerAuthenticationException {
        if (Text.nullOrEmpty((String)header)) {
            throw new ServerAuthenticationException(headerParameter + " header parameter is missing");
        }
        return header;
    }

    private static void handleException(Context context, Exception exception) {
        LOG.error(exception.getMessage(), (Throwable)exception);
        context.status(EntityService.exceptionStatus(exception)).result(EntityService.exceptionResult(exception));
    }

    private static int exceptionStatus(Exception exception) {
        if (exception instanceof ServerAuthenticationException) {
            return 401;
        }
        return 500;
    }

    private static byte[] exceptionResult(Exception exception) {
        try {
            return Serializer.serialize((Object)exception);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                return Serializer.serialize((Object)e);
            }
            catch (IOException io) {
                LOG.error(e.getMessage(), (Throwable)io);
                return new byte[0];
            }
        }
    }

    private static <T> T deserialize(HttpServletRequest request) throws IOException, ClassNotFoundException {
        return (T)new ObjectInputStream((InputStream)request.getInputStream()).readObject();
    }

    private static synchronized void resolveClasspathKeyStore() {
        String keystore = (String)HTTP_SERVER_CLASSPATH_KEYSTORE.get();
        if (Text.nullOrEmpty((String)keystore)) {
            LOG.debug("No classpath key store specified via {}", (Object)HTTP_SERVER_CLASSPATH_KEYSTORE.propertyName());
            return;
        }
        if (HTTP_SERVER_KEYSTORE_PATH.isNotNull()) {
            throw new IllegalStateException("Classpath keystore (" + keystore + ") can not be specified when " + HTTP_SERVER_KEYSTORE_PATH.propertyName() + " is already set to " + (String)HTTP_SERVER_KEYSTORE_PATH.get());
        }
        try (InputStream inputStream = EntityService.class.getClassLoader().getResourceAsStream(keystore);){
            if (inputStream == null) {
                LOG.debug("Specified key store not found on classpath: {}", (Object)keystore);
                return;
            }
            File file = File.createTempFile("serverKeyStore", "tmp");
            Files.write(file.toPath(), EntityService.readBytes(inputStream), new OpenOption[0]);
            file.deleteOnExit();
            HTTP_SERVER_KEYSTORE_PATH.set((Object)file.getPath());
            LOG.debug("Classpath key store {} written to file {} and set as {}", new Object[]{HTTP_SERVER_CLASSPATH_KEYSTORE.propertyName(), file, HTTP_SERVER_KEYSTORE_PATH.propertyName()});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] readBytes(InputStream stream) throws IOException {
        int line;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((line = stream.read(buffer)) != -1) {
            os.write(buffer, 0, line);
        }
        os.flush();
        return os.toByteArray();
    }

    static {
        EntityService.resolveClasspathKeyStore();
    }

    private final class EntitiesHandler {
        private EntitiesHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                context.status(200).result(Serializer.serialize((Object)connection.entities()));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class CloseHandler {
        private CloseHandler() {
        }

        private void serial(Context context) {
            try {
                EntityService.this.authenticate(context).close();
                context.req().getSession().invalidate();
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class StartTransactionHandler {
        private StartTransactionHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                connection.startTransaction();
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class CommitTransactionHandler {
        private CommitTransactionHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                connection.commitTransaction();
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class RollbackTransactionHandler {
        private RollbackTransactionHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                connection.rollbackTransaction();
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class IsTransactionOpenHandler {
        private IsTransactionOpenHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)connection.transactionOpen()));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }

        private void json(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)connection.transactionOpen()));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class IsQueryCacheEnabledHandler {
        private IsQueryCacheEnabledHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)connection.isQueryCacheEnabled()));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }

        private void json(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)connection.isQueryCacheEnabled()));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class SetQueryCacheEnabledHandler {
        private SetQueryCacheEnabledHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                connection.setQueryCacheEnabled(((Boolean)EntityService.deserialize(context.req())).booleanValue());
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }

        private void json(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                connection.setQueryCacheEnabled(((Boolean)objectMapper.readValue((InputStream)context.req().getInputStream(), Boolean.class)).booleanValue());
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class SelectHandler {
        private SelectHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                EntityConnection.Select select = (EntityConnection.Select)EntityService.deserialize(context.req());
                List selected = connection.select(select);
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)selected));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }

        private void json(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                EntityConnection.Select selectJson = (EntityConnection.Select)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityConnection.Select.class);
                List selected = connection.select(selectJson);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)selected));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class SelectByKeyHandler {
        private SelectByKeyHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                List keys = (List)EntityService.deserialize(context.req());
                Collection selected = connection.select((Collection)keys);
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)selected));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }

        private void json(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                List keys = (List)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityObjectMapper.KEY_LIST_REFERENCE);
                Collection selected = connection.select((Collection)keys);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)selected));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class InsertHandler {
        private InsertHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                Collection keys = connection.insert((Collection)EntityService.deserialize(context.req()));
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)keys));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }

        private void json(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                Collection entities = (Collection)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityObjectMapper.ENTITY_LIST_REFERENCE);
                Collection keys = connection.insert(entities);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)keys));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class InsertSelectHandler {
        private InsertSelectHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                Collection entities = connection.insertSelect((Collection)EntityService.deserialize(context.req()));
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)entities));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }

        private void json(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                Collection entities = (Collection)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityObjectMapper.ENTITY_LIST_REFERENCE);
                Collection inserted = connection.insertSelect(entities);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)inserted));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class UpdateHandler {
        private UpdateHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                connection.update((Collection)((List)EntityService.deserialize(context.req())));
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }

        private void json(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                List entities = (List)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityObjectMapper.ENTITY_LIST_REFERENCE);
                connection.update((Collection)entities);
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class UpdateSelectHandler {
        private UpdateSelectHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                Collection updated = connection.updateSelect((Collection)((List)EntityService.deserialize(context.req())));
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)updated));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }

        private void json(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                List entities = (List)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityObjectMapper.ENTITY_LIST_REFERENCE);
                Collection updated = connection.updateSelect((Collection)entities);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)updated));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class UpdateByConditionHandler {
        private UpdateByConditionHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                int updateCount = connection.update((EntityConnection.Update)EntityService.deserialize(context.req()));
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)updateCount));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }

        private void json(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                EntityConnection.Update update = (EntityConnection.Update)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityConnection.Update.class);
                int updateCount = connection.update(update);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)updateCount));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class DeleteHandler {
        private DeleteHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                Condition condition = (Condition)EntityService.deserialize(context.req());
                int deleteCount = connection.delete(condition);
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)deleteCount));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }

        private void json(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                Condition deleteCondition = (Condition)objectMapper.readValue((InputStream)context.req().getInputStream(), Condition.class);
                int deleteCount = connection.delete(deleteCondition);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)deleteCount));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class DeleteByKeyHandler {
        private DeleteByKeyHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                List keys = (List)EntityService.deserialize(context.req());
                connection.delete((Collection)keys);
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }

        private void json(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                List keys = (List)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityObjectMapper.KEY_LIST_REFERENCE);
                connection.delete((Collection)keys);
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class ValuesHandler {
        private ValuesHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                List parameters = (List)EntityService.deserialize(context.req());
                List values = connection.select((Column)parameters.get(0), (EntityConnection.Select)parameters.get(1));
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)values));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }

        private void json(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                Entities entities = connection.entities();
                ObjectMapper objectMapper = EntityService.this.objectMapper(entities);
                JsonNode jsonNode = objectMapper.readTree((InputStream)context.req().getInputStream());
                EntityType entityType = entities.domainType().entityType(jsonNode.get("entityType").asText());
                Column column = (Column)entities.definition(entityType).attributes().get(jsonNode.get("column").textValue());
                EntityConnection.Select select = null;
                JsonNode conditionNode = jsonNode.get("condition");
                if (conditionNode != null) {
                    select = (EntityConnection.Select)objectMapper.readValue(conditionNode.toString(), EntityConnection.Select.class);
                }
                List values = connection.select(column, select);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)values));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class CountHandler {
        private CountHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                int rowCount = connection.count((EntityConnection.Count)EntityService.deserialize(context.req()));
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)rowCount));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }

        private void json(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                int rowCount = connection.count((EntityConnection.Count)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityConnection.Count.class));
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)rowCount));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class DependenciesHandler {
        private DependenciesHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)connection.dependencies((Collection)EntityService.deserialize(context.req()))));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }

        private void json(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                List entities = (List)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityObjectMapper.ENTITY_LIST_REFERENCE);
                Map dependencies = connection.dependencies((Collection)entities);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)dependencies));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class ProcedureHandler {
        private ProcedureHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                List parameters = (List)EntityService.deserialize(context.req());
                Object argument = parameters.size() > 1 ? parameters.get(1) : null;
                connection.execute((ProcedureType)parameters.get(0), argument);
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class FunctionHandler {
        private FunctionHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                List parameters = (List)EntityService.deserialize(context.req());
                FunctionType functionType = (FunctionType)parameters.get(0);
                Object argument = parameters.size() > 1 ? parameters.get(1) : null;
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)connection.execute(functionType, argument)));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class ReportHandler {
        private ReportHandler() {
        }

        private void serial(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                List parameters = (List)EntityService.deserialize(context.req());
                ReportType reportType = (ReportType)parameters.get(0);
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)connection.report(reportType, parameters.get(1))));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class JavalinConfigurer
    implements Consumer<JavalinConfig> {
        private JavalinConfigurer() {
        }

        @Override
        public void accept(JavalinConfig config) {
            if (EntityService.this.sslEnabled) {
                config.registerPlugin((Plugin)new SslPlugin((Consumer)new SslPLuginConfigurer()));
            }
        }
    }

    private final class SslPLuginConfigurer
    implements Consumer<SslConfig> {
        private SslPLuginConfigurer() {
        }

        @Override
        public void accept(SslConfig ssl) {
            ssl.keystoreFromPath((String)HTTP_SERVER_KEYSTORE_PATH.getOrThrow(), (String)HTTP_SERVER_KEYSTORE_PASSWORD.getOrThrow());
            ssl.securePort = EntityService.this.securePort;
            ssl.insecurePort = EntityService.this.port;
        }
    }
}

