/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.servlet;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.javalin.Javalin;
import io.javalin.community.ssl.SslConfig;
import io.javalin.community.ssl.SslPlugin;
import io.javalin.config.JavalinConfig;
import io.javalin.http.ContentType;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.plugin.Plugin;
import is.codion.common.Configuration;
import is.codion.common.NullOrEmpty;
import is.codion.common.Serializer;
import is.codion.common.db.operation.FunctionType;
import is.codion.common.db.operation.ProcedureType;
import is.codion.common.db.report.ReportType;
import is.codion.common.property.PropertyValue;
import is.codion.common.rmi.client.ConnectionRequest;
import is.codion.common.rmi.server.AuxiliaryServer;
import is.codion.common.rmi.server.Server;
import is.codion.common.rmi.server.ServerAdmin;
import is.codion.common.rmi.server.exception.ServerAuthenticationException;
import is.codion.common.rmi.server.exception.ServerException;
import is.codion.common.user.User;
import is.codion.common.version.Version;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.rmi.RemoteEntityConnection;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.json.db.DatabaseObjectMapper;
import is.codion.framework.json.domain.EntityObjectMapper;
import is.codion.framework.json.domain.EntityObjectMapperFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.rmi.RemoteException;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityService
implements AuxiliaryServer {
    private static final Logger LOG = LoggerFactory.getLogger(EntityService.class);
    public static final PropertyValue<Integer> HTTP_SERVER_PORT = Configuration.integerValue((String)"codion.server.http.port", (int)8080);
    public static final PropertyValue<Integer> HTTP_SERVER_SECURE_PORT = Configuration.integerValue((String)"codion.server.http.securePort", (int)4443);
    public static final PropertyValue<Boolean> HTTP_SERVER_SECURE = Configuration.booleanValue((String)"codion.server.http.secure", (boolean)true);
    public static final PropertyValue<String> HTTP_SERVER_CLASSPATH_KEYSTORE = Configuration.stringValue((String)"codion.server.http.classpathKeyStore");
    public static final PropertyValue<String> HTTP_SERVER_KEYSTORE_PATH = Configuration.stringValue((String)"codion.server.http.keyStore");
    public static final PropertyValue<String> HTTP_SERVER_KEYSTORE_PASSWORD = Configuration.stringValue((String)"codion.server.http.keyStorePassword");
    static final String DOMAIN_TYPE_NAME = "domainTypeName";
    static final String CLIENT_TYPE_ID = "clientTypeId";
    static final String CLIENT_ID = "clientId";
    private static final String AUTHORIZATION = "Authorization";
    private static final String BASIC_PREFIX = "basic ";
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final int BASIC_PREFIX_LENGTH = "basic ".length();
    private static final String URL_JAVA_SERIALIZATION = "entities/ser/";
    private static final String URL_JSON_SERIALIZATION = "entities/json/";
    private final Server<RemoteEntityConnection, ? extends ServerAdmin> server;
    private final int port;
    private final int securePort;
    private final boolean sslEnabled;
    private final Map<DomainType, ObjectMapper> domainObjectMappers = new ConcurrentHashMap<DomainType, ObjectMapper>();
    private Javalin javalin;

    EntityService(Server<RemoteEntityConnection, ? extends ServerAdmin> server) {
        this(server, (Integer)HTTP_SERVER_PORT.getOrThrow(), (Integer)HTTP_SERVER_SECURE_PORT.getOrThrow(), (Boolean)HTTP_SERVER_SECURE.getOrThrow());
    }

    EntityService(Server<RemoteEntityConnection, ? extends ServerAdmin> server, int port, int securePort, boolean sslEnabled) {
        this.server = Objects.requireNonNull(server);
        this.port = port;
        this.securePort = securePort;
        this.sslEnabled = sslEnabled;
    }

    public void startServer() {
        this.javalin = Javalin.create((Consumer)new JavalinConfigurer()).start(this.sslEnabled ? this.securePort : this.port);
        this.setupHandlers();
    }

    public void stopServer() {
        if (this.javalin != null) {
            this.javalin.stop();
        }
    }

    public String serverInformation() {
        return "Entity Service " + Version.version() + " started on port: " + this.port + ", securePort: " + this.securePort + ", sslEnabled: " + this.sslEnabled;
    }

    private void setupHandlers() {
        EntitiesHandler entitiesHandler = new EntitiesHandler();
        this.javalin.post("entities/ser/entities", (Handler)entitiesHandler);
        this.javalin.post("entities/json/entities", (Handler)entitiesHandler);
        CloseHandler closeHandler = new CloseHandler();
        this.javalin.post("entities/ser/close", (Handler)closeHandler);
        this.javalin.post("entities/json/close", (Handler)closeHandler);
        this.javalin.post("entities/ser/isTransactionOpen", (Handler)new IsTransactionOpenHandler());
        this.javalin.post("entities/json/isTransactionOpen", (Handler)new IsTransactionOpenJsonHandler());
        StartTransactionHandler startTransactionHandler = new StartTransactionHandler();
        this.javalin.post("entities/ser/startTransaction", (Handler)startTransactionHandler);
        this.javalin.post("entities/json/startTransaction", (Handler)startTransactionHandler);
        RollbackTransactionHandler rollbackTransactionHandler = new RollbackTransactionHandler();
        this.javalin.post("entities/ser/rollbackTransaction", (Handler)rollbackTransactionHandler);
        this.javalin.post("entities/json/rollbackTransaction", (Handler)rollbackTransactionHandler);
        CommitTransactionHandler commitTransactionHandler = new CommitTransactionHandler();
        this.javalin.post("entities/ser/commitTransaction", (Handler)commitTransactionHandler);
        this.javalin.post("entities/json/commitTransaction", (Handler)commitTransactionHandler);
        this.javalin.post("entities/ser/isQueryCacheEnabled", (Handler)new IsQueryCacheEnabledHandler());
        this.javalin.post("entities/json/isQueryCacheEnabled", (Handler)new IsQueryCacheEnabledJsonHandler());
        this.javalin.post("entities/ser/setQueryCacheEnabled", (Handler)new SetQueryCacheEnabledHandler());
        this.javalin.post("entities/json/setQueryCacheEnabled", (Handler)new SetQueryCacheEnabledJsonHandler());
        ProcedureHandler procedureHandler = new ProcedureHandler();
        this.javalin.post("entities/ser/procedure", (Handler)procedureHandler);
        this.javalin.post("entities/json/procedure", (Handler)procedureHandler);
        FunctionHandler functionHandler = new FunctionHandler();
        this.javalin.post("entities/ser/function", (Handler)functionHandler);
        this.javalin.post("entities/json/function", (Handler)functionHandler);
        ReportHandler reportHandler = new ReportHandler();
        this.javalin.post("entities/ser/report", (Handler)reportHandler);
        this.javalin.post("entities/json/report", (Handler)reportHandler);
        this.javalin.post("entities/ser/dependencies", (Handler)new DependenciesHandler());
        this.javalin.post("entities/json/dependencies", (Handler)new DependenciesJsonHandler());
        this.javalin.post("entities/ser/count", (Handler)new CountHandler());
        this.javalin.post("entities/json/count", (Handler)new CountJsonHandler());
        this.javalin.post("entities/ser/values", (Handler)new ValuesHandler());
        this.javalin.post("entities/json/values", (Handler)new ValuesJsonHandler());
        this.javalin.post("entities/ser/selectByKey", (Handler)new SelectByKeyHandler());
        this.javalin.post("entities/json/selectByKey", (Handler)new SelectByKeyJsonHandler());
        this.javalin.post("entities/ser/select", (Handler)new SelectHandler());
        this.javalin.post("entities/json/select", (Handler)new SelectJsonHandler());
        this.javalin.post("entities/ser/insert", (Handler)new InsertHandler());
        this.javalin.post("entities/ser/insertSelect", (Handler)new InsertSelectHandler());
        this.javalin.post("entities/json/insert", (Handler)new InsertJsonHandler());
        this.javalin.post("entities/json/insertSelect", (Handler)new InsertSelectJsonHandler());
        this.javalin.post("entities/ser/update", (Handler)new UpdateHandler());
        this.javalin.post("entities/ser/updateSelect", (Handler)new UpdateSelectHandler());
        this.javalin.post("entities/json/update", (Handler)new UpdateJsonHandler());
        this.javalin.post("entities/json/updateSelect", (Handler)new UpdateSelectJsonHandler());
        this.javalin.post("entities/ser/updateByCondition", (Handler)new UpdateByConditionHandler());
        this.javalin.post("entities/json/updateByCondition", (Handler)new UpdateByConditionJsonHandler());
        this.javalin.post("entities/ser/delete", (Handler)new DeleteHandler());
        this.javalin.post("entities/json/delete", (Handler)new DeleteJsonHandler());
        this.javalin.post("entities/ser/deleteByKey", (Handler)new DeleteByKeyHandler());
        this.javalin.post("entities/json/deleteByKey", (Handler)new DeleteByKeyJsonHandler());
    }

    private RemoteEntityConnection authenticate(Context context) throws RemoteException, ServerException {
        if (this.server == null) {
            throw new IllegalStateException("EntityServer has not been set for EntityService");
        }
        String domainTypeName = EntityService.domainTypeName(context);
        String clientTypeId = EntityService.clientTypeId(context);
        UUID clientId = EntityService.clientId(context);
        User user = EntityService.user(context);
        return (RemoteEntityConnection)this.server.connect(ConnectionRequest.builder().user(user).clientId(clientId).clientTypeId(clientTypeId).parameter("codion.client.domainType", (Object)domainTypeName).parameter("clientHost", (Object)EntityService.remoteHost(context.req())).build());
    }

    private ObjectMapper objectMapper(Entities entities) {
        return this.domainObjectMappers.computeIfAbsent(entities.domainType(), domainType -> DatabaseObjectMapper.databaseObjectMapper((EntityObjectMapper)EntityObjectMapperFactory.instance((DomainType)domainType).entityObjectMapper(entities)));
    }

    private static String remoteHost(HttpServletRequest request) {
        String forwardHeader = request.getHeader(X_FORWARDED_FOR);
        if (forwardHeader == null) {
            return request.getRemoteAddr();
        }
        return forwardHeader.split(",")[0];
    }

    private static String domainTypeName(Context context) throws ServerAuthenticationException {
        return EntityService.checkHeaderParameter(context.header(DOMAIN_TYPE_NAME), DOMAIN_TYPE_NAME);
    }

    private static String clientTypeId(Context context) throws ServerAuthenticationException {
        return EntityService.checkHeaderParameter(context.header(CLIENT_TYPE_ID), CLIENT_TYPE_ID);
    }

    private static UUID clientId(Context context) throws ServerAuthenticationException {
        UUID headerClientId = UUID.fromString(EntityService.checkHeaderParameter(context.header(CLIENT_ID), CLIENT_ID));
        HttpSession session = context.req().getSession();
        if (session.isNew()) {
            session.setAttribute(CLIENT_ID, (Object)headerClientId);
        } else {
            UUID sessionClientId = (UUID)session.getAttribute(CLIENT_ID);
            if (sessionClientId == null || !sessionClientId.equals(headerClientId)) {
                session.invalidate();
                throw new ServerAuthenticationException("Invalid client id");
            }
        }
        return headerClientId;
    }

    private static User user(Context context) throws ServerAuthenticationException {
        String basicAuth = context.header(AUTHORIZATION);
        if (NullOrEmpty.nullOrEmpty((String)basicAuth)) {
            throw new ServerAuthenticationException("Authorization information missing");
        }
        if (basicAuth.length() > BASIC_PREFIX_LENGTH && BASIC_PREFIX.equalsIgnoreCase(basicAuth.substring(0, BASIC_PREFIX_LENGTH))) {
            return User.parse((String)new String(Base64.getDecoder().decode(basicAuth.substring(BASIC_PREFIX_LENGTH))));
        }
        throw new ServerAuthenticationException("Invalid authorization format");
    }

    private static String checkHeaderParameter(String header, String headerParameter) throws ServerAuthenticationException {
        if (NullOrEmpty.nullOrEmpty((String)header)) {
            throw new ServerAuthenticationException(headerParameter + " header parameter is missing");
        }
        return header;
    }

    private static void handleException(Context context, Exception exception) {
        LOG.error(exception.getMessage(), (Throwable)exception);
        context.status(EntityService.exceptionStatus(exception)).result(EntityService.exceptionResult(exception));
    }

    private static int exceptionStatus(Exception exception) {
        if (exception instanceof ServerAuthenticationException) {
            return 401;
        }
        return 500;
    }

    private static byte[] exceptionResult(Exception exception) {
        try {
            return Serializer.serialize((Object)exception);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                return Serializer.serialize((Object)e);
            }
            catch (IOException io) {
                LOG.error(e.getMessage(), (Throwable)io);
                return new byte[0];
            }
        }
    }

    private static <T> T deserialize(HttpServletRequest request) throws IOException, ClassNotFoundException {
        return (T)new ObjectInputStream((InputStream)request.getInputStream()).readObject();
    }

    private static synchronized void resolveClasspathKeyStore() {
        String keystore = (String)HTTP_SERVER_CLASSPATH_KEYSTORE.get();
        if (NullOrEmpty.nullOrEmpty((String)keystore)) {
            LOG.debug("No classpath key store specified via {}", (Object)HTTP_SERVER_CLASSPATH_KEYSTORE.propertyName());
            return;
        }
        if (HTTP_SERVER_KEYSTORE_PATH.isNotNull()) {
            throw new IllegalStateException("Classpath keystore (" + keystore + ") can not be specified when " + HTTP_SERVER_KEYSTORE_PATH.propertyName() + " is already set to " + (String)HTTP_SERVER_KEYSTORE_PATH.get());
        }
        try (InputStream inputStream = EntityService.class.getClassLoader().getResourceAsStream(keystore);){
            if (inputStream == null) {
                LOG.debug("Specified key store not found on classpath: {}", (Object)keystore);
                return;
            }
            File file = File.createTempFile("serverKeyStore", "tmp");
            Files.write(file.toPath(), EntityService.readBytes(inputStream), new OpenOption[0]);
            file.deleteOnExit();
            HTTP_SERVER_KEYSTORE_PATH.set((Object)file.getPath());
            LOG.debug("Classpath key store {} written to file {} and set as {}", new Object[]{HTTP_SERVER_CLASSPATH_KEYSTORE.propertyName(), file, HTTP_SERVER_KEYSTORE_PATH.propertyName()});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] readBytes(InputStream stream) throws IOException {
        int line;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((line = stream.read(buffer)) != -1) {
            os.write(buffer, 0, line);
        }
        os.flush();
        return os.toByteArray();
    }

    static {
        EntityService.resolveClasspathKeyStore();
    }

    private final class JavalinConfigurer
    implements Consumer<JavalinConfig> {
        private JavalinConfigurer() {
        }

        @Override
        public void accept(JavalinConfig config) {
            if (EntityService.this.sslEnabled) {
                config.registerPlugin((Plugin)new SslPlugin((Consumer)new SslPLuginConfigurer()));
            }
        }
    }

    private final class EntitiesHandler
    implements Handler {
        private EntitiesHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                context.status(200).result(Serializer.serialize((Object)connection.entities()));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class CloseHandler
    implements Handler {
        private CloseHandler() {
        }

        public void handle(Context context) {
            try {
                EntityService.this.authenticate(context).close();
                context.req().getSession().invalidate();
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class IsTransactionOpenHandler
    implements Handler {
        private IsTransactionOpenHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)connection.transactionOpen()));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class IsTransactionOpenJsonHandler
    implements Handler {
        private IsTransactionOpenJsonHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)connection.transactionOpen()));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class StartTransactionHandler
    implements Handler {
        private StartTransactionHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                connection.startTransaction();
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class RollbackTransactionHandler
    implements Handler {
        private RollbackTransactionHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                connection.rollbackTransaction();
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class CommitTransactionHandler
    implements Handler {
        private CommitTransactionHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                connection.commitTransaction();
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class IsQueryCacheEnabledHandler
    implements Handler {
        private IsQueryCacheEnabledHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)connection.isQueryCacheEnabled()));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class IsQueryCacheEnabledJsonHandler
    implements Handler {
        private IsQueryCacheEnabledJsonHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)connection.isQueryCacheEnabled()));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class SetQueryCacheEnabledHandler
    implements Handler {
        private SetQueryCacheEnabledHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                connection.setQueryCacheEnabled(((Boolean)EntityService.deserialize(context.req())).booleanValue());
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class SetQueryCacheEnabledJsonHandler
    implements Handler {
        private SetQueryCacheEnabledJsonHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                connection.setQueryCacheEnabled(((Boolean)objectMapper.readValue((InputStream)context.req().getInputStream(), Boolean.class)).booleanValue());
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class ProcedureHandler
    implements Handler {
        private ProcedureHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                List parameters = (List)EntityService.deserialize(context.req());
                Object argument = parameters.size() > 1 ? parameters.get(1) : null;
                connection.execute((ProcedureType)parameters.get(0), argument);
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class FunctionHandler
    implements Handler {
        private FunctionHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                List parameters = (List)EntityService.deserialize(context.req());
                FunctionType functionType = (FunctionType)parameters.get(0);
                Object argument = parameters.size() > 1 ? parameters.get(1) : null;
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)connection.execute(functionType, argument)));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class ReportHandler
    implements Handler {
        private ReportHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                List parameters = (List)EntityService.deserialize(context.req());
                ReportType reportType = (ReportType)parameters.get(0);
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)connection.report(reportType, parameters.get(1))));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class DependenciesHandler
    implements Handler {
        private DependenciesHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)connection.dependencies((Collection)EntityService.deserialize(context.req()))));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class DependenciesJsonHandler
    implements Handler {
        private DependenciesJsonHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                List entities = (List)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityObjectMapper.ENTITY_LIST_REFERENCE);
                Map dependencies = connection.dependencies((Collection)entities);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)dependencies));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class CountHandler
    implements Handler {
        private CountHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                int rowCount = connection.count((EntityConnection.Count)EntityService.deserialize(context.req()));
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)rowCount));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class CountJsonHandler
    implements Handler {
        private CountJsonHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                int rowCount = connection.count((EntityConnection.Count)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityConnection.Count.class));
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)rowCount));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class ValuesHandler
    implements Handler {
        private ValuesHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                List parameters = (List)EntityService.deserialize(context.req());
                List values = connection.select((Column)parameters.get(0), (EntityConnection.Select)parameters.get(1));
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)values));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class ValuesJsonHandler
    implements Handler {
        private ValuesJsonHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                Entities entities = connection.entities();
                ObjectMapper objectMapper = EntityService.this.objectMapper(entities);
                JsonNode jsonNode = objectMapper.readTree((InputStream)context.req().getInputStream());
                EntityType entityType = entities.domainType().entityType(jsonNode.get("entityType").asText());
                Column column = (Column)entities.definition(entityType).attributes().get(jsonNode.get("column").textValue());
                EntityConnection.Select select = null;
                JsonNode conditionNode = jsonNode.get("condition");
                if (conditionNode != null) {
                    select = (EntityConnection.Select)objectMapper.readValue(conditionNode.toString(), EntityConnection.Select.class);
                }
                List values = connection.select(column, select);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)values));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class SelectByKeyHandler
    implements Handler {
        private SelectByKeyHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                List keys = (List)EntityService.deserialize(context.req());
                Collection selected = connection.select((Collection)keys);
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)selected));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class SelectByKeyJsonHandler
    implements Handler {
        private SelectByKeyJsonHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                List keys = (List)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityObjectMapper.KEY_LIST_REFERENCE);
                Collection selected = connection.select((Collection)keys);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)selected));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class SelectHandler
    implements Handler {
        private SelectHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                EntityConnection.Select select = (EntityConnection.Select)EntityService.deserialize(context.req());
                List selected = connection.select(select);
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)selected));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class SelectJsonHandler
    implements Handler {
        private SelectJsonHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                EntityConnection.Select selectJson = (EntityConnection.Select)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityConnection.Select.class);
                List selected = connection.select(selectJson);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)selected));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class InsertHandler
    implements Handler {
        private InsertHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                Collection keys = connection.insert((Collection)EntityService.deserialize(context.req()));
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)keys));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class InsertSelectHandler
    implements Handler {
        private InsertSelectHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                Collection entities = connection.insertSelect((Collection)EntityService.deserialize(context.req()));
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)entities));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class InsertJsonHandler
    implements Handler {
        private InsertJsonHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                Collection entities = (Collection)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityObjectMapper.ENTITY_LIST_REFERENCE);
                Collection keys = connection.insert(entities);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)keys));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class InsertSelectJsonHandler
    implements Handler {
        private InsertSelectJsonHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                Collection entities = (Collection)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityObjectMapper.ENTITY_LIST_REFERENCE);
                Collection inserted = connection.insertSelect(entities);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)inserted));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class UpdateHandler
    implements Handler {
        private UpdateHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                connection.update((Collection)((List)EntityService.deserialize(context.req())));
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class UpdateSelectHandler
    implements Handler {
        private UpdateSelectHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                Collection updated = connection.updateSelect((Collection)((List)EntityService.deserialize(context.req())));
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)updated));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class UpdateJsonHandler
    implements Handler {
        private UpdateJsonHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                List entities = (List)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityObjectMapper.ENTITY_LIST_REFERENCE);
                connection.update((Collection)entities);
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class UpdateSelectJsonHandler
    implements Handler {
        private UpdateSelectJsonHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                List entities = (List)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityObjectMapper.ENTITY_LIST_REFERENCE);
                Collection updated = connection.updateSelect((Collection)entities);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)updated));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class UpdateByConditionHandler
    implements Handler {
        private UpdateByConditionHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                int updateCount = connection.update((EntityConnection.Update)EntityService.deserialize(context.req()));
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)updateCount));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class UpdateByConditionJsonHandler
    implements Handler {
        private UpdateByConditionJsonHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                EntityConnection.Update update = (EntityConnection.Update)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityConnection.Update.class);
                int updateCount = connection.update(update);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)updateCount));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class DeleteHandler
    implements Handler {
        private DeleteHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                Condition condition = (Condition)EntityService.deserialize(context.req());
                int deleteCount = connection.delete(condition);
                context.status(200).contentType(ContentType.APPLICATION_OCTET_STREAM).result(Serializer.serialize((Object)deleteCount));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class DeleteJsonHandler
    implements Handler {
        private DeleteJsonHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                Condition deleteCondition = (Condition)objectMapper.readValue((InputStream)context.req().getInputStream(), Condition.class);
                int deleteCount = connection.delete(deleteCondition);
                context.status(200).contentType(ContentType.APPLICATION_JSON).result(objectMapper.writeValueAsString((Object)deleteCount));
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class DeleteByKeyHandler
    implements Handler {
        private DeleteByKeyHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                List keys = (List)EntityService.deserialize(context.req());
                connection.delete((Collection)keys);
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class DeleteByKeyJsonHandler
    implements Handler {
        private DeleteByKeyJsonHandler() {
        }

        public void handle(Context context) {
            try {
                RemoteEntityConnection connection = EntityService.this.authenticate(context);
                ObjectMapper objectMapper = EntityService.this.objectMapper(connection.entities());
                List keys = (List)objectMapper.readValue((InputStream)context.req().getInputStream(), EntityObjectMapper.KEY_LIST_REFERENCE);
                connection.delete((Collection)keys);
                context.status(200);
            }
            catch (Exception e) {
                EntityService.handleException(context, e);
            }
        }
    }

    private final class SslPLuginConfigurer
    implements Consumer<SslConfig> {
        private SslPLuginConfigurer() {
        }

        @Override
        public void accept(SslConfig ssl) {
            ssl.keystoreFromPath((String)HTTP_SERVER_KEYSTORE_PATH.getOrThrow(), (String)HTTP_SERVER_KEYSTORE_PASSWORD.getOrThrow());
            ssl.securePort = EntityService.this.securePort;
            ssl.insecurePort = EntityService.this.port;
        }
    }
}

