/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.server;

import is.codion.common.db.connection.DatabaseConnection;
import is.codion.common.db.database.Database;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.pool.ConnectionPoolWrapper;
import is.codion.common.logging.MethodLogger;
import is.codion.common.rmi.server.ClientLog;
import is.codion.common.rmi.server.RemoteClient;
import is.codion.common.user.User;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.local.LocalEntityConnection;
import is.codion.framework.domain.Domain;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

final class LocalConnectionHandler
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LocalConnectionHandler.class);
    private static final String LOG_IDENTIFIER_PROPERTY = "logIdentifier";
    private static final String FETCH_CONNECTION = "fetchConnection";
    private static final String RETURN_CONNECTION = "returnConnection";
    private static final String ENTITIES = "entities";
    static final RequestCounter REQUEST_COUNTER = new RequestCounter();
    private final Domain domain;
    private final RemoteClient remoteClient;
    private final Database database;
    private final ConnectionPoolWrapper connectionPool;
    private final MethodLogger methodLogger;
    private final String logIdentifier;
    private final String userDescription;
    private final long creationTime = System.currentTimeMillis();
    private final AtomicBoolean active = new AtomicBoolean(false);
    private LocalEntityConnection localEntityConnection;
    private LocalEntityConnection poolEntityConnection;
    private long lastAccessTime = this.creationTime;
    private boolean closed = false;

    LocalConnectionHandler(Domain domain, RemoteClient remoteClient, Database database) throws DatabaseException {
        this.domain = domain;
        this.remoteClient = remoteClient;
        String databaseUsername = remoteClient.databaseUser().username();
        this.connectionPool = database.containsConnectionPool(databaseUsername) ? database.connectionPool(databaseUsername) : null;
        this.database = database;
        this.methodLogger = MethodLogger.methodLogger((int)((Integer)LocalEntityConnection.CONNECTION_LOG_SIZE.get()), (MethodLogger.ArgumentToString)new EntityArgumentToString());
        this.logIdentifier = remoteClient.user().username().toLowerCase() + "@" + remoteClient.clientTypeId();
        this.userDescription = "Remote user: " + remoteClient.user().username() + ", database user: " + databaseUsername;
        try {
            if (this.connectionPool == null) {
                this.localEntityConnection = LocalEntityConnection.localEntityConnection((Database)database, (Domain)domain, (User)remoteClient.databaseUser());
                this.localEntityConnection.databaseConnection().setMethodLogger(this.methodLogger);
            } else {
                this.poolEntityConnection = LocalEntityConnection.localEntityConnection((Database)database, (Domain)domain, (Connection)this.connectionPool.connection(remoteClient.databaseUser()));
                LocalConnectionHandler.rollbackSilently(this.poolEntityConnection.databaseConnection());
                this.returnConnectionToPool();
            }
        }
        catch (DatabaseException e) {
            this.close();
            throw e;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        if (method.getName().equals(ENTITIES)) {
            return this.entities();
        }
        this.active.set(true);
        this.lastAccessTime = System.currentTimeMillis();
        String methodName = method.getName();
        Exception exception = null;
        try {
            this.logEntry(methodName, args);
            Object object = method.invoke((Object)this.fetchConnection(), args);
            this.returnConnection();
            this.logExit(methodName, exception);
            this.active.set(false);
            return object;
        }
        catch (InvocationTargetException e) {
            try {
                Exception exception2;
                if (e.getCause() instanceof Exception) {
                    exception2 = (Exception)e.getCause();
                    throw exception2;
                }
                exception2 = e;
                throw exception2;
                catch (Exception e2) {
                    LOG.error(e2.getMessage(), (Throwable)e2);
                    exception = e2;
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                this.returnConnection();
                this.logExit(methodName, exception);
                this.active.set(false);
                throw throwable;
            }
        }
    }

    private Entities entities() {
        this.active.set(true);
        this.lastAccessTime = System.currentTimeMillis();
        try {
            this.logEntry(ENTITIES, null);
            Entities entities = this.domain.entities();
            return entities;
        }
        finally {
            this.logExit(ENTITIES, null);
            this.active.set(false);
        }
    }

    private void logEntry(String methodName, Object[] args) {
        MDC.put((String)LOG_IDENTIFIER_PROPERTY, (String)this.logIdentifier);
        REQUEST_COUNTER.incrementRequestsPerSecondCounter();
        if (this.methodLogger.isEnabled()) {
            this.methodLogger.enter(methodName, (Object)args);
        }
    }

    private void logExit(String methodName, Exception exception) {
        if (this.methodLogger.isEnabled()) {
            MethodLogger.Entry entry = this.methodLogger.exit(methodName, exception);
            StringBuilder messageBuilder = new StringBuilder(this.remoteClient.toString()).append("\n");
            entry.appendTo(messageBuilder);
            LOG.info(messageBuilder.toString());
        }
        MDC.remove((String)LOG_IDENTIFIER_PROPERTY);
    }

    boolean connected() {
        if (this.connectionPool != null) {
            return !this.closed;
        }
        return !this.closed && this.localEntityConnection != null && this.localEntityConnection.connected();
    }

    void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.cleanupLocalConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientLog clientLog() {
        MethodLogger methodLogger = this.methodLogger;
        synchronized (methodLogger) {
            return ClientLog.clientLog((UUID)this.remoteClient.clientId(), (List)this.methodLogger.entries());
        }
    }

    RemoteClient remoteClient() {
        return this.remoteClient;
    }

    long lastAccessTime() {
        return this.lastAccessTime;
    }

    MethodLogger methodLogger() {
        return this.methodLogger;
    }

    boolean active() {
        return this.active.get();
    }

    boolean closed() {
        return this.closed;
    }

    private EntityConnection fetchConnection() throws DatabaseException {
        DatabaseException exception = null;
        try {
            if (this.methodLogger.isEnabled()) {
                this.methodLogger.enter(FETCH_CONNECTION, (Object)this.userDescription);
            }
            if (this.connectionPool != null) {
                EntityConnection entityConnection = this.pooledEntityConnection();
                return entityConnection;
            }
            EntityConnection entityConnection = this.localEntityConnection();
            return entityConnection;
        }
        catch (DatabaseException ex) {
            exception = ex;
            throw ex;
        }
        finally {
            if (this.methodLogger.isEnabled()) {
                this.methodLogger.exit(FETCH_CONNECTION, (Exception)((Object)exception));
            }
        }
    }

    private EntityConnection pooledEntityConnection() throws DatabaseException {
        if (this.poolEntityConnection.transactionOpen()) {
            return this.poolEntityConnection;
        }
        this.poolEntityConnection.databaseConnection().setConnection(this.connectionPool.connection(this.remoteClient.databaseUser()));
        this.poolEntityConnection.databaseConnection().setMethodLogger(this.methodLogger);
        return this.poolEntityConnection;
    }

    private EntityConnection localEntityConnection() throws DatabaseException {
        if (!this.localEntityConnection.connected()) {
            this.localEntityConnection.close();
            this.localEntityConnection = LocalEntityConnection.localEntityConnection((Database)this.database, (Domain)this.domain, (User)this.remoteClient.databaseUser());
            this.localEntityConnection.databaseConnection().setMethodLogger(this.methodLogger);
        }
        return this.localEntityConnection;
    }

    private void returnConnection() {
        if (this.poolEntityConnection == null || this.poolEntityConnection.transactionOpen()) {
            return;
        }
        try {
            if (this.methodLogger.isEnabled()) {
                this.methodLogger.enter(RETURN_CONNECTION, (Object)this.userDescription);
            }
            this.poolEntityConnection.databaseConnection().setMethodLogger(null);
            this.returnConnectionToPool();
        }
        catch (Exception e) {
            LOG.info("Exception while returning connection to pool", (Throwable)e);
        }
        finally {
            if (this.methodLogger.isEnabled()) {
                this.methodLogger.exit(RETURN_CONNECTION, null, null);
            }
        }
    }

    private void returnConnectionToPool() {
        Connection connection = this.poolEntityConnection.databaseConnection().getConnection();
        if (connection != null) {
            LocalConnectionHandler.closeSilently(connection);
            this.poolEntityConnection.databaseConnection().setConnection(null);
        }
    }

    private void cleanupLocalConnections() {
        if (this.poolEntityConnection != null) {
            this.rollbackIfRequired(this.poolEntityConnection);
            this.returnConnectionToPool();
            this.poolEntityConnection = null;
        }
        if (this.localEntityConnection != null) {
            this.rollbackIfRequired(this.localEntityConnection);
            this.localEntityConnection.close();
            this.localEntityConnection = null;
        }
    }

    private void rollbackIfRequired(LocalEntityConnection entityConnection) {
        if (entityConnection.transactionOpen()) {
            LOG.info("Rollback open transaction on disconnect: {}", (Object)this.remoteClient);
            entityConnection.rollbackTransaction();
        }
    }

    private static void rollbackSilently(DatabaseConnection databaseConnection) {
        try {
            databaseConnection.rollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static void closeSilently(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class EntityArgumentToString
    extends MethodLogger.DefaultArgumentToString {
        private static final String PREPARE_STATEMENT = "prepareStatement";

        private EntityArgumentToString() {
        }

        protected String toString(String methodName, Object object) {
            if (LocalConnectionHandler.ENTITIES.equals(methodName)) {
                return "";
            }
            if (PREPARE_STATEMENT.equals(methodName)) {
                return (String)object;
            }
            return this.toString(object);
        }

        protected String toString(Object object) {
            if (object == null) {
                return "null";
            }
            if (object instanceof String) {
                return "'" + object + "'";
            }
            if (object instanceof Entity) {
                return EntityArgumentToString.entityToString((Entity)object);
            }
            if (object instanceof Entity.Key) {
                return EntityArgumentToString.entityKeyToString((Entity.Key)object);
            }
            return super.toString(object);
        }

        private static String entityToString(Entity entity) {
            StringBuilder builder = new StringBuilder(entity.entityType().name()).append(" {");
            for (ColumnDefinition columnDefinition : entity.definition().columns().definitions()) {
                boolean modified = entity.modified((Attribute)columnDefinition.attribute());
                if (!columnDefinition.primaryKey() && !modified) continue;
                StringBuilder valueString = new StringBuilder();
                if (modified) {
                    valueString.append(entity.original((Attribute)columnDefinition.attribute())).append("->");
                }
                valueString.append(entity.string((Attribute)columnDefinition.attribute()));
                builder.append(columnDefinition.attribute()).append(":").append((CharSequence)valueString).append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
            return builder.append("}").toString();
        }

        private static String entityKeyToString(Entity.Key key) {
            return key.entityType() + " {" + key + "}";
        }
    }

    static final class RequestCounter {
        private static final int DEFAULT_REQUEST_COUNTER_UPDATE_INTERVAL = 2500;
        private static final double THOUSAND = 1000.0;
        private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory());
        private final AtomicLong requestsPerSecondTime = new AtomicLong(System.currentTimeMillis());
        private final AtomicInteger requestsPerSecond = new AtomicInteger();
        private final AtomicInteger requestsPerSecondCounter = new AtomicInteger();

        private RequestCounter() {
            this.executorService.scheduleWithFixedDelay(this::updateRequestsPerSecond, 2500L, 2500L, TimeUnit.MILLISECONDS);
        }

        int requestsPerSecond() {
            return this.requestsPerSecond.get();
        }

        private void updateRequestsPerSecond() {
            long current = System.currentTimeMillis();
            double seconds = (double)(current - this.requestsPerSecondTime.get()) / 1000.0;
            if (seconds > 0.0) {
                this.requestsPerSecond.set((int)((double)this.requestsPerSecondCounter.get() / seconds));
                this.requestsPerSecondCounter.set(0);
                this.requestsPerSecondTime.set(current);
            }
        }

        private void incrementRequestsPerSecondCounter() {
            this.requestsPerSecondCounter.incrementAndGet();
        }
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

