/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.server;

import is.codion.common.Configuration;
import is.codion.common.NullOrEmpty;
import is.codion.common.Text;
import is.codion.common.db.database.Database;
import is.codion.common.property.PropertyValue;
import is.codion.common.rmi.server.ServerConfiguration;
import is.codion.common.user.User;
import is.codion.framework.server.DefaultEntityServerConfiguration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface EntityServerConfiguration
extends ServerConfiguration {
    public static final Logger LOG = LoggerFactory.getLogger(EntityServerConfiguration.class);
    public static final int DEFAULT_CONNECTION_LIMIT = -1;
    public static final PropertyValue<Integer> CONNECTION_LIMIT = Configuration.integerValue((String)"codion.server.connectionLimit", (int)-1);
    public static final PropertyValue<String> CONNECTION_POOL_FACTORY_CLASS = Configuration.stringValue((String)"codion.server.pooling.poolFactoryClass");
    public static final PropertyValue<String> CLIENT_CONNECTION_TIMEOUT = Configuration.stringValue((String)"codion.server.clientConnectionTimeout");
    public static final PropertyValue<Boolean> CLIENT_LOGGING = Configuration.booleanValue((String)"codion.server.clientLogging", (boolean)false);
    public static final PropertyValue<String> CONNECTION_POOL_USERS = Configuration.stringValue((String)"codion.server.connectionPoolUsers");
    public static final PropertyValue<String> DOMAIN_MODEL_CLASSES = Configuration.stringValue((String)"codion.server.domain.classes");

    public Database database();

    public User adminUser();

    public int connectionLimit();

    public boolean clientLogging();

    public int idleConnectionTimeout();

    public String connectionPoolFactory();

    public Collection<String> domainClassNames();

    public Collection<User> connectionPoolUsers();

    public Map<String, Integer> clientTypeIdleConnectionTimeouts();

    public static Builder builder(int serverPort, int registryPort) {
        return new DefaultEntityServerConfiguration.DefaultBuilder(serverPort, registryPort);
    }

    public static Builder builderFromSystemProperties() {
        User adminUser;
        Builder builder = ((Builder)((Builder)((Builder)((Builder)EntityServerConfiguration.builder((Integer)SERVER_PORT.getOrThrow(), (Integer)REGISTRY_PORT.getOrThrow()).auxiliaryServerFactoryClassNames(Text.parseCommaSeparatedValues((String)((String)AUXILIARY_SERVER_FACTORY_CLASS_NAMES.get())))).sslEnabled((Boolean)SSL_ENABLED.get())).objectInputFilterFactoryClassName((String)OBJECT_INPUT_FILTER_FACTORY_CLASS_NAME.get())).adminPort(Objects.requireNonNull((Integer)ADMIN_PORT.get(), ADMIN_PORT.toString()))).connectionLimit((Integer)CONNECTION_LIMIT.get()).database(Database.instance()).domainClassNames(Text.parseCommaSeparatedValues((String)((String)DOMAIN_MODEL_CLASSES.get()))).connectionPoolUsers(Text.parseCommaSeparatedValues((String)((String)CONNECTION_POOL_USERS.get())).stream().map(User::parse).collect(Collectors.toList())).clientLogging((Boolean)CLIENT_LOGGING.get()).idleConnectionTimeout((Integer)IDLE_CONNECTION_TIMEOUT.get());
        HashMap<String, Integer> clientTypeIdleConnectionTimeoutMap = new HashMap<String, Integer>();
        for (String clientTimeout : Text.parseCommaSeparatedValues((String)((String)CLIENT_CONNECTION_TIMEOUT.get()))) {
            String[] split = clientTimeout.split(":");
            if (split.length < 2) {
                throw new IllegalArgumentException("Expecting a ':' delimiter");
            }
            clientTypeIdleConnectionTimeoutMap.put(split[0], Integer.parseInt(split[1]));
        }
        builder.clientTypeIdleConnectionTimeouts(clientTypeIdleConnectionTimeoutMap);
        String adminUserString = (String)ADMIN_USER.get();
        User user = adminUser = NullOrEmpty.nullOrEmpty((String)adminUserString) ? null : User.parse((String)adminUserString);
        if (adminUser == null) {
            LOG.info("No admin user specified");
        } else {
            LOG.info("Admin user: {}", (Object)adminUser);
            builder.adminUser(adminUser);
        }
        return builder;
    }

    public static interface Builder
    extends ServerConfiguration.Builder<Builder> {
        public Builder database(Database var1);

        public Builder adminUser(User var1);

        public Builder connectionLimit(int var1);

        public Builder clientLogging(boolean var1);

        public Builder idleConnectionTimeout(int var1);

        public Builder connectionPoolFactory(String var1);

        public Builder domainClassNames(Collection<String> var1);

        public Builder connectionPoolUsers(Collection<User> var1);

        public Builder clientTypeIdleConnectionTimeouts(Map<String, Integer> var1);

        public EntityServerConfiguration build();
    }
}

