/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.server;

import is.codion.common.db.database.Database;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.event.Event;
import is.codion.common.rmi.server.ClientLog;
import is.codion.common.rmi.server.RemoteClient;
import is.codion.common.user.User;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.Domain;
import is.codion.framework.server.LocalConnectionHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteEntityConnection
extends UnicastRemoteObject {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRemoteEntityConnection.class);
    protected final transient EntityConnection connectionProxy;
    private final transient LocalConnectionHandler connectionHandler;
    private final transient Event<AbstractRemoteEntityConnection> disconnectedEvent = Event.event();

    protected AbstractRemoteEntityConnection(Domain domain, Database database, RemoteClient remoteClient, int port, RMIClientSocketFactory clientSocketFactory, RMIServerSocketFactory serverSocketFactory) throws DatabaseException, RemoteException {
        super(port, clientSocketFactory, serverSocketFactory);
        this.connectionHandler = new LocalConnectionHandler(domain, remoteClient, database);
        this.connectionProxy = (EntityConnection)Proxy.newProxyInstance(EntityConnection.class.getClassLoader(), new Class[]{EntityConnection.class}, (InvocationHandler)this.connectionHandler);
    }

    public final User user() {
        return this.connectionHandler.remoteClient().user();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean connected() {
        EntityConnection entityConnection = this.connectionProxy;
        synchronized (entityConnection) {
            return this.connectionHandler.connected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        EntityConnection entityConnection = this.connectionProxy;
        synchronized (entityConnection) {
            if (this.connectionHandler.closed()) {
                return;
            }
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            this.connectionHandler.close();
        }
        this.disconnectedEvent.accept((Object)this);
    }

    final RemoteClient remoteClient() {
        return this.connectionHandler.remoteClient();
    }

    final ClientLog clientLog() {
        return this.connectionHandler.clientLog();
    }

    final boolean hasBeenInactive(int timeout) {
        return System.currentTimeMillis() - this.connectionHandler.lastAccessTime() > (long)timeout;
    }

    final void setLoggingEnabled(boolean status) {
        this.connectionHandler.methodLogger().setEnabled(status);
    }

    final boolean isLoggingEnabled() {
        return this.connectionHandler.methodLogger().isEnabled();
    }

    final boolean active() {
        return this.connectionHandler.active();
    }

    final void addDisconnectListener(Consumer<AbstractRemoteEntityConnection> listener) {
        this.disconnectedEvent.addDataListener(listener);
    }

    static int requestsPerSecond() {
        return LocalConnectionHandler.REQUEST_COUNTER.requestsPerSecond();
    }
}

