/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.server;

import is.codion.common.db.database.Database;
import is.codion.common.db.pool.ConnectionPoolStatistics;
import is.codion.common.logging.LoggerProxy;
import is.codion.common.rmi.server.AbstractServer;
import is.codion.common.rmi.server.ClientLog;
import is.codion.common.rmi.server.DefaultServerAdmin;
import is.codion.common.rmi.server.ServerConfiguration;
import is.codion.framework.server.AbstractRemoteEntityConnection;
import is.codion.framework.server.EntityServer;
import is.codion.framework.server.EntityServerAdmin;
import is.codion.framework.server.EntityServerConfiguration;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultEntityServerAdmin
extends DefaultServerAdmin
implements EntityServerAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEntityServerAdmin.class);
    private static final long serialVersionUID = 1L;
    private final EntityServer server;
    private final LoggerProxy loggerProxy = LoggerProxy.instance();

    DefaultEntityServerAdmin(EntityServer server, EntityServerConfiguration configuration) throws RemoteException {
        super((AbstractServer)server, (ServerConfiguration)configuration);
        this.server = server;
    }

    @Override
    public String databaseUrl() {
        return this.server.database().url();
    }

    @Override
    public Object getLogLevel() {
        return this.loggerProxy.getLogLevel();
    }

    @Override
    public void setLogLevel(Object level) {
        LOG.info("setLogLevel({})", level);
        this.loggerProxy.setLogLevel(level);
    }

    @Override
    public int getMaintenanceInterval() {
        return this.server.getMaintenanceInterval();
    }

    @Override
    public void setMaintenanceInterval(int interval) {
        LOG.info("setMaintenanceInterval({})", (Object)interval);
        this.server.setMaintenanceInterval(interval);
    }

    @Override
    public void disconnectTimedOutClients() throws RemoteException {
        LOG.info("disconnectTimedOutClients()");
        this.server.disconnectClients(true);
    }

    @Override
    public void disconnectAllClients() throws RemoteException {
        LOG.info("disconnectAllClients()");
        this.server.disconnectClients(false);
    }

    @Override
    public void resetConnectionPoolStatistics(String username) {
        LOG.info("resetConnectionPoolStatistics({})", (Object)username);
        this.server.database().connectionPool(username).resetStatistics();
    }

    @Override
    public boolean isCollectPoolSnapshotStatistics(String username) {
        return this.server.database().connectionPool(username).isCollectSnapshotStatistics();
    }

    @Override
    public void setCollectPoolSnapshotStatistics(String username, boolean snapshotStatistics) {
        LOG.info("setCollectPoolSnapshotStatistics({}, {})", (Object)username, (Object)snapshotStatistics);
        this.server.database().connectionPool(username).setCollectSnapshotStatistics(snapshotStatistics);
    }

    @Override
    public boolean isCollectPoolCheckOutTimes(String username) throws RemoteException {
        return this.server.database().connectionPool(username).isCollectCheckOutTimes();
    }

    @Override
    public void setCollectPoolCheckOutTimes(String username, boolean collectCheckOutTimes) throws RemoteException {
        LOG.info("setCollectPoolCheckOutTimes({}, {})", (Object)username, (Object)collectCheckOutTimes);
        this.server.database().connectionPool(username).setCollectCheckOutTimes(collectCheckOutTimes);
    }

    public int requestsPerSecond() {
        return AbstractRemoteEntityConnection.requestsPerSecond();
    }

    @Override
    public ConnectionPoolStatistics connectionPoolStatistics(String username, long since) {
        return this.server.database().connectionPool(username).statistics(since);
    }

    @Override
    public Database.Statistics databaseStatistics() {
        return this.server.databaseStatistics();
    }

    @Override
    public Collection<String> connectionPoolUsernames() {
        return this.server.database().connectionPoolUsernames();
    }

    @Override
    public int getConnectionPoolCleanupInterval(String username) {
        return this.server.database().connectionPool(username).getCleanupInterval();
    }

    @Override
    public void setConnectionPoolCleanupInterval(String username, int poolCleanupInterval) {
        LOG.info("setConnectionPoolCleanupInterval({}, {})", (Object)username, (Object)poolCleanupInterval);
        this.server.database().connectionPool(username).setCleanupInterval(poolCleanupInterval);
    }

    @Override
    public int getMaximumConnectionPoolSize(String username) {
        return this.server.database().connectionPool(username).getMaximumPoolSize();
    }

    @Override
    public void setMaximumConnectionPoolSize(String username, int value) {
        LOG.info("setMaximumConnectionPoolSize({}, {})", (Object)username, (Object)value);
        this.server.database().connectionPool(username).setMaximumPoolSize(value);
    }

    @Override
    public int getMinimumConnectionPoolSize(String username) {
        return this.server.database().connectionPool(username).getMinimumPoolSize();
    }

    @Override
    public void setMinimumConnectionPoolSize(String username, int value) {
        LOG.info("setMinimumConnectionPoolSize({}, {})", (Object)username, (Object)value);
        this.server.database().connectionPool(username).setMinimumPoolSize(value);
    }

    @Override
    public int getPooledConnectionIdleTimeout(String username) {
        return this.server.database().connectionPool(username).getIdleConnectionTimeout();
    }

    @Override
    public void setPooledConnectionIdleTimeout(String username, int pooledConnectionIdleTimeout) {
        LOG.info("setPooledConnectionIdleTimeout({}, {})", (Object)username, (Object)pooledConnectionIdleTimeout);
        this.server.database().connectionPool(username).setIdleConnectionTimeout(pooledConnectionIdleTimeout);
    }

    @Override
    public int getMaximumPoolCheckOutTime(String username) {
        return this.server.database().connectionPool(username).getMaximumCheckOutTime();
    }

    @Override
    public void setMaximumPoolCheckOutTime(String username, int value) {
        LOG.info("setMaximumPoolCheckOutTime({}, {})", (Object)username, (Object)value);
        this.server.database().connectionPool(username).setMaximumCheckOutTime(value);
    }

    @Override
    public ClientLog clientLog(UUID clientId) {
        return this.server.clientLog(clientId);
    }

    @Override
    public boolean isLoggingEnabled(UUID clientId) {
        return this.server.isLoggingEnabled(clientId);
    }

    @Override
    public void setLoggingEnabled(UUID clientId, boolean loggingEnabled) {
        LOG.info("setLoggingEnabled({}, {})", (Object)clientId, (Object)loggingEnabled);
        this.server.setLoggingEnabled(clientId, loggingEnabled);
    }

    @Override
    public int getIdleConnectionTimeout() {
        return this.server.getIdleConnectionTimeout();
    }

    @Override
    public void setIdleConnectionTimeout(int idleConnectionTimeout) {
        LOG.info("setIdleConnectionTimeout({})", (Object)idleConnectionTimeout);
        this.server.setIdleConnectionTimeout(idleConnectionTimeout);
    }

    @Override
    public Map<String, Collection<EntityServerAdmin.DomainEntityDefinition>> domainEntityDefinitions() {
        HashMap<String, Collection<EntityServerAdmin.DomainEntityDefinition>> domainEntityDefinitions = new HashMap<String, Collection<EntityServerAdmin.DomainEntityDefinition>>();
        this.server.domainEntityDefinitions().forEach((domainType, domainDefinitions) -> domainEntityDefinitions.put(domainType.name(), (Collection<EntityServerAdmin.DomainEntityDefinition>)domainDefinitions));
        return domainEntityDefinitions;
    }

    @Override
    public Map<String, Collection<EntityServerAdmin.DomainReport>> domainReports() throws RemoteException {
        HashMap<String, Collection<EntityServerAdmin.DomainReport>> domainReports = new HashMap<String, Collection<EntityServerAdmin.DomainReport>>();
        this.server.domainReports().forEach((domainType, reports) -> domainReports.put(domainType.name(), (Collection<EntityServerAdmin.DomainReport>)reports));
        return domainReports;
    }

    @Override
    public Map<String, Collection<EntityServerAdmin.DomainOperation>> domainOperations() throws RemoteException {
        HashMap<String, Collection<EntityServerAdmin.DomainOperation>> domainOperations = new HashMap<String, Collection<EntityServerAdmin.DomainOperation>>();
        this.server.domainOperations().forEach((domainType, operations) -> domainOperations.put(domainType.name(), (Collection<EntityServerAdmin.DomainOperation>)operations));
        return domainOperations;
    }

    @Override
    public void clearReportCache() throws RemoteException {
        this.server.clearReportCache();
    }
}

