/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.server;

import is.codion.common.NullOrEmpty;
import is.codion.common.db.database.Database;
import is.codion.common.db.exception.AuthenticationException;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.operation.DatabaseFunction;
import is.codion.common.db.operation.DatabaseProcedure;
import is.codion.common.db.operation.FunctionType;
import is.codion.common.db.operation.ProcedureType;
import is.codion.common.db.pool.ConnectionPoolFactory;
import is.codion.common.db.report.Report;
import is.codion.common.db.report.ReportType;
import is.codion.common.rmi.client.Clients;
import is.codion.common.rmi.server.AbstractServer;
import is.codion.common.rmi.server.AuxiliaryServer;
import is.codion.common.rmi.server.ClientLog;
import is.codion.common.rmi.server.RemoteClient;
import is.codion.common.rmi.server.Server;
import is.codion.common.rmi.server.ServerConfiguration;
import is.codion.common.rmi.server.exception.LoginException;
import is.codion.common.rmi.server.exception.ServerAuthenticationException;
import is.codion.common.user.User;
import is.codion.framework.db.local.LocalEntityConnection;
import is.codion.framework.domain.Domain;
import is.codion.framework.domain.DomainType;
import is.codion.framework.server.AbstractRemoteEntityConnection;
import is.codion.framework.server.DefaultEntityServerAdmin;
import is.codion.framework.server.DefaultRemoteEntityConnection;
import is.codion.framework.server.EntityServerAdmin;
import is.codion.framework.server.EntityServerConfiguration;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityServer
extends AbstractServer<AbstractRemoteEntityConnection, EntityServerAdmin> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(EntityServer.class);
    private static final String SHUTDOWN = "shutdown";
    private final EntityServerConfiguration configuration;
    private final Map<DomainType, Domain> domainModels;
    private final Database database;
    private final boolean clientLogging;
    private final Map<String, Integer> clientTypeIdleConnectionTimeouts = new HashMap<String, Integer>();
    private int idleConnectionTimeout;

    public EntityServer(EntityServerConfiguration configuration) throws RemoteException {
        super((ServerConfiguration)configuration);
        this.addShutdownListener(new ShutdownListener());
        this.configuration = configuration;
        try {
            this.database = Objects.requireNonNull(configuration.database(), "database");
            this.clientLogging = configuration.clientLogging();
            this.domainModels = EntityServer.loadDomainModels(configuration.domainClassNames());
            EntityServer.configureDatabase(this.domainModels.values(), this.database);
            this.setAdmin(this.createServerAdmin(configuration));
            this.setIdleConnectionTimeout(configuration.idleConnectionTimeout());
            this.setClientTypeIdleConnectionTimeouts(configuration.clientTypeIdleConnectionTimeouts());
            EntityServer.createConnectionPools(configuration.database(), configuration.connectionPoolFactory(), configuration.connectionPoolUsers());
            this.setConnectionLimit(configuration.connectionLimit());
            this.registry().rebind(this.serverInformation().serverName(), (Remote)((Object)this));
        }
        catch (Throwable t) {
            throw (RuntimeException)this.logShutdownAndReturn(new RuntimeException(t));
        }
    }

    public final EntityServerAdmin serverAdmin(User user) throws ServerAuthenticationException {
        EntityServer.validateUserCredentials((User)user, (User)this.configuration.adminUser());
        return (EntityServerAdmin)this.getAdmin();
    }

    public final int serverLoad() {
        return AbstractRemoteEntityConnection.requestsPerSecond();
    }

    protected final AbstractRemoteEntityConnection connect(RemoteClient remoteClient) throws RemoteException, LoginException {
        Objects.requireNonNull(remoteClient, "remoteClient");
        try {
            AbstractRemoteEntityConnection connection = this.createRemoteConnection(this.database(), remoteClient, this.configuration.port(), this.configuration.rmiClientSocketFactory(), this.configuration.rmiServerSocketFactory());
            connection.setLoggingEnabled(this.clientLogging);
            connection.addDisconnectListener(this::disconnectQuietly);
            LOG.debug("{} connected", (Object)remoteClient);
            return connection;
        }
        catch (AuthenticationException e) {
            throw new ServerAuthenticationException(e.getMessage());
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.debug(remoteClient + " unable to connect", (Throwable)e);
            throw new LoginException(e.getMessage());
        }
    }

    protected final void disconnect(AbstractRemoteEntityConnection connection) throws RemoteException {
        connection.close();
    }

    protected AbstractRemoteEntityConnection createRemoteConnection(Database database, RemoteClient remoteClient, int port, RMIClientSocketFactory clientSocketFactory, RMIServerSocketFactory serverSocketFactory) throws RemoteException, DatabaseException {
        return new DefaultRemoteEntityConnection(this.clientDomainModel(remoteClient), database, remoteClient, port, clientSocketFactory, serverSocketFactory);
    }

    final Database database() {
        return this.database;
    }

    final int getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }

    final void setIdleConnectionTimeout(int idleConnectionTimeout) {
        if (idleConnectionTimeout < 0) {
            throw new IllegalArgumentException("Idle connection timeout must be a positive integer");
        }
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    final void setClientTypeIdleConnectionTimeouts(Map<String, Integer> clientTypeIdleConnectionTimeouts) {
        this.clientTypeIdleConnectionTimeouts.putAll(clientTypeIdleConnectionTimeouts);
    }

    final Database.Statistics databaseStatistics() {
        return this.database.statistics();
    }

    protected final void maintainConnections(Collection<AbstractServer.ClientConnection<AbstractRemoteEntityConnection>> connections) throws RemoteException {
        for (AbstractServer.ClientConnection<AbstractRemoteEntityConnection> client : connections) {
            AbstractRemoteEntityConnection connection = (AbstractRemoteEntityConnection)client.connection();
            if (connection.active()) continue;
            boolean connected = connection.connected();
            boolean timedOut = this.hasConnectionTimedOut(connection);
            if (connected && !timedOut) continue;
            LOG.debug("Removing connection {}, connected: {}, timeout: {}", new Object[]{client, connected, timedOut});
            this.disconnect(client.remoteClient().clientId());
        }
    }

    final Map<DomainType, Collection<EntityServerAdmin.DomainEntityDefinition>> domainEntityDefinitions() {
        HashMap<DomainType, Collection<EntityServerAdmin.DomainEntityDefinition>> domainEntities = new HashMap<DomainType, Collection<EntityServerAdmin.DomainEntityDefinition>>();
        for (Domain domain : this.domainModels.values()) {
            domainEntities.put(domain.type(), domain.entities().definitions().stream().map(definition -> new DefaultDomainEntityDefinition(definition.entityType().name(), definition.tableName())).collect(Collectors.toList()));
        }
        return domainEntities;
    }

    final Map<DomainType, Collection<EntityServerAdmin.DomainReport>> domainReports() {
        HashMap<DomainType, Collection<EntityServerAdmin.DomainReport>> domainReports = new HashMap<DomainType, Collection<EntityServerAdmin.DomainReport>>();
        for (Domain domain : this.domainModels.values()) {
            domainReports.put(domain.type(), domain.reports().entrySet().stream().map(entry -> new DefaultDomainReport(((ReportType)entry.getKey()).name(), ((Report)entry.getValue()).getClass().getSimpleName(), ((Report)entry.getValue()).toString(), ((Report)entry.getValue()).cached())).collect(Collectors.toList()));
        }
        return domainReports;
    }

    final Map<DomainType, Collection<EntityServerAdmin.DomainOperation>> domainOperations() {
        HashMap<DomainType, Collection<EntityServerAdmin.DomainOperation>> domainOperations = new HashMap<DomainType, Collection<EntityServerAdmin.DomainOperation>>();
        for (Domain domain : this.domainModels.values()) {
            ArrayList operations = new ArrayList();
            operations.addAll(domain.procedures().entrySet().stream().map(entry -> new DefaultDomainOperation("Procedure", ((ProcedureType)entry.getKey()).name(), ((DatabaseProcedure)entry.getValue()).getClass().getName())).collect(Collectors.toList()));
            operations.addAll(domain.functions().entrySet().stream().map(entry -> new DefaultDomainOperation("Function", ((FunctionType)entry.getKey()).name(), ((DatabaseFunction)entry.getValue()).getClass().getName())).collect(Collectors.toList()));
            domainOperations.put(domain.type(), operations);
        }
        return domainOperations;
    }

    final void clearReportCache() {
        for (Domain domain : this.domainModels.values()) {
            domain.reports().values().forEach(Report::clearCache);
        }
    }

    final ClientLog clientLog(UUID clientId) {
        return ((AbstractRemoteEntityConnection)this.connection(clientId)).clientLog();
    }

    final boolean isLoggingEnabled(UUID clientId) {
        return ((AbstractRemoteEntityConnection)this.connection(clientId)).isLoggingEnabled();
    }

    final void setLoggingEnabled(UUID clientId, boolean loggingEnabled) {
        ((AbstractRemoteEntityConnection)this.connection(clientId)).setLoggingEnabled(loggingEnabled);
    }

    final void disconnectClients(boolean timedOutOnly) throws RemoteException {
        ArrayList clients = new ArrayList(this.connections().keySet());
        for (RemoteClient client : clients) {
            AbstractRemoteEntityConnection connection = (AbstractRemoteEntityConnection)this.connection(client.clientId());
            if (timedOutOnly) {
                boolean active = connection.active();
                if (active || !this.hasConnectionTimedOut(connection)) continue;
                this.disconnect(client.clientId());
                continue;
            }
            this.disconnect(client.clientId());
        }
    }

    private void disconnectQuietly(AbstractRemoteEntityConnection connection) {
        try {
            this.disconnect(connection.remoteClient().clientId());
        }
        catch (RemoteException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private EntityServerAdmin createServerAdmin(EntityServerConfiguration configuration) throws RemoteException {
        if (configuration.adminPort() != 0) {
            return new DefaultEntityServerAdmin(this, configuration);
        }
        return null;
    }

    private boolean hasConnectionTimedOut(AbstractRemoteEntityConnection connection) {
        Integer timeout = this.clientTypeIdleConnectionTimeouts.get(connection.remoteClient().clientTypeId());
        if (timeout == null) {
            timeout = this.idleConnectionTimeout;
        }
        return connection.hasBeenInactive(timeout);
    }

    private Domain clientDomainModel(RemoteClient remoteClient) {
        String domainTypeName = (String)remoteClient.parameters().get("codion.client.domainType");
        if (domainTypeName == null) {
            throw new IllegalArgumentException("'codion.client.domainType' parameter not specified");
        }
        return this.domainModels.get(DomainType.domainTypeByName((String)domainTypeName));
    }

    private static void configureDatabase(Collection<Domain> domainModels, Database database) throws DatabaseException {
        for (Domain domain : domainModels) {
            LocalEntityConnection.configureDatabase((Database)database, (Domain)domain);
        }
    }

    private static Map<DomainType, Domain> loadDomainModels(Collection<String> domainModelClassNames) throws Throwable {
        HashMap<DomainType, Domain> domains = new HashMap<DomainType, Domain>();
        List serviceDomains = Domain.domains();
        try {
            serviceDomains.forEach(domain -> {
                LOG.info("Server loading domain model '" + domain.type() + "' as a service");
                domains.put(domain.type(), (Domain)domain);
            });
            for (String className : domainModelClassNames) {
                LOG.info("Server loading domain model '" + className + "' from classpath");
                Domain domain2 = (Domain)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                domains.put(domain2.type(), domain2);
            }
            return Collections.unmodifiableMap(domains);
        }
        catch (InvocationTargetException ite) {
            LOG.error("Exception while loading and registering domain model", (Throwable)ite);
            throw ite.getCause();
        }
        catch (Exception e) {
            LOG.error("Exception while loading and registering domain model", (Throwable)e);
            throw e;
        }
    }

    private static void createConnectionPools(Database database, String connectionPoolFactoryClassName, Collection<User> connectionPoolUsers) throws DatabaseException {
        if (!connectionPoolUsers.isEmpty()) {
            ConnectionPoolFactory poolFactory = NullOrEmpty.nullOrEmpty((String)connectionPoolFactoryClassName) ? ConnectionPoolFactory.instance() : ConnectionPoolFactory.instance((String)connectionPoolFactoryClassName);
            for (User user : connectionPoolUsers) {
                database.createConnectionPool(poolFactory, user);
            }
        }
    }

    public static EntityServer startServer() throws RemoteException {
        return EntityServer.startServer(EntityServerConfiguration.builderFromSystemProperties().build());
    }

    public static synchronized EntityServer startServer(EntityServerConfiguration configuration) throws RemoteException {
        Objects.requireNonNull(configuration, "configuration");
        long currentTime = System.currentTimeMillis();
        try {
            EntityServer server = new EntityServer(configuration);
            EntityServer.printStartupInfo(server, System.currentTimeMillis() - currentTime);
            return server;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Exception when starting server", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static void printStartupInfo(EntityServer server, long startTime) {
        String startupInfo = server.serverInformation().serverName() + " started on port: " + server.serverInformation().serverPort() + ", registryPort: " + server.configuration.registryPort() + ", adminPort: " + server.configuration.adminPort() + ", hostname: " + (String)ServerConfiguration.RMI_SERVER_HOSTNAME.get() + EntityServer.auxiliaryServerInfo(server.auxiliaryServers()) + "Server started in " + startTime + " ms";
        LOG.info(startupInfo);
        System.out.println(startupInfo);
    }

    private static String auxiliaryServerInfo(Collection<AuxiliaryServer> auxiliaryServers) {
        return auxiliaryServers.stream().map(AuxiliaryServer::serverInformation).collect(Collectors.joining("\n", !auxiliaryServers.isEmpty() ? "\n" : "", "\n"));
    }

    static synchronized void shutdownServer() throws ServerAuthenticationException {
        Clients.resolveTrustStore();
        EntityServerConfiguration configuration = EntityServerConfiguration.builderFromSystemProperties().build();
        String serverName = configuration.serverName();
        int registryPort = configuration.registryPort();
        User adminUser = configuration.adminUser();
        if (adminUser == null) {
            throw new ServerAuthenticationException("No admin user specified");
        }
        try {
            Registry registry = LocateRegistry.getRegistry(registryPort);
            Server server = (Server)registry.lookup(serverName);
            EntityServerAdmin serverAdmin = (EntityServerAdmin)server.serverAdmin(adminUser);
            String shutDownInfo = serverName + " found in registry on port: " + registryPort + ", shutting down";
            LOG.info(shutDownInfo);
            System.out.println(shutDownInfo);
            serverAdmin.shutdown();
        }
        catch (RemoteException e) {
            System.out.println("Unable to shutdown server: " + e.getMessage());
            LOG.error("Error on shutdown", (Throwable)e);
        }
        catch (NotBoundException e) {
            System.out.println(serverName + " not bound to registry on port: " + registryPort);
        }
        catch (ServerAuthenticationException e) {
            LOG.error("Admin user info not provided or incorrect", (Throwable)e);
            throw e;
        }
    }

    public static void main(String[] arguments) throws RemoteException, ServerAuthenticationException {
        if (arguments.length > 0 && arguments[0].equalsIgnoreCase(SHUTDOWN)) {
            EntityServer.shutdownServer();
        } else {
            EntityServer.startServer();
        }
    }

    private final class ShutdownListener
    implements Runnable {
        private ShutdownListener() {
        }

        @Override
        public void run() {
            EntityServer.this.database.closeConnectionPools();
        }
    }

    private static final class DefaultDomainOperation
    implements EntityServerAdmin.DomainOperation,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String type;
        private final String name;
        private final String className;

        private DefaultDomainOperation(String type, String name, String className) {
            this.type = type;
            this.name = name;
            this.className = className;
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String className() {
            return this.className;
        }
    }

    private static final class DefaultDomainReport
    implements EntityServerAdmin.DomainReport,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String type;
        private final String path;
        private final boolean cached;

        private DefaultDomainReport(String name, String type, String path, boolean cached) {
            this.name = name;
            this.type = type;
            this.path = path;
            this.cached = cached;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        public boolean cached() {
            return this.cached;
        }
    }

    private static final class DefaultDomainEntityDefinition
    implements EntityServerAdmin.DomainEntityDefinition,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String tableName;

        private DefaultDomainEntityDefinition(String name, String tableName) {
            this.name = name;
            this.tableName = tableName;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String tableName() {
            return this.tableName;
        }
    }
}

