/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.Operator;
import is.codion.common.event.EventObserver;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.state.State;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.EntitySearchModel;
import java.text.Format;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public final class ForeignKeyConditionModel
implements ColumnConditionModel<Attribute<?>, Entity> {
    private final ColumnConditionModel<ForeignKey, Entity> conditionModel;
    private final EntitySearchModel equalSearchModel;
    private final EntitySearchModel inSearchModel;
    private boolean updatingModel = false;

    private ForeignKeyConditionModel(DefaultBuilder builder) {
        this.conditionModel = ColumnConditionModel.builder((Object)builder.foreignKey, Entity.class).operators(builder.operators()).build();
        this.equalSearchModel = builder.equalSearchModel;
        this.inSearchModel = builder.inSearchModel;
        this.bindEvents();
    }

    public EntitySearchModel equalSearchModel() {
        if (this.equalSearchModel == null) {
            throw new IllegalStateException("equalSearchModel is not available");
        }
        return this.equalSearchModel;
    }

    public EntitySearchModel inSearchModel() {
        if (this.inSearchModel == null) {
            throw new IllegalStateException("inSearchModel is not available");
        }
        return this.inSearchModel;
    }

    public Attribute<?> columnIdentifier() {
        return (Attribute)this.conditionModel.columnIdentifier();
    }

    public State caseSensitive() {
        return this.conditionModel.caseSensitive();
    }

    public Optional<Format> format() {
        return this.conditionModel.format();
    }

    public String dateTimePattern() {
        return this.conditionModel.dateTimePattern();
    }

    public Value<ColumnConditionModel.AutomaticWildcard> automaticWildcard() {
        return this.conditionModel.automaticWildcard();
    }

    public State autoEnable() {
        return this.conditionModel.autoEnable();
    }

    public State locked() {
        return this.conditionModel.locked();
    }

    public Class<Entity> columnClass() {
        return this.conditionModel.columnClass();
    }

    public void setEqualValue(Entity value) {
        this.conditionModel.setEqualValue((Object)value);
    }

    public Entity getEqualValue() {
        return (Entity)this.conditionModel.getEqualValue();
    }

    public void setInValues(Collection<Entity> values) {
        this.conditionModel.setInValues(values);
    }

    public Collection<Entity> getInValues() {
        return this.conditionModel.getInValues();
    }

    public void setUpperBound(Entity upper) {
        this.conditionModel.setUpperBound((Object)upper);
    }

    public Entity getUpperBound() {
        return (Entity)this.conditionModel.getUpperBound();
    }

    public void setLowerBound(Entity value) {
        this.conditionModel.setLowerBound((Object)value);
    }

    public Entity getLowerBound() {
        return (Entity)this.conditionModel.getLowerBound();
    }

    public List<Operator> operators() {
        return this.conditionModel.operators();
    }

    public char wildcard() {
        return this.conditionModel.wildcard();
    }

    public State enabled() {
        return this.conditionModel.enabled();
    }

    public void clear() {
        this.conditionModel.clear();
    }

    public Value<Entity> equalValue() {
        return this.conditionModel.equalValue();
    }

    public ValueSet<Entity> inValues() {
        return this.conditionModel.inValues();
    }

    public Value<Entity> upperBoundValue() {
        return this.conditionModel.upperBoundValue();
    }

    public Value<Entity> lowerBoundValue() {
        return this.conditionModel.lowerBoundValue();
    }

    public Value<Operator> operator() {
        return this.conditionModel.operator();
    }

    public boolean accepts(Comparable<Entity> columnValue) {
        return this.conditionModel.accepts(columnValue);
    }

    public EventObserver<?> conditionChangedEvent() {
        return this.conditionModel.conditionChangedEvent();
    }

    public static Builder builder(ForeignKey foreignKey) {
        return new DefaultBuilder(foreignKey);
    }

    private void bindEvents() {
        if (this.equalSearchModel != null) {
            this.equalSearchModel.entity().addConsumer((Consumer)new SetEqualValue());
            this.equalValue().addConsumer((Consumer)new SelectEqualValue());
        }
        if (this.inSearchModel != null) {
            this.inSearchModel.entities().addConsumer((Consumer)new SetInValues());
            this.inValues().addConsumer((Consumer)new SelectInValues());
        }
    }

    private static final class DefaultBuilder
    implements Builder {
        private final ForeignKey foreignKey;
        private EntitySearchModel equalSearchModel;
        private EntitySearchModel inSearchModel;

        private DefaultBuilder(ForeignKey foreignKey) {
            this.foreignKey = Objects.requireNonNull(foreignKey);
        }

        @Override
        public Builder includeEqualOperators(EntitySearchModel equalSearchModel) {
            this.equalSearchModel = Objects.requireNonNull(equalSearchModel);
            return this;
        }

        @Override
        public Builder includeInOperators(EntitySearchModel inSearchModel) {
            this.inSearchModel = Objects.requireNonNull(inSearchModel);
            return this;
        }

        @Override
        public ForeignKeyConditionModel build() {
            return new ForeignKeyConditionModel(this);
        }

        private List<Operator> operators() {
            if (this.equalSearchModel == null && this.inSearchModel == null) {
                throw new IllegalStateException("You must specify either an equalSearchModel or an inSearchModel");
            }
            if (this.equalSearchModel != null && this.inSearchModel != null) {
                return Arrays.asList(Operator.EQUAL, Operator.NOT_EQUAL, Operator.IN, Operator.NOT_IN);
            }
            if (this.equalSearchModel != null) {
                return Arrays.asList(Operator.EQUAL, Operator.NOT_EQUAL);
            }
            return Arrays.asList(Operator.IN, Operator.NOT_IN);
        }
    }

    private final class SetEqualValue
    implements Consumer<Entity> {
        private SetEqualValue() {
        }

        @Override
        public void accept(Entity selectedEntity) {
            if (!ForeignKeyConditionModel.this.updatingModel) {
                ForeignKeyConditionModel.this.setEqualValue(selectedEntity);
            }
        }
    }

    private final class SelectEqualValue
    implements Consumer<Entity> {
        private SelectEqualValue() {
        }

        @Override
        public void accept(Entity equalValue) {
            ForeignKeyConditionModel.this.updatingModel = true;
            try {
                ForeignKeyConditionModel.this.equalSearchModel.entity().set((Object)equalValue);
            }
            finally {
                ForeignKeyConditionModel.this.updatingModel = false;
            }
        }
    }

    private final class SetInValues
    implements Consumer<Set<Entity>> {
        private SetInValues() {
        }

        @Override
        public void accept(Set<Entity> selectedEntities) {
            if (!ForeignKeyConditionModel.this.updatingModel) {
                ForeignKeyConditionModel.this.setInValues(selectedEntities);
            }
        }
    }

    private final class SelectInValues
    implements Consumer<Set<Entity>> {
        private SelectInValues() {
        }

        @Override
        public void accept(Set<Entity> inValues) {
            ForeignKeyConditionModel.this.updatingModel = true;
            try {
                ForeignKeyConditionModel.this.inSearchModel.entities().set(inValues);
            }
            finally {
                ForeignKeyConditionModel.this.updatingModel = false;
            }
        }
    }

    public static interface Builder {
        public Builder includeEqualOperators(EntitySearchModel var1);

        public Builder includeInOperators(EntitySearchModel var1);

        public ForeignKeyConditionModel build();
    }
}

