/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.state.State;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.AbstractEntityEditModel;
import is.codion.framework.model.DefaultDetailModelLink;
import is.codion.framework.model.DefaultEntityModel;
import is.codion.framework.model.EntityTableModel;
import is.codion.framework.model.ForeignKeyDetailModelLink;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultForeignKeyDetailModelLink<M extends DefaultEntityModel<M, E, T>, E extends AbstractEntityEditModel, T extends EntityTableModel<E>>
extends DefaultDetailModelLink<M, E, T>
implements ForeignKeyDetailModelLink<M, E, T> {
    private final ForeignKey foreignKey;
    private final State clearForeignKeyOnEmptySelection = State.state((boolean)((Boolean)ForeignKeyDetailModelLink.CLEAR_FOREIGN_KEY_ON_EMPTY_SELECTION.get()));
    private final State searchByInsertedEntity = State.state((boolean)((Boolean)ForeignKeyDetailModelLink.SEARCH_BY_INSERTED_ENTITY.get()));
    private final State refreshOnSelection = State.state((boolean)((Boolean)ForeignKeyDetailModelLink.REFRESH_ON_SELECTION.get()));

    public DefaultForeignKeyDetailModelLink(M detailModel, ForeignKey foreignKey) {
        super(detailModel);
        this.foreignKey = Objects.requireNonNull(foreignKey, "foreignKey");
    }

    @Override
    public final ForeignKey foreignKey() {
        return this.foreignKey;
    }

    @Override
    public final State searchByInsertedEntity() {
        return this.searchByInsertedEntity;
    }

    @Override
    public final State refreshOnSelection() {
        return this.refreshOnSelection;
    }

    @Override
    public final State clearForeignKeyOnEmptySelection() {
        return this.clearForeignKeyOnEmptySelection;
    }

    @Override
    public void onSelection(Collection<Entity> selectedEntities) {
        if (((DefaultEntityModel)this.detailModel()).containsTableModel() && this.setForeignKeyCondition(selectedEntities) && ((Boolean)this.refreshOnSelection.get()).booleanValue()) {
            ((DefaultEntityModel)this.detailModel()).tableModel().refresher().refreshThen(items -> this.setEditModelForeignKeyValue(selectedEntities));
        } else {
            this.setEditModelForeignKeyValue(selectedEntities);
        }
    }

    @Override
    public void onInsert(Collection<Entity> insertedEntities) {
        Collection<Entity> entities = this.ofReferencedType(insertedEntities);
        ((DefaultEntityModel)this.detailModel()).editModel().add(this.foreignKey, entities);
        if (!entities.isEmpty()) {
            ((AbstractEntityEditModel)((DefaultEntityModel)this.detailModel()).editModel()).put(this.foreignKey, entities.iterator().next());
        }
        if (((DefaultEntityModel)this.detailModel()).containsTableModel() && ((Boolean)this.searchByInsertedEntity.get()).booleanValue() && this.setForeignKeyCondition(entities)) {
            ((DefaultEntityModel)this.detailModel()).tableModel().refresh();
        }
    }

    @Override
    public void onUpdate(Map<Entity.Key, Entity> updatedEntities) {
        Collection<Entity> entities = this.ofReferencedType(updatedEntities.values());
        ((AbstractEntityEditModel)((DefaultEntityModel)this.detailModel()).editModel()).replace(this.foreignKey, entities);
        if (((DefaultEntityModel)this.detailModel()).containsTableModel() && ((Boolean)((DefaultEntityModel)this.detailModel()).tableModel().handleEditEvents().not().get()).booleanValue()) {
            ((DefaultEntityModel)this.detailModel()).tableModel().replace(this.foreignKey, entities);
        }
    }

    @Override
    public void onDelete(Collection<Entity> deletedEntities) {
        ((DefaultEntityModel)this.detailModel()).editModel().remove(this.foreignKey, this.ofReferencedType(deletedEntities));
    }

    private Collection<Entity> ofReferencedType(Collection<Entity> entities) {
        return entities.stream().filter(entity -> entity.entityType().equals(this.foreignKey.referencedType())).collect(Collectors.toList());
    }

    private void setEditModelForeignKeyValue(Collection<Entity> selectedEntities) {
        Entity foreignKeyValue;
        Entity entity = foreignKeyValue = selectedEntities.isEmpty() ? null : selectedEntities.iterator().next();
        if (((Boolean)((AbstractEntityEditModel)((DefaultEntityModel)this.detailModel()).editModel()).exists().not().get()).booleanValue() && (foreignKeyValue != null || ((Boolean)this.clearForeignKeyOnEmptySelection.get()).booleanValue())) {
            ((AbstractEntityEditModel)((DefaultEntityModel)this.detailModel()).editModel()).put(this.foreignKey, foreignKeyValue);
        }
    }

    private boolean setForeignKeyCondition(Collection<Entity> selectedEntities) {
        if (selectedEntities.isEmpty()) {
            return ((DefaultEntityModel)this.detailModel()).tableModel().conditionModel().setEqualConditionValue(this.foreignKey, null);
        }
        if (selectedEntities.size() == 1) {
            return ((DefaultEntityModel)this.detailModel()).tableModel().conditionModel().setEqualConditionValue(this.foreignKey, selectedEntities.iterator().next());
        }
        return ((DefaultEntityModel)this.detailModel()).tableModel().conditionModel().setInConditionValues(this.foreignKey, selectedEntities);
    }
}

