/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.Conjunction;
import is.codion.common.Operator;
import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.model.table.TableConditionModel;
import is.codion.common.value.Value;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.condition.ColumnCondition;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.model.EntityTableConditionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class DefaultEntityTableConditionModel
implements EntityTableConditionModel {
    private static final Supplier<Condition> NULL_CONDITION_SUPPLIER = () -> null;
    private final EntityDefinition entityDefinition;
    private final EntityConnectionProvider connectionProvider;
    private final TableConditionModel<Attribute<?>> conditionModel;
    private final Event<?> conditionChangedEvent = Event.event();
    private final Value<Supplier<Condition>> additionalWhere = Value.nonNull(NULL_CONDITION_SUPPLIER).build();
    private final Value<Supplier<Condition>> additionalHaving = Value.nonNull(NULL_CONDITION_SUPPLIER).build();
    private final NoneAggregatePredicate noneAggregatePredicate = new NoneAggregatePredicate();
    private final AggregatePredicate aggregatePredicate = new AggregatePredicate();

    DefaultEntityTableConditionModel(EntityType entityType, EntityConnectionProvider connectionProvider, ColumnConditionModel.Factory<Attribute<?>> conditionModelFactory) {
        this.entityDefinition = connectionProvider.entities().definition(Objects.requireNonNull(entityType, "entityType"));
        this.connectionProvider = Objects.requireNonNull(connectionProvider, "connectionProvider");
        this.conditionModel = TableConditionModel.tableConditionModel(this.createConditionModels(entityType, conditionModelFactory));
        this.bindEvents();
    }

    @Override
    public EntityType entityType() {
        return this.entityDefinition.entityType();
    }

    @Override
    public EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public <T> boolean setEqualConditionValue(Attribute<T> attribute, T value) {
        Objects.requireNonNull(attribute);
        boolean aggregateColumn = attribute instanceof Column && this.entityDefinition.columns().definition((Column)attribute).aggregate();
        Condition condition = aggregateColumn ? this.having(Conjunction.AND) : this.where(Conjunction.AND);
        ColumnConditionModel columnConditionModel = (ColumnConditionModel)this.conditionModel.conditionModels().get(attribute);
        if (columnConditionModel != null) {
            columnConditionModel.operator().set((Object)Operator.EQUAL);
            columnConditionModel.setEqualValue(value);
            columnConditionModel.enabled().set((Object)(value != null ? 1 : 0));
        }
        return !condition.equals(aggregateColumn ? this.having(Conjunction.AND) : this.where(Conjunction.AND));
    }

    @Override
    public <T> boolean setInConditionValues(Attribute<T> attribute, Collection<T> values) {
        Objects.requireNonNull(attribute);
        Objects.requireNonNull(values);
        boolean aggregateColumn = attribute instanceof Column && this.entityDefinition.columns().definition((Column)attribute).aggregate();
        Condition condition = aggregateColumn ? this.having(Conjunction.AND) : this.where(Conjunction.AND);
        ColumnConditionModel columnConditionModel = (ColumnConditionModel)this.conditionModel.conditionModels().get(attribute);
        if (columnConditionModel != null) {
            columnConditionModel.operator().set((Object)Operator.IN);
            columnConditionModel.setInValues(values);
            columnConditionModel.enabled().set((Object)(!values.isEmpty() ? 1 : 0));
        }
        return !condition.equals(aggregateColumn ? this.having(Conjunction.AND) : this.where(Conjunction.AND));
    }

    @Override
    public Condition where(Conjunction conjunction) {
        Objects.requireNonNull(conjunction);
        Collection<Condition> conditions = this.conditions(this.noneAggregatePredicate, (Condition)((Supplier)this.additionalWhere.get()).get());
        return conditions.isEmpty() ? Condition.all((EntityType)this.entityDefinition.entityType()) : Condition.combination((Conjunction)conjunction, conditions);
    }

    @Override
    public Condition having(Conjunction conjunction) {
        Objects.requireNonNull(conjunction);
        Collection<Condition> conditions = this.conditions(this.aggregatePredicate, (Condition)((Supplier)this.additionalHaving.get()).get());
        return conditions.isEmpty() ? Condition.all((EntityType)this.entityDefinition.entityType()) : Condition.combination((Conjunction)conjunction, conditions);
    }

    @Override
    public Value<Supplier<Condition>> additionalWhere() {
        return this.additionalWhere;
    }

    @Override
    public Value<Supplier<Condition>> additionalHaving() {
        return this.additionalHaving;
    }

    public Map<Attribute<?>, ColumnConditionModel<Attribute<?>, ?>> conditionModels() {
        return this.conditionModel.conditionModels();
    }

    public <T> ColumnConditionModel<Attribute<?>, T> conditionModel(Attribute<?> columnIdentifier) {
        return this.conditionModel.conditionModel(columnIdentifier);
    }

    @Override
    public <T> ColumnConditionModel<Attribute<?>, T> attributeModel(Attribute<T> columnIdentifier) {
        return this.conditionModel(columnIdentifier);
    }

    public boolean enabled() {
        return this.conditionModel.enabled();
    }

    public boolean enabled(Attribute<?> columnIdentifier) {
        return this.conditionModel.enabled(columnIdentifier);
    }

    public EventObserver<?> conditionChangedEvent() {
        return this.conditionModel.conditionChangedEvent();
    }

    public void clear() {
        this.conditionModel.clear();
    }

    private Collection<Condition> conditions(Predicate<ColumnConditionModel<?, ?>> conditionModelTypePredicate, Condition additionalCondition) {
        List conditions = this.conditionModel.conditionModels().values().stream().filter(model -> (Boolean)model.enabled().get()).filter(conditionModelTypePredicate).map(DefaultEntityTableConditionModel::condition).collect(Collectors.toCollection(ArrayList::new));
        if (additionalCondition != null) {
            conditions.add(additionalCondition);
        }
        return conditions;
    }

    private void bindEvents() {
        this.conditionModel.conditionModels().values().forEach(columnConditionModel -> columnConditionModel.conditionChangedEvent().addListener(this.conditionChangedEvent));
        this.additionalWhere.addListener(this.conditionChangedEvent);
        this.additionalHaving.addListener(this.conditionChangedEvent);
    }

    private Collection<ColumnConditionModel<Attribute<?>, ?>> createConditionModels(EntityType entityType, ColumnConditionModel.Factory<Attribute<?>> conditionModelFactory) {
        ArrayList models = new ArrayList();
        EntityDefinition definition = this.connectionProvider.entities().definition(entityType);
        definition.columns().definitions().forEach(columnDefinition -> conditionModelFactory.createConditionModel((Object)columnDefinition.attribute()).ifPresent(models::add));
        definition.foreignKeys().definitions().forEach(foreignKeyDefinition -> conditionModelFactory.createConditionModel((Object)foreignKeyDefinition.attribute()).ifPresent(models::add));
        return models.stream().map(model -> model).collect(Collectors.toList());
    }

    private static Condition condition(ColumnConditionModel<?, ?> conditionModel) {
        if (conditionModel.columnIdentifier() instanceof ForeignKey) {
            return DefaultEntityTableConditionModel.foreignKeyCondition(conditionModel);
        }
        return DefaultEntityTableConditionModel.columnCondition(conditionModel);
    }

    private static Condition foreignKeyCondition(ColumnConditionModel<?, Entity> conditionModel) {
        ForeignKey foreignKey = (ForeignKey)conditionModel.columnIdentifier();
        Entity equalValue = (Entity)conditionModel.equalValue().get();
        Collection inValues = (Collection)conditionModel.inValues().get();
        switch ((Operator)conditionModel.operator().get()) {
            case EQUAL: {
                return equalValue == null ? foreignKey.isNull() : foreignKey.equalTo(equalValue);
            }
            case IN: {
                return inValues.isEmpty() ? foreignKey.isNull() : foreignKey.in(inValues);
            }
            case NOT_EQUAL: {
                return equalValue == null ? foreignKey.isNotNull() : foreignKey.notEqualTo(equalValue);
            }
            case NOT_IN: {
                return inValues.isEmpty() ? foreignKey.isNotNull() : foreignKey.notIn(inValues);
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + conditionModel.operator().get() + " for foreign key condition");
    }

    private static <T> ColumnCondition<T> columnCondition(ColumnConditionModel<?, T> conditionModel) {
        Column column = (Column)conditionModel.columnIdentifier();
        switch ((Operator)conditionModel.operator().get()) {
            case EQUAL: {
                return DefaultEntityTableConditionModel.equalCondition(conditionModel, column);
            }
            case NOT_EQUAL: {
                return DefaultEntityTableConditionModel.notEqualCondition(conditionModel, column);
            }
            case LESS_THAN: {
                return column.lessThan(conditionModel.getUpperBound());
            }
            case LESS_THAN_OR_EQUAL: {
                return column.lessThanOrEqualTo(conditionModel.getUpperBound());
            }
            case GREATER_THAN: {
                return column.greaterThan(conditionModel.getLowerBound());
            }
            case GREATER_THAN_OR_EQUAL: {
                return column.greaterThanOrEqualTo(conditionModel.getLowerBound());
            }
            case BETWEEN_EXCLUSIVE: {
                return column.betweenExclusive(conditionModel.getLowerBound(), conditionModel.getUpperBound());
            }
            case BETWEEN: {
                return column.between(conditionModel.getLowerBound(), conditionModel.getUpperBound());
            }
            case NOT_BETWEEN_EXCLUSIVE: {
                return column.notBetweenExclusive(conditionModel.getLowerBound(), conditionModel.getUpperBound());
            }
            case NOT_BETWEEN: {
                return column.notBetween(conditionModel.getLowerBound(), conditionModel.getUpperBound());
            }
            case IN: {
                return DefaultEntityTableConditionModel.inCondition(conditionModel, column);
            }
            case NOT_IN: {
                return DefaultEntityTableConditionModel.notInCondition(conditionModel, column);
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + conditionModel.operator().get());
    }

    private static <T> ColumnCondition<T> equalCondition(ColumnConditionModel<?, T> conditionModel, Column<T> column) {
        Object equalValue = conditionModel.getEqualValue();
        if (equalValue == null) {
            return column.isNull();
        }
        if (column.type().isString()) {
            return DefaultEntityTableConditionModel.singleStringEqualCondition(conditionModel, column, (String)equalValue);
        }
        if (column.type().isCharacter()) {
            return DefaultEntityTableConditionModel.singleCharacterEqualCondition(conditionModel, column, (Character)equalValue);
        }
        return column.equalTo(equalValue);
    }

    private static <T> ColumnCondition<T> notEqualCondition(ColumnConditionModel<?, T> conditionModel, Column<T> column) {
        Object equalValue = conditionModel.getEqualValue();
        if (equalValue == null) {
            return column.isNotNull();
        }
        if (column.type().isString()) {
            return DefaultEntityTableConditionModel.singleStringNotEqualCondition(conditionModel, column, (String)equalValue);
        }
        if (column.type().isCharacter()) {
            return DefaultEntityTableConditionModel.singleCharacterNotEqualCondition(conditionModel, column, (Character)equalValue);
        }
        return column.notEqualTo(equalValue);
    }

    private static <T> ColumnCondition<T> singleStringEqualCondition(ColumnConditionModel<?, T> conditionModel, Column<T> column, String value) {
        boolean caseSensitive = (Boolean)conditionModel.caseSensitive().get();
        if (DefaultEntityTableConditionModel.containsWildcards(value)) {
            return caseSensitive ? column.like(value) : column.likeIgnoreCase(value);
        }
        return caseSensitive ? column.equalTo((Object)value) : column.equalToIgnoreCase(value);
    }

    private static <T> ColumnCondition<T> singleCharacterEqualCondition(ColumnConditionModel<?, T> conditionModel, Column<T> column, Character value) {
        return (Boolean)conditionModel.caseSensitive().get() != false ? column.equalTo((Object)value) : column.equalToIgnoreCase(value);
    }

    private static <T> ColumnCondition<T> singleStringNotEqualCondition(ColumnConditionModel<?, T> conditionModel, Column<T> column, String value) {
        boolean caseSensitive = (Boolean)conditionModel.caseSensitive().get();
        if (DefaultEntityTableConditionModel.containsWildcards(value)) {
            return caseSensitive ? column.notLike(value) : column.notLikeIgnoreCase(value);
        }
        return caseSensitive ? column.notEqualTo((Object)value) : column.notEqualToIgnoreCase(value);
    }

    private static <T> ColumnCondition<T> singleCharacterNotEqualCondition(ColumnConditionModel<?, T> conditionModel, Column<T> column, Character value) {
        return (Boolean)conditionModel.caseSensitive().get() != false ? column.notEqualTo((Object)value) : column.notEqualToIgnoreCase(value);
    }

    private static <T> ColumnCondition<T> inCondition(ColumnConditionModel<?, T> conditionModel, Column<T> column) {
        if (column.type().isString()) {
            Column<T> stringColumn = column;
            Collection inValues = conditionModel.getInValues();
            return (Boolean)conditionModel.caseSensitive().get() != false ? stringColumn.in(inValues) : stringColumn.inIgnoreCase(inValues);
        }
        return column.in(conditionModel.getInValues());
    }

    private static <T> ColumnCondition<T> notInCondition(ColumnConditionModel<?, T> conditionModel, Column<T> column) {
        if (column.type().isString()) {
            Column<T> stringColumn = column;
            Collection inValues = conditionModel.getInValues();
            return (Boolean)conditionModel.caseSensitive().get() != false ? stringColumn.notIn(inValues) : stringColumn.notInIgnoreCase(inValues);
        }
        return column.notIn(conditionModel.getInValues());
    }

    private static boolean containsWildcards(String value) {
        return value != null && (value.contains("%") || value.contains("_"));
    }

    private final class NoneAggregatePredicate
    implements Predicate<ColumnConditionModel<?, ?>> {
        private NoneAggregatePredicate() {
        }

        @Override
        public boolean test(ColumnConditionModel<?, ?> conditionModel) {
            return !(conditionModel.columnIdentifier() instanceof Column) || !DefaultEntityTableConditionModel.this.entityDefinition.columns().definition((Column)conditionModel.columnIdentifier()).aggregate();
        }
    }

    private final class AggregatePredicate
    implements Predicate<ColumnConditionModel<?, ?>> {
        private AggregatePredicate() {
        }

        @Override
        public boolean test(ColumnConditionModel<?, ?> conditionModel) {
            return conditionModel.columnIdentifier() instanceof Column && DefaultEntityTableConditionModel.this.entityDefinition.columns().definition((Column)conditionModel.columnIdentifier()).aggregate();
        }
    }
}

