/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.model.table.ColumnConditionModel;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.model.EntitySearchModel;
import is.codion.framework.model.ForeignKeyConditionModel;
import java.util.Objects;
import java.util.Optional;

public class EntityConditionModelFactory
implements ColumnConditionModel.Factory<Attribute<?>> {
    private final EntityConnectionProvider connectionProvider;

    public EntityConditionModelFactory(EntityConnectionProvider connectionProvider) {
        this.connectionProvider = Objects.requireNonNull(connectionProvider);
    }

    public Optional<ColumnConditionModel<Attribute<?>, ?>> createConditionModel(Attribute<?> attribute) {
        if (!this.include(attribute)) {
            return Optional.empty();
        }
        if (attribute instanceof ForeignKey) {
            ForeignKey foreignKey = (ForeignKey)attribute;
            return Optional.of(ForeignKeyConditionModel.builder(foreignKey).includeEqualOperators(this.createEqualSearchModel(foreignKey)).includeInOperators(this.createInSearchModel(foreignKey)).build());
        }
        ColumnDefinition column = this.definition(attribute.entityType()).columns().definition((Column)attribute);
        ColumnConditionModel model = ColumnConditionModel.builder(attribute, (Class)attribute.type().valueClass()).format(column.format()).dateTimePattern(column.dateTimePattern()).build();
        return Optional.of(model);
    }

    private boolean include(Attribute<?> attribute) {
        Objects.requireNonNull(attribute);
        AttributeDefinition definition = this.connectionProvider.entities().definition(attribute.entityType()).attributes().definition(attribute);
        if (definition instanceof ForeignKeyDefinition) {
            return true;
        }
        if (definition instanceof ColumnDefinition) {
            ColumnDefinition columnDefinition = (ColumnDefinition)definition;
            return columnDefinition.selectable();
        }
        return false;
    }

    protected EntitySearchModel createEqualSearchModel(ForeignKey foreignKey) {
        return EntitySearchModel.builder(foreignKey.referencedType(), this.connectionProvider).singleSelection(true).build();
    }

    protected EntitySearchModel createInSearchModel(ForeignKey foreignKey) {
        return EntitySearchModel.builder(foreignKey.referencedType(), this.connectionProvider).build();
    }

    protected final EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    protected final EntityDefinition definition(EntityType entityType) {
        return this.connectionProvider.entities().definition(entityType);
    }
}

