/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.Text;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.model.EntitySearchModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class DefaultEntitySearchModel
implements EntitySearchModel {
    private static final Supplier<Condition> NULL_CONDITION = () -> null;
    private static final Function<Entity, String> DEFAULT_TO_STRING = Object::toString;
    private static final String DEFAULT_SEPARATOR = ",";
    private final State searchStringModified = State.state();
    private final State selectionEmpty = State.state((boolean)true);
    private final EntityType entityType;
    private final Collection<Column<String>> columns;
    private final ValueSet<Entity> entities = ((ValueSet.Builder)((ValueSet.Builder)((ValueSet.Builder)((ValueSet.Builder)ValueSet.builder().notify(Value.Notify.WHEN_SET)).validator((Value.Validator)new EntityValidator())).listener(this::reset)).consumer(selectedEntities -> this.selectionEmpty.set((Object)selectedEntities.isEmpty()))).build();
    private final EntityConnectionProvider connectionProvider;
    private final Map<Column<String>, EntitySearchModel.Settings> settings;
    private final Value<String> searchString = Value.nonNull((Object)"").notify(Value.Notify.WHEN_SET).listener(() -> this.searchStringModified.set((Object)(!this.searchStringRepresentEntities() ? 1 : 0))).build();
    private final Value<String> separator = Value.nonNull((Object)",").listener(this::reset).build();
    private final boolean singleSelection;
    private final Value<Character> wildcard = Value.nonNull((Object)((Character)Text.WILDCARD_CHARACTER.get())).build();
    private final Value<Supplier<Condition>> condition = Value.nonNull(NULL_CONDITION).build();
    private final Value<Function<Entity, String>> stringFunction = Value.nonNull(DEFAULT_TO_STRING).build();
    private final Value<Integer> limit;
    private final String description;

    private DefaultEntitySearchModel(DefaultBuilder builder) {
        this.entityType = builder.entityType;
        this.connectionProvider = builder.connectionProvider;
        this.separator.set((Object)builder.separator);
        this.columns = Collections.unmodifiableCollection(builder.columns);
        this.settings = Collections.unmodifiableMap(this.columns.stream().collect(Collectors.toMap(Function.identity(), column -> new DefaultSettings())));
        this.stringFunction.set(builder.stringFunction);
        this.description = builder.description == null ? this.createDescription() : builder.description;
        this.singleSelection = builder.singleSelection;
        this.limit = Value.nullable((Object)builder.limit).build();
    }

    @Override
    public EntityType entityType() {
        return this.entityType;
    }

    @Override
    public EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public Collection<Column<String>> columns() {
        return this.columns;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Value<Entity> entity() {
        return this.entities.value();
    }

    @Override
    public ValueSet<Entity> entities() {
        return this.entities;
    }

    @Override
    public Map<Column<String>, EntitySearchModel.Settings> settings() {
        return this.settings;
    }

    @Override
    public Value<Character> wildcard() {
        return this.wildcard;
    }

    @Override
    public Value<Integer> limit() {
        return this.limit;
    }

    @Override
    public Value<Supplier<Condition>> condition() {
        return this.condition;
    }

    @Override
    public Value<Function<Entity, String>> stringFunction() {
        return this.stringFunction;
    }

    @Override
    public void reset() {
        this.searchString.set((Object)this.entitiesToString());
    }

    @Override
    public List<Entity> search() {
        try {
            List result = this.connectionProvider.connection().select(this.select());
            result.sort(this.connectionProvider.entities().definition(this.entityType).comparator());
            return result;
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Value<String> searchString() {
        return this.searchString;
    }

    @Override
    public Value<String> separator() {
        return this.separator;
    }

    @Override
    public boolean singleSelection() {
        return this.singleSelection;
    }

    @Override
    public StateObserver searchStringModified() {
        return this.searchStringModified.observer();
    }

    @Override
    public StateObserver selectionEmpty() {
        return this.selectionEmpty.observer();
    }

    private EntityConnection.Select select() {
        String[] stringArray;
        if (this.columns.isEmpty()) {
            throw new IllegalStateException("No search columns provided for search model: " + this.entityType);
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (this.singleSelection) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = (String)this.searchString.get();
        } else {
            stringArray = ((String)this.searchString.get()).split((String)this.separator.get());
        }
        String[] searchStrings = stringArray;
        for (Column<String> column : this.columns) {
            EntitySearchModel.Settings columnSettings = this.settings.get(column);
            for (String rawSearchString : searchStrings) {
                String preparedSearchString = this.prepareSearchString(rawSearchString, columnSettings);
                boolean containsWildcards = DefaultEntitySearchModel.containsWildcards(preparedSearchString);
                if (((Boolean)columnSettings.caseSensitive().get()).booleanValue()) {
                    conditions.add((Condition)(containsWildcards ? column.like(preparedSearchString) : column.equalTo((Object)preparedSearchString)));
                    continue;
                }
                conditions.add((Condition)(containsWildcards ? column.likeIgnoreCase(preparedSearchString) : column.equalToIgnoreCase(preparedSearchString)));
            }
        }
        return EntityConnection.Select.where((Condition)this.createCombinedCondition(conditions)).limit((Integer)this.limit.get()).build();
    }

    private Condition createCombinedCondition(Collection<Condition> conditions) {
        Condition.Combination conditionCombination = Condition.or(conditions);
        Condition additionalCondition = (Condition)((Supplier)this.condition.get()).get();
        return additionalCondition == null ? conditionCombination : Condition.and((Condition[])new Condition[]{additionalCondition, conditionCombination});
    }

    private String prepareSearchString(String rawSearchString, EntitySearchModel.Settings settings) {
        boolean wildcardPrefix = (Boolean)settings.wildcardPrefix().get();
        boolean wildcardPostfix = (Boolean)settings.wildcardPostfix().get();
        String string = rawSearchString = (Boolean)settings.spaceAsWildcard().get() != false ? rawSearchString.replace(' ', ((Character)this.wildcard.get()).charValue()) : rawSearchString;
        return rawSearchString.equals(String.valueOf(this.wildcard.get())) ? String.valueOf(this.wildcard.get()) : (Serializable)(wildcardPrefix ? (Serializable)this.wildcard.get() : "") + rawSearchString.trim() + (Serializable)(wildcardPostfix ? (Serializable)this.wildcard.get() : "");
    }

    private boolean searchStringRepresentEntities() {
        return ((Set)this.entities.get()).isEmpty() && ((String)this.searchString.get()).isEmpty() || !((Set)this.entities.get()).isEmpty() && this.entitiesToString().equals(this.searchString.get());
    }

    private String createDescription() {
        EntityDefinition definition = this.connectionProvider.entities().definition(this.entityType);
        return this.columns.stream().map(column -> definition.columns().definition(column).caption()).collect(Collectors.joining(", "));
    }

    private String entitiesToString() {
        return ((Set)this.entities.get()).stream().map((Function)this.stringFunction.get()).collect(Collectors.joining((CharSequence)this.separator.get()));
    }

    private void validateType(Entity entity) {
        if (!entity.entityType().equals(this.entityType)) {
            throw new IllegalArgumentException("Entities of type " + this.entityType + " exptected, got " + entity.entityType());
        }
    }

    private static boolean containsWildcards(String value) {
        return value.contains("%") || value.contains("_");
    }

    private final class EntityValidator
    implements Value.Validator<Set<Entity>> {
        private EntityValidator() {
        }

        public void validate(Set<Entity> entitySet) {
            if (entitySet != null) {
                if (entitySet.size() > 1 && DefaultEntitySearchModel.this.singleSelection) {
                    throw new IllegalArgumentException("This EntitySearchModel does not allow the selection of multiple entities");
                }
                entitySet.forEach(DefaultEntitySearchModel.this::validateType);
            }
        }
    }

    static final class DefaultBuilder
    implements EntitySearchModel.Builder {
        private final EntityType entityType;
        private final EntityConnectionProvider connectionProvider;
        private Collection<Column<String>> columns;
        private Function<Entity, String> stringFunction = DEFAULT_TO_STRING;
        private String description;
        private boolean singleSelection = false;
        private String separator = ",";
        private Integer limit = (Integer)EntitySearchModel.DEFAULT_LIMIT.get();

        DefaultBuilder(EntityType entityType, EntityConnectionProvider connectionProvider) {
            this.entityType = Objects.requireNonNull(entityType);
            this.connectionProvider = Objects.requireNonNull(connectionProvider);
            this.columns = connectionProvider.entities().definition(entityType).columns().searchable();
        }

        @Override
        public EntitySearchModel.Builder columns(Collection<Column<String>> columns) {
            if (Objects.requireNonNull(columns).isEmpty()) {
                throw new IllegalArgumentException("One or more search column is required");
            }
            this.validateColumns(columns);
            this.columns = columns;
            return this;
        }

        @Override
        public EntitySearchModel.Builder stringFunction(Function<Entity, String> stringFunction) {
            this.stringFunction = Objects.requireNonNull(stringFunction);
            return this;
        }

        @Override
        public EntitySearchModel.Builder description(String description) {
            this.description = Objects.requireNonNull(description);
            return this;
        }

        @Override
        public EntitySearchModel.Builder singleSelection(boolean singleSelection) {
            this.singleSelection = singleSelection;
            return this;
        }

        @Override
        public EntitySearchModel.Builder separator(String separator) {
            this.separator = Objects.requireNonNull(separator);
            return this;
        }

        @Override
        public EntitySearchModel.Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public EntitySearchModel build() {
            return new DefaultEntitySearchModel(this);
        }

        private void validateColumns(Collection<Column<String>> columns) {
            for (Column<String> column : columns) {
                if (this.entityType.equals(column.entityType())) continue;
                throw new IllegalArgumentException("Column '" + column + "' is not part of entity " + this.entityType);
            }
        }
    }

    private static final class DefaultSettings
    implements EntitySearchModel.Settings {
        private final State wildcardPrefixState = State.state((boolean)true);
        private final State wildcardPostfixState = State.state((boolean)true);
        private final State caseSensitiveState = State.state((boolean)false);
        private final State spaceAsWildcard = State.state((boolean)true);

        private DefaultSettings() {
        }

        @Override
        public State wildcardPrefix() {
            return this.wildcardPrefixState;
        }

        @Override
        public State wildcardPostfix() {
            return this.wildcardPostfixState;
        }

        @Override
        public State spaceAsWildcard() {
            return this.spaceAsWildcard;
        }

        @Override
        public State caseSensitive() {
            return this.caseSensitiveState;
        }
    }
}

