/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.AbstractForeignKeyConditionModel;
import is.codion.framework.model.EntitySearchModel;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public final class EntitySearchConditionModel
extends AbstractForeignKeyConditionModel {
    private final EntitySearchModel entitySearchModel;
    private boolean updatingModel = false;

    private EntitySearchConditionModel(ForeignKey foreignKey, EntitySearchModel entitySearchModel) {
        super(foreignKey);
        this.entitySearchModel = Objects.requireNonNull(entitySearchModel, "entitySearchModel");
        this.bindSearchModelEvents();
    }

    public EntitySearchModel searchModel() {
        return this.entitySearchModel;
    }

    public static EntitySearchConditionModel entitySearchConditionModel(ForeignKey foreignKey, EntitySearchModel entitySearchModel) {
        return new EntitySearchConditionModel(foreignKey, entitySearchModel);
    }

    private void bindSearchModelEvents() {
        this.entitySearchModel.entities().addConsumer((Consumer)new SetEqualValues());
        this.equalValues().addConsumer((Consumer)new SetSearchModelEntities());
    }

    private final class SetEqualValues
    implements Consumer<Set<Entity>> {
        private SetEqualValues() {
        }

        @Override
        public void accept(Set<Entity> selectedEntities) {
            if (!EntitySearchConditionModel.this.updatingModel) {
                EntitySearchConditionModel.this.setEqualValues(selectedEntities);
            }
        }
    }

    private final class SetSearchModelEntities
    implements Consumer<Set<Entity>> {
        private SetSearchModelEntities() {
        }

        @Override
        public void accept(Set<Entity> equalValues) {
            EntitySearchConditionModel.this.updatingModel = true;
            try {
                EntitySearchConditionModel.this.entitySearchModel.entities().set(equalValues);
            }
            finally {
                EntitySearchConditionModel.this.updatingModel = false;
            }
        }
    }
}

