/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class EntityEditEvents {
    private static final EntityEditListener EDIT_LISTENER = new EntityEditListener();

    private EntityEditEvents() {
    }

    public static void addInsertConsumer(EntityType entityType, Consumer<Collection<Entity>> consumer) {
        EDIT_LISTENER.addInsertConsumer(entityType, consumer);
    }

    public static void addUpdateConsumer(EntityType entityType, Consumer<Map<Entity.Key, Entity>> consumer) {
        EDIT_LISTENER.addUpdateConsumer(entityType, consumer);
    }

    public static void addDeleteConsumer(EntityType entityType, Consumer<Collection<Entity>> consumer) {
        EDIT_LISTENER.addDeleteConsumer(entityType, consumer);
    }

    public static void removeInsertConsumer(EntityType entityType, Consumer<Collection<Entity>> consumer) {
        EDIT_LISTENER.removeInsertConsumer(entityType, consumer);
    }

    public static void removeUpdateConsumer(EntityType entityType, Consumer<Map<Entity.Key, Entity>> consumer) {
        EDIT_LISTENER.removeUpdateConsumer(entityType, consumer);
    }

    public static void removeDeleteConsumer(EntityType entityType, Consumer<Collection<Entity>> consumer) {
        EDIT_LISTENER.removeDeleteConsumer(entityType, consumer);
    }

    public static void notifyInserted(Collection<Entity> insertedEntities) {
        EDIT_LISTENER.notifyInserted(Objects.requireNonNull(insertedEntities));
    }

    public static void notifyUpdated(Map<Entity.Key, Entity> updatedEntities) {
        EDIT_LISTENER.notifyUpdated(Objects.requireNonNull(updatedEntities));
    }

    public static void notifyDeleted(Collection<Entity> deletedEntities) {
        EDIT_LISTENER.notifyDeleted(Objects.requireNonNull(deletedEntities));
    }

    private static final class EntityEditListener {
        private final Map<EntityType, Consumers<Collection<Entity>>> insertConsumers = new ConcurrentHashMap<EntityType, Consumers<Collection<Entity>>>();
        private final Map<EntityType, Consumers<Map<Entity.Key, Entity>>> updateConsumers = new ConcurrentHashMap<EntityType, Consumers<Map<Entity.Key, Entity>>>();
        private final Map<EntityType, Consumers<Collection<Entity>>> deleteConsumers = new ConcurrentHashMap<EntityType, Consumers<Collection<Entity>>>();

        private EntityEditListener() {
        }

        private void addInsertConsumer(EntityType entityType, Consumer<Collection<Entity>> consumer) {
            this.insertConsumers(entityType).addConsumer(consumer);
        }

        private void removeInsertConsumer(EntityType entityType, Consumer<Collection<Entity>> consumer) {
            this.insertConsumers(entityType).removeConsumer(consumer);
        }

        private void addUpdateConsumer(EntityType entityType, Consumer<Map<Entity.Key, Entity>> consumer) {
            this.updateConsumers(entityType).addConsumer(consumer);
        }

        private void removeUpdateConsumer(EntityType entityType, Consumer<Map<Entity.Key, Entity>> consumer) {
            this.updateConsumers(entityType).removeConsumer(consumer);
        }

        private void addDeleteConsumer(EntityType entityType, Consumer<Collection<Entity>> consumer) {
            this.deleteConsumers(entityType).addConsumer(consumer);
        }

        private void removeDeleteConsumer(EntityType entityType, Consumer<Collection<Entity>> consumer) {
            this.deleteConsumers(entityType).removeConsumer(consumer);
        }

        private void notifyInserted(Collection<Entity> inserted) {
            Entity.mapToType(inserted).forEach(this::notifyInserted);
        }

        private void notifyInserted(EntityType entityType, Collection<Entity> inserted) {
            Consumers<Collection<Entity>> consumers = this.insertConsumers.get(entityType);
            if (consumers != null) {
                consumers.onEvent(inserted);
            }
        }

        private void notifyUpdated(Map<Entity.Key, Entity> updated) {
            updated.entrySet().stream().collect(Collectors.groupingBy(entry -> ((Entity.Key)entry.getKey()).entityType(), LinkedHashMap::new, Collectors.toList())).forEach(this::notifyUpdated);
        }

        private void notifyUpdated(EntityType entityType, List<Map.Entry<Entity.Key, Entity>> updated) {
            Consumers<Map<Entity.Key, Entity>> consumers = this.updateConsumers.get(entityType);
            if (consumers != null) {
                consumers.onEvent(updated.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
        }

        private void notifyDeleted(Collection<Entity> deleted) {
            Entity.mapToType(deleted).forEach(this::notifyDeleted);
        }

        private void notifyDeleted(EntityType entityType, Collection<Entity> deleted) {
            Consumers<Collection<Entity>> consumers = this.deleteConsumers.get(entityType);
            if (consumers != null) {
                consumers.onEvent(deleted);
            }
        }

        private Consumers<Collection<Entity>> insertConsumers(EntityType entityType) {
            return this.insertConsumers.computeIfAbsent(Objects.requireNonNull(entityType), type -> new Consumers());
        }

        private Consumers<Map<Entity.Key, Entity>> updateConsumers(EntityType entityType) {
            return this.updateConsumers.computeIfAbsent(Objects.requireNonNull(entityType), type -> new Consumers());
        }

        private Consumers<Collection<Entity>> deleteConsumers(EntityType entityType) {
            return this.deleteConsumers.computeIfAbsent(Objects.requireNonNull(entityType), type -> new Consumers());
        }

        private static final class Consumers<T> {
            private final List<WeakReference<Consumer<T>>> consumerReferences = new ArrayList<WeakReference<Consumer<T>>>();

            private Consumers() {
            }

            private synchronized void onEvent(T data) {
                Objects.requireNonNull(data);
                Iterator<WeakReference<Consumer<T>>> iterator = this.consumerReferences.iterator();
                while (iterator.hasNext()) {
                    Consumer consumer = (Consumer)iterator.next().get();
                    if (consumer == null) {
                        iterator.remove();
                        continue;
                    }
                    consumer.accept(data);
                }
            }

            private synchronized void addConsumer(Consumer<T> consumer) {
                Objects.requireNonNull(consumer);
                for (WeakReference<Consumer<T>> reference : this.consumerReferences) {
                    if (reference.get() != consumer) continue;
                    return;
                }
                this.consumerReferences.add(new WeakReference<Consumer<T>>(consumer));
            }

            private synchronized void removeConsumer(Consumer<T> consumer) {
                Objects.requireNonNull(consumer);
                this.consumerReferences.removeIf(reference -> reference.get() == null || reference.get() == consumer);
            }
        }
    }
}

