/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.Operator;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.EntitySearchConditionModel;
import is.codion.framework.model.EntitySearchModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class EntityConditionModelFactory
implements ColumnConditionModel.Factory<Attribute<?>> {
    private final EntityConnectionProvider connectionProvider;

    public EntityConditionModelFactory(EntityConnectionProvider connectionProvider) {
        this.connectionProvider = Objects.requireNonNull(connectionProvider);
    }

    public Optional<ColumnConditionModel<? extends Attribute<?>, ?>> createConditionModel(Attribute<?> attribute) {
        if (attribute instanceof ForeignKey) {
            ForeignKey foreignKey = (ForeignKey)attribute;
            return Optional.of(EntitySearchConditionModel.entitySearchConditionModel(foreignKey, EntitySearchModel.builder(foreignKey.referencedType(), this.connectionProvider).build()));
        }
        ColumnDefinition column = this.definition(attribute.entityType()).columns().definition((Column)attribute);
        return Optional.of(ColumnConditionModel.builder(attribute, (Class)attribute.type().valueClass()).operators(EntityConditionModelFactory.operators(attribute)).format(column.format()).dateTimePattern(column.dateTimePattern()).build());
    }

    protected final EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    protected final EntityDefinition definition(EntityType entityType) {
        return this.connectionProvider.entities().definition(entityType);
    }

    private static List<Operator> operators(Attribute<?> attribute) {
        if (attribute instanceof ForeignKey) {
            return Arrays.asList(Operator.EQUAL, Operator.NOT_EQUAL);
        }
        if (attribute.type().isBoolean()) {
            return Collections.singletonList(Operator.EQUAL);
        }
        return Arrays.asList(Operator.values());
    }
}

