/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.model.table.ColumnConditionModel;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.model.EntityTableModel;
import java.util.Objects;
import java.util.Optional;
import org.json.JSONObject;

final class DefaultConditionPreferences
implements EntityTableModel.ColumnPreferences.ConditionPreferences {
    private final Attribute<?> attribute;
    private final boolean autoEnable;
    private final boolean caseSensitive;
    private final ColumnConditionModel.AutomaticWildcard automaticWildcard;

    DefaultConditionPreferences(Attribute<?> attribute, boolean autoEnable, boolean caseSensitive, ColumnConditionModel.AutomaticWildcard automaticWildcard) {
        this.attribute = attribute;
        this.autoEnable = autoEnable;
        this.caseSensitive = caseSensitive;
        this.automaticWildcard = Objects.requireNonNull(automaticWildcard);
    }

    @Override
    public Attribute<?> attribute() {
        return this.attribute;
    }

    @Override
    public boolean autoEnable() {
        return this.autoEnable;
    }

    @Override
    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public ColumnConditionModel.AutomaticWildcard automaticWildcard() {
        return this.automaticWildcard;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject conditionObject = new JSONObject();
        conditionObject.put("ae", this.autoEnable() ? 1 : 0);
        conditionObject.put("cs", this.caseSensitive() ? 1 : 0);
        conditionObject.put("aw", (Object)this.automaticWildcard());
        return conditionObject;
    }

    static Optional<EntityTableModel.ColumnPreferences.ConditionPreferences> conditionPreferences(Attribute<?> attribute, JSONObject preferences) {
        if (preferences.has(attribute.name())) {
            return Optional.of(DefaultConditionPreferences.fromJSONObject(attribute, preferences.getJSONObject(attribute.name())));
        }
        return Optional.empty();
    }

    private static EntityTableModel.ColumnPreferences.ConditionPreferences fromJSONObject(Attribute<?> attribute, JSONObject conditionObject) {
        return new DefaultConditionPreferences(attribute, conditionObject.getInt("ae") == 1, conditionObject.getInt("cs") == 1, ColumnConditionModel.AutomaticWildcard.valueOf((String)conditionObject.getString("aw")));
    }
}

