/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.model.EntityTableModel;
import java.util.Objects;
import java.util.Optional;
import org.json.JSONObject;

final class DefaultColumnPreferences
implements EntityTableModel.ColumnPreferences {
    private static final String LEGACY_COLUMN_INDEX = "index";
    private static final String LEGACY_COLUMN_WIDTH = "width";
    private final Attribute<?> attribute;
    private final int index;
    private final int width;

    DefaultColumnPreferences(Attribute<?> attribute, int index, int width) {
        this.attribute = Objects.requireNonNull(attribute);
        this.index = index;
        this.width = width;
    }

    @Override
    public Attribute<?> attribute() {
        return this.attribute;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public boolean visible() {
        return this.index != -1;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject columnObject = new JSONObject();
        columnObject.put("w", this.width());
        columnObject.put("i", this.index());
        return columnObject;
    }

    static Optional<EntityTableModel.ColumnPreferences> columnPreferences(Attribute<?> attribute, JSONObject preferences) {
        if (preferences.has(attribute.name())) {
            JSONObject jsonObject = preferences.getJSONObject(attribute.name());
            return Optional.of(jsonObject.has(LEGACY_COLUMN_INDEX) ? DefaultColumnPreferences.fromLegacyJSONObject(attribute, jsonObject) : DefaultColumnPreferences.fromJSONObject(attribute, jsonObject));
        }
        return Optional.empty();
    }

    private static EntityTableModel.ColumnPreferences fromJSONObject(Attribute<?> attribute, JSONObject jsonObject) {
        return new DefaultColumnPreferences(attribute, jsonObject.getInt("i"), jsonObject.getInt("w"));
    }

    private static EntityTableModel.ColumnPreferences fromLegacyJSONObject(Attribute<?> attribute, JSONObject jsonObject) {
        return new DefaultColumnPreferences(attribute, jsonObject.getInt(LEGACY_COLUMN_INDEX), jsonObject.getInt(LEGACY_COLUMN_WIDTH));
    }
}

