/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.db.exception.DatabaseException;
import is.codion.common.event.Event;
import is.codion.common.event.EventObserver;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.AbstractValue;
import is.codion.common.value.Value;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.EntityValidator;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.domain.entity.attribute.TransientAttributeDefinition;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.model.EntityEditEvents;
import is.codion.framework.model.EntityEditModel;
import is.codion.framework.model.EntitySearchModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityEditModel
implements EntityEditModel {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEntityEditModel.class);
    private final Entity entity;
    private final EntityConnectionProvider connectionProvider;
    private final Map<ForeignKey, EntitySearchModel> entitySearchModels = new HashMap<ForeignKey, EntitySearchModel>();
    private final Map<Attribute<?>, Value<?>> editModelValues = new ConcurrentHashMap();
    private final Map<Attribute<?>, State> persistValues = new ConcurrentHashMap();
    private final Map<Attribute<?>, Value<Supplier<?>>> defaultValues = new ConcurrentHashMap();
    private final Value<EntityValidator> validator;
    private final Value<Predicate<Entity>> modifiedPredicate;
    private final Value<Predicate<Entity>> existsPredicate;
    private final Events events = new Events();
    private final States states = new States();

    protected AbstractEntityEditModel(EntityType entityType, EntityConnectionProvider connectionProvider) {
        this.entity = Objects.requireNonNull(connectionProvider).entities().entity(entityType);
        this.connectionProvider = connectionProvider;
        this.validator = Value.value((Object)this.entityDefinition().validator(), (Object)this.entityDefinition().validator());
        this.modifiedPredicate = Value.value(Entity::modified, Entity::modified);
        this.existsPredicate = Value.value((Object)this.entityDefinition().exists(), (Object)this.entityDefinition().exists());
        this.states.readOnly.set((Object)this.entityDefinition().readOnly());
        this.events.bindEvents();
        this.configurePersistentForeignKeys();
        this.setEntity(this.createEntity(AttributeDefinition::defaultValue));
    }

    @Override
    public final Entities entities() {
        return this.connectionProvider.entities();
    }

    @Override
    public final EntityDefinition entityDefinition() {
        return this.entity.definition();
    }

    public final String toString() {
        return this.getClass() + ", " + this.entity.entityType();
    }

    @Override
    public final <S extends Supplier<T>, T> Value<S> defaultValue(Attribute<T> attribute) {
        AttributeDefinition attributeDefinition = this.entityDefinition().attributes().definition(attribute);
        return this.defaultValues.computeIfAbsent(attribute, k -> Value.value(() -> ((AttributeDefinition)attributeDefinition).defaultValue(), () -> ((AttributeDefinition)attributeDefinition).defaultValue()));
    }

    @Override
    public final State overwriteWarning() {
        return this.states.overwriteWarning;
    }

    @Override
    public final State editEvents() {
        return this.states.editEvents;
    }

    @Override
    public final State persist(Attribute<?> attribute) {
        this.entityDefinition().attributes().definition(attribute);
        return this.persistValues.computeIfAbsent(attribute, k -> State.state());
    }

    @Override
    public final State readOnly() {
        return this.states.readOnly;
    }

    @Override
    public final State insertEnabled() {
        return this.states.insertEnabled;
    }

    @Override
    public final State updateEnabled() {
        return this.states.updateEnabled;
    }

    @Override
    public final State updateMultipleEnabled() {
        return this.states.updateMultipleEnabled;
    }

    @Override
    public final State deleteEnabled() {
        return this.states.deleteEnabled;
    }

    @Override
    public final StateObserver exists() {
        return this.states.entityExists.observer();
    }

    @Override
    public final StateObserver primaryKeyNull() {
        return this.states.primaryKeyNull.observer();
    }

    @Override
    public final void set(Entity entity) {
        if (this.setEntityAllowed()) {
            this.setEntity(entity);
        }
    }

    @Override
    public final void defaults() {
        if (this.setEntityAllowed()) {
            this.setEntity(null);
        }
    }

    @Override
    public final EntityType entityType() {
        return this.entity.entityType();
    }

    @Override
    public final EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public final EntityConnection connection() {
        return this.connectionProvider.connection();
    }

    @Override
    public final void replace(ForeignKey foreignKey, Collection<Entity> entities) {
        this.replaceForeignKey(Objects.requireNonNull(foreignKey), Objects.requireNonNull(entities));
    }

    @Override
    public final Entity entity() {
        return this.entity.immutable();
    }

    @Override
    public final StateObserver modified() {
        return this.states.entityModified.observer();
    }

    @Override
    public final StateObserver modified(Attribute<?> attribute) {
        return this.states.modifiedObserver(attribute);
    }

    @Override
    public final <T> T get(Attribute<T> attribute) {
        return (T)this.entity.get(attribute);
    }

    @Override
    public final <T> Optional<T> optional(Attribute<T> attribute) {
        return this.entity.optional(attribute);
    }

    @Override
    public final <T> T put(Attribute<T> attribute, T value) {
        this.entityDefinition().attributes().definition(attribute);
        Map<Attribute<?>, Object> dependingValues = this.dependingValues(attribute);
        Object previousValue = this.entity.put(attribute, value);
        if (!Objects.equals(value, previousValue)) {
            this.events.notifyValueEdit(attribute, value, dependingValues);
        }
        return (T)previousValue;
    }

    @Override
    public final <T> T remove(Attribute<T> attribute) {
        this.entityDefinition().attributes().definition(attribute);
        Object value = null;
        if (this.entity.contains(attribute)) {
            Map<Attribute<?>, Object> dependingValues = this.dependingValues(attribute);
            value = this.entity.remove(attribute);
            this.events.notifyValueEdit(attribute, null, dependingValues);
        }
        return (T)value;
    }

    @Override
    public final void revert() {
        this.entityDefinition().attributes().get().forEach(this::revert);
    }

    @Override
    public final <T> void revert(Attribute<T> attribute) {
        if (((Boolean)this.modified(attribute).get()).booleanValue()) {
            this.put(attribute, this.entity.original(attribute));
        }
    }

    @Override
    public final boolean nullable(Attribute<?> attribute) {
        return ((EntityValidator)this.validator.get()).nullable(this.entity, attribute);
    }

    @Override
    public final StateObserver isNull(Attribute<?> attribute) {
        return this.states.nullObserver(attribute);
    }

    @Override
    public final StateObserver isNotNull(Attribute<?> attribute) {
        return this.states.nullObserver(attribute).not();
    }

    @Override
    public final StateObserver valid() {
        return this.states.entityValid.observer();
    }

    @Override
    public final StateObserver valid(Attribute<?> attribute) {
        return this.states.validObserver(attribute);
    }

    @Override
    public final void validate(Attribute<?> attribute) throws ValidationException {
        ((EntityValidator)this.validator.get()).validate(this.entity, attribute);
    }

    @Override
    public final void validate() throws ValidationException {
        this.validate(this.entity);
    }

    @Override
    public final void validate(Collection<Entity> entities) throws ValidationException {
        for (Entity entityToValidate : Objects.requireNonNull(entities)) {
            this.validate(entityToValidate);
        }
    }

    @Override
    public void validate(Entity entity) throws ValidationException {
        if (entity.entityType().equals(this.entityType())) {
            ((EntityValidator)this.validator.get()).validate(entity);
        } else {
            entity.definition().validator().validate(entity);
        }
    }

    @Override
    public final Entity insert() throws DatabaseException, ValidationException {
        return new DefaultInsert().prepare().perform().handle().iterator().next();
    }

    @Override
    public final Collection<Entity> insert(Collection<Entity> entities) throws DatabaseException, ValidationException {
        return new DefaultInsert(entities).prepare().perform().handle();
    }

    @Override
    public final Entity update() throws DatabaseException, ValidationException {
        return new DefaultUpdate().prepare().perform().handle().iterator().next();
    }

    @Override
    public final Collection<Entity> update(Collection<Entity> entities) throws DatabaseException, ValidationException {
        return new DefaultUpdate(entities).prepare().perform().handle();
    }

    @Override
    public final Entity delete() throws DatabaseException {
        return new DefaultDelete().prepare().perform().handle().iterator().next();
    }

    @Override
    public final Collection<Entity> delete(Collection<Entity> entities) throws DatabaseException {
        return new DefaultDelete(entities).prepare().perform().handle();
    }

    @Override
    public final EntityEditModel.Insert createInsert() throws ValidationException {
        return new DefaultInsert();
    }

    @Override
    public final EntityEditModel.Insert createInsert(Collection<Entity> entities) throws ValidationException {
        return new DefaultInsert(entities);
    }

    @Override
    public final EntityEditModel.Update createUpdate() throws ValidationException {
        return new DefaultUpdate();
    }

    @Override
    public final EntityEditModel.Update createUpdate(Collection<Entity> entities) throws ValidationException {
        return new DefaultUpdate(entities);
    }

    @Override
    public final EntityEditModel.Delete createDelete() {
        return new DefaultDelete();
    }

    @Override
    public final EntityEditModel.Delete createDelete(Collection<Entity> entities) {
        return new DefaultDelete(entities);
    }

    @Override
    public final void refresh() {
        try {
            if (((Boolean)this.states.entityExists.get()).booleanValue()) {
                this.set(this.connection().select(this.entity.primaryKey()));
            }
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EntitySearchModel createForeignKeySearchModel(ForeignKey foreignKey) {
        this.entityDefinition().foreignKeys().definition(foreignKey);
        Collection searchable = this.entities().definition(foreignKey.referencedType()).columns().searchable();
        if (searchable.isEmpty()) {
            throw new IllegalStateException("No searchable columns defined for entity: " + foreignKey.referencedType());
        }
        return EntitySearchModel.builder(foreignKey.referencedType(), this.connectionProvider).columns(searchable).singleSelection(true).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final EntitySearchModel foreignKeySearchModel(ForeignKey foreignKey) {
        this.entityDefinition().foreignKeys().definition(foreignKey);
        Map<ForeignKey, EntitySearchModel> map = this.entitySearchModels;
        synchronized (map) {
            EntitySearchModel entitySearchModel = this.entitySearchModels.get(foreignKey);
            if (entitySearchModel == null) {
                entitySearchModel = this.createForeignKeySearchModel(foreignKey);
                this.entitySearchModels.put(foreignKey, entitySearchModel);
            }
            return entitySearchModel;
        }
    }

    @Override
    public final <T> Value<T> value(Attribute<T> attribute) {
        this.entityDefinition().attributes().definition(attribute);
        return this.editModelValues.computeIfAbsent(attribute, k -> new EditModelValue(this, attribute));
    }

    @Override
    public final <T> EventObserver<T> editEvent(Attribute<T> attribute) {
        return this.events.editEvent(attribute);
    }

    @Override
    public final <T> EventObserver<T> valueEvent(Attribute<T> attribute) {
        return this.events.valueEvent(attribute);
    }

    @Override
    public final EventObserver<Entity> entityEvent() {
        return this.events.entity.observer();
    }

    @Override
    public final EventObserver<Collection<Entity>> beforeInsertEvent() {
        return this.events.beforeInsert.observer();
    }

    @Override
    public final EventObserver<Collection<Entity>> afterInsertEvent() {
        return this.events.afterInsert.observer();
    }

    @Override
    public final EventObserver<Map<Entity.Key, Entity>> beforeUpdateEvent() {
        return this.events.beforeUpdate.observer();
    }

    @Override
    public final EventObserver<Map<Entity.Key, Entity>> afterUpdateEvent() {
        return this.events.afterUpdate.observer();
    }

    @Override
    public final EventObserver<Collection<Entity>> beforeDeleteEvent() {
        return this.events.beforeDelete.observer();
    }

    @Override
    public final EventObserver<Collection<Entity>> afterDeleteEvent() {
        return this.events.afterDelete.observer();
    }

    @Override
    public final EventObserver<?> insertUpdateOrDeleteEvent() {
        return this.events.insertUpdateOrDelete.observer();
    }

    @Override
    public final EventObserver<State> confirmOverwriteEvent() {
        return this.events.confirmOverwrite.observer();
    }

    protected Collection<Entity> insert(Collection<Entity> entities, EntityConnection connection) throws DatabaseException {
        return Objects.requireNonNull(connection).insertSelect(entities);
    }

    protected Collection<Entity> update(Collection<Entity> entities, EntityConnection connection) throws DatabaseException {
        return Objects.requireNonNull(connection).updateSelect(entities);
    }

    protected void delete(Collection<Entity> entities, EntityConnection connection) throws DatabaseException {
        Objects.requireNonNull(connection).delete(Entity.primaryKeys(entities));
    }

    protected void replaceForeignKey(ForeignKey foreignKey, Collection<Entity> values) {
        Entity currentForeignKeyValue = this.entity.referencedEntity(foreignKey);
        if (currentForeignKeyValue != null) {
            for (Entity replacementValue : values) {
                if (!currentForeignKeyValue.equals(replacementValue)) continue;
                this.put((Attribute)foreignKey, null);
                this.put((Attribute)foreignKey, (Object)replacementValue);
            }
        }
    }

    protected final Value<EntityValidator> validator() {
        return this.validator;
    }

    protected final Value<Predicate<Entity>> modifiedPredicate() {
        return this.modifiedPredicate;
    }

    protected final Value<Predicate<Entity>> existsPredicate() {
        return this.existsPredicate;
    }

    protected final void updateModifiedState() {
        this.states.updateModifiedState();
    }

    protected final void notifyBeforeInsert(Collection<Entity> entitiesToInsert) {
        this.events.beforeInsert.accept(Objects.requireNonNull(entitiesToInsert));
    }

    protected final void notifyAfterInsert(Collection<Entity> insertedEntities) {
        this.events.afterInsert.accept(Objects.requireNonNull(insertedEntities));
    }

    protected final void notifyBeforeUpdate(Map<Entity.Key, Entity> entitiesToUpdate) {
        this.events.beforeUpdate.accept(Objects.requireNonNull(entitiesToUpdate));
    }

    protected final void notifyAfterUpdate(Map<Entity.Key, Entity> updatedEntities) {
        this.events.afterUpdate.accept(Objects.requireNonNull(updatedEntities));
    }

    protected final void notifyBeforeDelete(Collection<Entity> entitiesToDelete) {
        this.events.beforeDelete.accept(Objects.requireNonNull(entitiesToDelete));
    }

    protected final void notifyAfterDelete(Collection<Entity> deletedEntities) {
        this.events.afterDelete.accept(Objects.requireNonNull(deletedEntities));
    }

    private boolean setEntityAllowed() {
        if (((Boolean)this.states.overwriteWarning.get()).booleanValue() && ((Boolean)this.exists().get()).booleanValue() && ((Boolean)this.modified().get()).booleanValue()) {
            State confirmation = State.state((boolean)true);
            this.events.confirmOverwrite.accept((Object)confirmation);
            return (Boolean)confirmation.get();
        }
        return true;
    }

    private void setEntity(Entity entity) {
        Map affectedAttributes = this.entity.set(entity == null ? this.createEntity(this::defaultValue) : entity);
        Iterator iterator = affectedAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            Attribute affectedAttribute;
            Attribute objectAttribute = affectedAttribute = (Attribute)iterator.next();
            this.events.notifyValueChange(objectAttribute, this.entity.get(objectAttribute));
        }
        if (affectedAttributes.isEmpty()) {
            this.states.updateEntityStates();
        }
        this.states.updateAttributeModifiedStates();
        this.events.entity.accept((Object)entity);
    }

    private void configurePersistentForeignKeys() {
        if (((Boolean)EntityEditModel.PERSIST_FOREIGN_KEYS.get()).booleanValue()) {
            this.entityDefinition().foreignKeys().get().forEach(foreignKey -> this.persist((Attribute<?>)foreignKey).set((Object)this.foreignKeyWritable((ForeignKey)foreignKey)));
        }
    }

    private boolean foreignKeyWritable(ForeignKey foreignKey) {
        return foreignKey.references().stream().map(ForeignKey.Reference::column).map(arg_0 -> ((EntityDefinition.Columns)this.entityDefinition().columns()).definition(arg_0)).filter(ColumnDefinition.class::isInstance).map(ColumnDefinition.class::cast).anyMatch(columnDefinition -> !columnDefinition.readOnly());
    }

    private Entity createEntity(ValueSupplier valueSupplier) {
        EntityDefinition definition = this.entityDefinition();
        Entity newEntity = definition.entity();
        AbstractEntityEditModel.addColumnValues(valueSupplier, definition, newEntity);
        AbstractEntityEditModel.addTransientValues(valueSupplier, definition, newEntity);
        AbstractEntityEditModel.addForeignKeyValues(valueSupplier, definition, newEntity);
        newEntity.save();
        return newEntity;
    }

    private <T> T defaultValue(AttributeDefinition<T> attributeDefinition) {
        if (((Boolean)this.persist(attributeDefinition.attribute()).get()).booleanValue()) {
            if (attributeDefinition instanceof ForeignKeyDefinition) {
                return (T)this.entity.referencedEntity((ForeignKey)attributeDefinition.attribute());
            }
            return (T)this.entity.get(attributeDefinition.attribute());
        }
        return ((Supplier)this.defaultValue(attributeDefinition.attribute()).get()).get();
    }

    private Map<Attribute<?>, Object> dependingValues(Attribute<?> attribute) {
        return this.dependingValues(attribute, new LinkedHashMap());
    }

    private Map<Attribute<?>, Object> dependingValues(Attribute<?> attribute, Map<Attribute<?>, Object> dependingValues) {
        this.addDependingDerivedAttributes(attribute, dependingValues);
        if (attribute instanceof Column) {
            this.addDependingForeignKeys((Column)attribute, dependingValues);
        } else if (attribute instanceof ForeignKey) {
            this.addDependingReferencedColumns((ForeignKey)attribute, dependingValues);
        }
        return dependingValues;
    }

    private void addDependingDerivedAttributes(Attribute<?> attribute, Map<Attribute<?>, Object> dependingValues) {
        this.entityDefinition().attributes().derivedFrom(attribute).forEach(derivedAttribute -> {
            dependingValues.put((Attribute<?>)derivedAttribute, this.get((Attribute)derivedAttribute));
            this.addDependingDerivedAttributes((Attribute<?>)derivedAttribute, dependingValues);
        });
    }

    private void addDependingForeignKeys(Column<?> column, Map<Attribute<?>, Object> dependingValues) {
        this.entityDefinition().foreignKeys().definitions(column).forEach(foreignKeyDefinition -> dependingValues.put((Attribute<?>)foreignKeyDefinition.attribute(), this.get((Attribute)foreignKeyDefinition.attribute())));
    }

    private void addDependingReferencedColumns(ForeignKey foreignKey, Map<Attribute<?>, Object> dependingValues) {
        foreignKey.references().forEach(reference -> dependingValues.put((Attribute<?>)reference.column(), this.get((Attribute)reference.column())));
    }

    private static void addColumnValues(ValueSupplier valueSupplier, EntityDefinition definition, Entity newEntity) {
        definition.columns().definitions().stream().filter(columnDefinition -> !definition.foreignKeys().foreignKeyColumn(columnDefinition.attribute())).filter(columnDefinition -> !columnDefinition.columnHasDefaultValue() || columnDefinition.hasDefaultValue()).map(columnDefinition -> columnDefinition).forEach(attributeDefinition -> newEntity.put(attributeDefinition.attribute(), valueSupplier.get(attributeDefinition)));
    }

    private static void addTransientValues(ValueSupplier valueSupplier, EntityDefinition definition, Entity newEntity) {
        definition.attributes().definitions().stream().filter(TransientAttributeDefinition.class::isInstance).filter(attributeDefinition -> !attributeDefinition.derived()).map(attributeDefinition -> attributeDefinition).forEach(attributeDefinition -> newEntity.put(attributeDefinition.attribute(), valueSupplier.get(attributeDefinition)));
    }

    private static void addForeignKeyValues(ValueSupplier valueSupplier, EntityDefinition definition, Entity newEntity) {
        definition.foreignKeys().definitions().forEach(foreignKeyDefinition -> newEntity.put((Attribute)foreignKeyDefinition.attribute(), (Object)((Entity)valueSupplier.get(foreignKeyDefinition))));
    }

    private static Map<Entity.Key, Entity> mapToOriginalPrimaryKey(Collection<Entity> entitiesBeforeUpdate, Collection<Entity> entitiesAfterUpdate) {
        ArrayList<Entity> entitiesAfterUpdateCopy = new ArrayList<Entity>(entitiesAfterUpdate);
        HashMap<Entity.Key, Entity> keyMap = new HashMap<Entity.Key, Entity>(entitiesBeforeUpdate.size());
        for (Entity entity : entitiesBeforeUpdate) {
            keyMap.put(entity.originalPrimaryKey(), AbstractEntityEditModel.findAndRemove(entity.primaryKey(), entitiesAfterUpdateCopy.listIterator()));
        }
        return Collections.unmodifiableMap(keyMap);
    }

    private static Entity findAndRemove(Entity.Key primaryKey, ListIterator<Entity> iterator) {
        while (iterator.hasNext()) {
            Entity current = iterator.next();
            if (!current.primaryKey().equals(primaryKey)) continue;
            iterator.remove();
            return current;
        }
        return null;
    }

    private static Collection<Entity> entityForInsert(AbstractEntityEditModel editModel) {
        Entity toInsert = editModel.entity.copy();
        if (toInsert.definition().primaryKey().generated()) {
            toInsert.clearPrimaryKey();
        }
        return Collections.singleton(toInsert);
    }

    private final class Events {
        private final Event<Collection<Entity>> beforeInsert = Event.event();
        private final Event<Collection<Entity>> afterInsert = Event.event();
        private final Event<Map<Entity.Key, Entity>> beforeUpdate = Event.event();
        private final Event<Map<Entity.Key, Entity>> afterUpdate = Event.event();
        private final Event<Collection<Entity>> beforeDelete = Event.event();
        private final Event<Collection<Entity>> afterDelete = Event.event();
        private final Event<?> insertUpdateOrDelete = Event.event();
        private final Event<State> confirmOverwrite = Event.event();
        private final Event<Entity> entity = Event.event();
        private final Event<Attribute<?>> valueChange = Event.event();
        private final Map<Attribute<?>, Event<?>> editEvents = new ConcurrentHashMap();
        private final Map<Attribute<?>, Event<?>> valueEvents = new ConcurrentHashMap();

        private Events() {
        }

        private void bindEvents() {
            this.afterInsert.addListener(this.insertUpdateOrDelete);
            this.afterUpdate.addListener(this.insertUpdateOrDelete);
            this.afterDelete.addListener(this.insertUpdateOrDelete);
            this.afterInsert.addDataListener((Consumer)new NotifyInserted());
            this.afterUpdate.addDataListener((Consumer)new NotifyUpdated());
            this.afterDelete.addDataListener((Consumer)new NotifyDeleted());
            AbstractEntityEditModel.this.validator.addListener(AbstractEntityEditModel.this.states::updateValidState);
            AbstractEntityEditModel.this.modifiedPredicate.addListener(AbstractEntityEditModel.this.states::updateModifiedState);
            AbstractEntityEditModel.this.existsPredicate.addListener(AbstractEntityEditModel.this.states::updateExistsState);
        }

        private <T> EventObserver<T> editEvent(Attribute<T> attribute) {
            AbstractEntityEditModel.this.entityDefinition().attributes().definition(attribute);
            return this.editEvents.computeIfAbsent(attribute, k -> Event.event()).observer();
        }

        private <T> EventObserver<T> valueEvent(Attribute<T> attribute) {
            AbstractEntityEditModel.this.entityDefinition().attributes().definition(attribute);
            return this.valueEvents.computeIfAbsent(attribute, k -> Event.event()).observer();
        }

        private <T> void notifyValueEdit(Attribute<T> attribute, T value, Map<Attribute<?>, Object> dependingValues) {
            this.notifyValueChange(attribute, value);
            Event<?> editEvent = this.editEvents.get(attribute);
            if (editEvent != null) {
                editEvent.accept(value);
            }
            dependingValues.forEach((dependingAttribute, previousValue) -> {
                Object currentValue = AbstractEntityEditModel.this.get(dependingAttribute);
                if (!Objects.equals(previousValue, currentValue)) {
                    this.notifyValueEdit((Attribute)dependingAttribute, currentValue, Collections.emptyMap());
                }
            });
        }

        private <T> void notifyValueChange(Attribute<T> attribute, T value) {
            AbstractEntityEditModel.this.states.updateEntityStates();
            AbstractEntityEditModel.this.states.updateAttributeStates(attribute);
            Event<?> valueEvent = this.valueEvents.get(attribute);
            if (valueEvent != null) {
                valueEvent.accept(value);
            }
            this.valueChange.accept(attribute);
        }
    }

    private final class States {
        private final State entityValid = State.state();
        private final State entityExists = State.state((boolean)false);
        private final State entityModified = State.state();
        private final State primaryKeyNull = State.state((boolean)true);
        private final State readOnly = State.state();
        private final State insertEnabled = State.state((boolean)true);
        private final State updateEnabled = State.state((boolean)true);
        private final State updateMultipleEnabled = State.state((boolean)true);
        private final State deleteEnabled = State.state((boolean)true);
        private final State overwriteWarning = State.state((boolean)((Boolean)EntityEditModel.WARN_ABOUT_UNSAVED_DATA.get()));
        private final State editEvents = State.state((boolean)((Boolean)EntityEditModel.EDIT_EVENTS.get()));
        private final Map<Attribute<?>, State> attributeModifiedMap = new HashMap();
        private final Map<Attribute<?>, State> attributeNullMap = new HashMap();
        private final Map<Attribute<?>, State> attributeValidMap = new HashMap();

        private States() {
        }

        private StateObserver modifiedObserver(Attribute<?> attribute) {
            AbstractEntityEditModel.this.entityDefinition().attributes().definition(attribute);
            return this.attributeModifiedMap.computeIfAbsent(attribute, k -> State.state(((Boolean)this.entityExists.get() != false && AbstractEntityEditModel.this.entity.modified(attribute) ? 1 : 0) != 0)).observer();
        }

        private StateObserver nullObserver(Attribute<?> attribute) {
            AbstractEntityEditModel.this.entityDefinition().attributes().definition(attribute);
            return this.attributeNullMap.computeIfAbsent(attribute, k -> State.state((boolean)AbstractEntityEditModel.this.entity.isNull(attribute))).observer();
        }

        private StateObserver validObserver(Attribute<?> attribute) {
            AbstractEntityEditModel.this.entityDefinition().attributes().definition(attribute);
            return this.attributeValidMap.computeIfAbsent(attribute, k -> State.state((boolean)this.valid(attribute))).observer();
        }

        private void updateEntityStates() {
            this.updateExistsState();
            this.updateModifiedState();
            this.updateValidState();
            this.updatePrimaryKeyNullState();
        }

        private void updateExistsState() {
            this.entityExists.set((Object)((Predicate)AbstractEntityEditModel.this.existsPredicate.get()).test(AbstractEntityEditModel.this.entity));
        }

        private void updateModifiedState() {
            this.entityModified.set((Object)((Predicate)AbstractEntityEditModel.this.modifiedPredicate.get()).test(AbstractEntityEditModel.this.entity));
        }

        private void updateValidState() {
            this.entityValid.set((Object)((EntityValidator)AbstractEntityEditModel.this.validator.get()).valid(AbstractEntityEditModel.this.entity));
        }

        private void updatePrimaryKeyNullState() {
            this.primaryKeyNull.set((Object)AbstractEntityEditModel.this.entity.primaryKey().isNull());
        }

        private <T> void updateAttributeStates(Attribute<T> attribute) {
            State modifiedState;
            State validState;
            State nullState = this.attributeNullMap.get(attribute);
            if (nullState != null) {
                nullState.set((Object)AbstractEntityEditModel.this.entity.isNull(attribute));
            }
            if ((validState = this.attributeValidMap.get(attribute)) != null) {
                validState.set((Object)this.valid(attribute));
            }
            if ((modifiedState = this.attributeModifiedMap.get(attribute)) != null) {
                this.updateAttributeModifiedState(attribute, modifiedState);
            }
        }

        private boolean valid(Attribute<?> attribute) {
            try {
                AbstractEntityEditModel.this.validate(attribute);
                return true;
            }
            catch (ValidationException e) {
                return false;
            }
        }

        private void updateAttributeModifiedStates() {
            this.attributeModifiedMap.forEach(this::updateAttributeModifiedState);
        }

        private void updateAttributeModifiedState(Attribute<?> attribute, State modifiedState) {
            modifiedState.set((Object)(((Predicate)AbstractEntityEditModel.this.existsPredicate.get()).test(AbstractEntityEditModel.this.entity) && AbstractEntityEditModel.this.entity.modified(attribute) ? 1 : 0));
        }

        private void verifyInsertEnabled() {
            if (((Boolean)this.readOnly.get()).booleanValue() || !((Boolean)this.insertEnabled.get()).booleanValue()) {
                throw new IllegalStateException("Edit model is readOnly or inserting is not enabled!");
            }
        }

        private void verifyUpdateEnabled(int entityCount) {
            if (((Boolean)this.readOnly.get()).booleanValue() || !((Boolean)this.updateEnabled.get()).booleanValue()) {
                throw new IllegalStateException("Edit model is readOnly or updating is not enabled!");
            }
            if (entityCount > 1 && !((Boolean)this.updateMultipleEnabled.get()).booleanValue()) {
                throw new IllegalStateException("Batch update of entities is not enabled");
            }
        }

        private void verifyDeleteEnabled() {
            if (((Boolean)this.readOnly.get()).booleanValue() || !((Boolean)this.deleteEnabled.get()).booleanValue()) {
                throw new IllegalStateException("Edit model is readOnly or deleting is not enabled!");
            }
        }
    }

    private static interface ValueSupplier {
        public <T> T get(AttributeDefinition<T> var1);
    }

    private final class DefaultInsert
    implements EntityEditModel.Insert {
        private final Collection<Entity> entities;
        private final boolean activeEntity;

        private DefaultInsert() throws ValidationException {
            this(AbstractEntityEditModel.entityForInsert(abstractEntityEditModel), true);
        }

        private DefaultInsert(Collection<Entity> entities) throws ValidationException {
            this(entities, false);
        }

        private DefaultInsert(Collection<Entity> entities, boolean activeEntity) throws ValidationException {
            this.entities = Collections.unmodifiableCollection(new ArrayList<Entity>(entities));
            this.activeEntity = activeEntity;
            AbstractEntityEditModel.this.states.verifyInsertEnabled();
            AbstractEntityEditModel.this.validate(entities);
        }

        @Override
        public EntityEditModel.Insert.Task prepare() {
            AbstractEntityEditModel.this.notifyBeforeInsert(this.entities);
            return new InsertTask();
        }

        private final class InsertTask
        implements EntityEditModel.Insert.Task {
            private InsertTask() {
            }

            @Override
            public EntityEditModel.Insert.Result perform() throws DatabaseException {
                LOG.debug("{} - insert {}", (Object)this, DefaultInsert.this.entities);
                Collection<Entity> inserted = Collections.unmodifiableCollection(AbstractEntityEditModel.this.insert(DefaultInsert.this.entities, AbstractEntityEditModel.this.connectionProvider.connection()));
                if (!DefaultInsert.this.entities.isEmpty() && inserted.isEmpty()) {
                    throw new DatabaseException("Insert did not return an entity, usually caused by a misconfigured key generator");
                }
                return new InsertResult(inserted);
            }
        }

        private final class InsertResult
        implements EntityEditModel.Insert.Result {
            private final Collection<Entity> insertedEntities;

            private InsertResult(Collection<Entity> insertedEntities) {
                this.insertedEntities = insertedEntities;
            }

            @Override
            public Collection<Entity> handle() {
                AbstractEntityEditModel.this.notifyAfterInsert(this.insertedEntities);
                if (DefaultInsert.this.activeEntity) {
                    AbstractEntityEditModel.this.setEntity(this.insertedEntities.iterator().next());
                }
                return this.insertedEntities;
            }
        }
    }

    private final class DefaultUpdate
    implements EntityEditModel.Update {
        private final Collection<Entity> entities;

        private DefaultUpdate() throws ValidationException {
            this.entities = Collections.singleton(AbstractEntityEditModel.this.entity.copy());
            AbstractEntityEditModel.this.states.verifyUpdateEnabled(this.entities.size());
            AbstractEntityEditModel.this.validate(this.entities);
            this.verifyModified(this.entities);
        }

        private DefaultUpdate(Collection<Entity> entities) throws ValidationException {
            this.entities = Collections.unmodifiableCollection(new ArrayList<Entity>(entities));
            AbstractEntityEditModel.this.states.verifyUpdateEnabled(entities.size());
            AbstractEntityEditModel.this.validate(entities);
            this.verifyModified(entities);
        }

        @Override
        public EntityEditModel.Update.Task prepare() {
            AbstractEntityEditModel.this.notifyBeforeUpdate(Collections.unmodifiableMap(this.entities.stream().collect(Collectors.toMap(Entity::originalPrimaryKey, Function.identity()))));
            return new UpdateTask();
        }

        private void verifyModified(Collection<Entity> entities) {
            for (Entity entityToUpdate : entities) {
                if (entityToUpdate.modified()) continue;
                throw new IllegalArgumentException("Entity is not modified: " + entityToUpdate);
            }
        }

        private final class UpdateTask
        implements EntityEditModel.Update.Task {
            private UpdateTask() {
            }

            @Override
            public EntityEditModel.Update.Result perform() throws DatabaseException {
                LOG.debug("{} - update {}", (Object)this, DefaultUpdate.this.entities);
                return new UpdateResult(AbstractEntityEditModel.this.update(DefaultUpdate.this.entities, AbstractEntityEditModel.this.connectionProvider.connection()));
            }
        }

        private final class UpdateResult
        implements EntityEditModel.Update.Result {
            private final Collection<Entity> updatedEntities;

            private UpdateResult(Collection<Entity> updatedEntities) {
                this.updatedEntities = updatedEntities;
            }

            @Override
            public Collection<Entity> handle() {
                AbstractEntityEditModel.this.notifyAfterUpdate(AbstractEntityEditModel.mapToOriginalPrimaryKey(DefaultUpdate.this.entities, this.updatedEntities));
                Entity activeEntity = AbstractEntityEditModel.this.entity();
                this.updatedEntities.stream().filter(updatedEntity -> updatedEntity.equals(activeEntity)).findFirst().ifPresent(AbstractEntityEditModel.this::setEntity);
                return this.updatedEntities;
            }
        }
    }

    private final class DefaultDelete
    implements EntityEditModel.Delete {
        private final Collection<Entity> entities;
        private final boolean activeEntity;

        private DefaultDelete() {
            this.entities = Collections.singleton(this.activeEntity());
            this.activeEntity = true;
            AbstractEntityEditModel.this.states.verifyDeleteEnabled();
        }

        private DefaultDelete(Collection<Entity> entities) {
            this.entities = Collections.unmodifiableCollection(new ArrayList<Entity>(entities));
            this.activeEntity = false;
            AbstractEntityEditModel.this.states.verifyDeleteEnabled();
        }

        @Override
        public EntityEditModel.Delete.Task prepare() {
            AbstractEntityEditModel.this.notifyBeforeDelete(this.entities);
            return new DeleteTask();
        }

        private Entity activeEntity() {
            Entity copy = AbstractEntityEditModel.this.entity.copy();
            copy.revert();
            return copy;
        }

        private final class DeleteTask
        implements EntityEditModel.Delete.Task {
            private DeleteTask() {
            }

            @Override
            public EntityEditModel.Delete.Result perform() throws DatabaseException {
                LOG.debug("{} - delete {}", (Object)this, DefaultDelete.this.entities);
                AbstractEntityEditModel.this.delete(DefaultDelete.this.entities, AbstractEntityEditModel.this.connectionProvider.connection());
                return new DeleteResult(DefaultDelete.this.entities);
            }
        }

        private final class DeleteResult
        implements EntityEditModel.Delete.Result {
            private final Collection<Entity> deletedEntities;

            private DeleteResult(Collection<Entity> deletedEntities) {
                this.deletedEntities = deletedEntities;
            }

            @Override
            public Collection<Entity> handle() {
                AbstractEntityEditModel.this.notifyAfterDelete(this.deletedEntities);
                if (DefaultDelete.this.activeEntity) {
                    AbstractEntityEditModel.this.defaults();
                }
                return this.deletedEntities;
            }
        }
    }

    private static final class EditModelValue<T>
    extends AbstractValue<T> {
        private final EntityEditModel editModel;
        private final Attribute<T> attribute;

        private EditModelValue(EntityEditModel editModel, Attribute<T> attribute) {
            this.editModel = editModel;
            this.attribute = attribute;
            this.editModel.valueEvent(attribute).addListener(() -> this.notifyListeners());
        }

        public T get() {
            return this.editModel.get(this.attribute);
        }

        protected void setValue(T value) {
            this.editModel.put(this.attribute, value);
        }
    }

    private final class NotifyDeleted
    implements Consumer<Collection<Entity>> {
        private NotifyDeleted() {
        }

        @Override
        public void accept(Collection<Entity> deletedEntities) {
            if (((Boolean)AbstractEntityEditModel.this.states.editEvents.get()).booleanValue()) {
                EntityEditEvents.notifyDeleted(deletedEntities);
            }
        }
    }

    private final class NotifyUpdated
    implements Consumer<Map<Entity.Key, Entity>> {
        private NotifyUpdated() {
        }

        @Override
        public void accept(Map<Entity.Key, Entity> updatedEntities) {
            if (((Boolean)AbstractEntityEditModel.this.states.editEvents.get()).booleanValue()) {
                EntityEditEvents.notifyUpdated(updatedEntities);
            }
        }
    }

    private final class NotifyInserted
    implements Consumer<Collection<Entity>> {
        private NotifyInserted() {
        }

        @Override
        public void accept(Collection<Entity> insertedEntities) {
            if (((Boolean)AbstractEntityEditModel.this.states.editEvents.get()).booleanValue()) {
                EntityEditEvents.notifyInserted(insertedEntities);
            }
        }
    }
}

