/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.Configuration;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.model.FilteredModel;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.model.table.TableSelectionModel;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.DefaultColumnPreferences;
import is.codion.framework.model.DefaultConditionPreferences;
import is.codion.framework.model.EntityEditModel;
import is.codion.framework.model.EntityTableConditionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.json.JSONObject;

public interface EntityTableModel<E extends EntityEditModel>
extends FilteredModel<Entity> {
    public static final PropertyValue<Boolean> QUERY_HIDDEN_COLUMNS = Configuration.booleanValue((String)"is.codion.framework.model.EntityTableModel.queryHiddenColumns", (boolean)true);
    public static final PropertyValue<Boolean> ORDER_QUERY_BY_SORT_ORDER = Configuration.booleanValue((String)"is.codion.framework.model.EntityTableModel.orderQueryBySortOrder", (boolean)false);
    public static final PropertyValue<OnInsert> ON_INSERT = Configuration.enumValue((String)"is.codion.framework.model.EntityTableModel.onInsert", OnInsert.class, (Enum)OnInsert.ADD_TOP);

    public EntityType entityType();

    public EntityConnectionProvider connectionProvider();

    public Entities entities();

    public EntityDefinition entityDefinition();

    public <C extends E> C editModel();

    public void replace(ForeignKey var1, Collection<Entity> var2);

    public void replace(Collection<Entity> var1);

    public void refresh(Collection<Entity.Key> var1);

    public EntityTableConditionModel<Attribute<?>> conditionModel();

    public State editable();

    public Object backgroundColor(int var1, Attribute<?> var2);

    public Object foregroundColor(int var1, Attribute<?> var2);

    public ValueSet<Attribute<?>> attributes();

    public Value<Integer> limit();

    public State queryHiddenColumns();

    public State orderQueryBySortOrder();

    public void deleteSelected() throws DatabaseException;

    public State conditionRequired();

    public State editEvents();

    public Value<OnInsert> onInsert();

    public State removeDeleted();

    public Collection<Entity> find(Collection<Entity.Key> var1);

    public void select(Collection<Entity.Key> var1);

    public Optional<Entity> find(Entity.Key var1);

    public int indexOf(Entity.Key var1);

    public void savePreferences();

    public void setVisibleColumns(Attribute<?> ... var1);

    public void setVisibleColumns(List<Attribute<?>> var1);

    public void refresh();

    public void clear();

    public int getRowCount();

    public TableSelectionModel<Entity> selectionModel();

    public StateObserver conditionChanged();

    public void addSelectionListener(Runnable var1);

    public static enum OnInsert {
        DO_NOTHING,
        ADD_TOP,
        ADD_BOTTOM,
        ADD_TOP_SORTED,
        ADD_BOTTOM_SORTED;

    }

    public static interface ColumnPreferences {
        public static final String COLUMNS_KEY = "columns";
        public static final String WIDTH_KEY = "w";
        public static final String INDEX_KEY = "i";

        public Attribute<?> attribute();

        public int index();

        public boolean visible();

        public int width();

        public JSONObject toJSONObject();

        public static ColumnPreferences columnPreferences(Attribute<?> attribute, int index, int width) {
            return new DefaultColumnPreferences(attribute, index, width);
        }

        public static String toString(Map<Attribute<?>, ColumnPreferences> columnPreferences) {
            Objects.requireNonNull(columnPreferences);
            JSONObject jsonColumnPreferences = new JSONObject();
            columnPreferences.forEach((attribute, preferences) -> jsonColumnPreferences.put(attribute.name(), (Object)preferences.toJSONObject()));
            JSONObject preferencesRoot = new JSONObject();
            preferencesRoot.put(COLUMNS_KEY, (Object)jsonColumnPreferences);
            return preferencesRoot.toString();
        }

        public static Map<Attribute<?>, ColumnPreferences> fromString(Collection<Attribute<?>> attributes, String preferencesString) {
            Objects.requireNonNull(preferencesString);
            JSONObject jsonObject = new JSONObject(preferencesString).getJSONObject(COLUMNS_KEY);
            return Objects.requireNonNull(attributes).stream().map(attribute -> DefaultColumnPreferences.columnPreferences(attribute, Objects.requireNonNull(jsonObject))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ColumnPreferences::attribute, Function.identity()));
        }

        public static void apply(EntityTableModel<?> tableModel, Collection<Attribute<?>> columnAttributes, String preferencesString, BiConsumer<Attribute<?>, Integer> setColumnWidth) {
            Objects.requireNonNull(tableModel);
            Objects.requireNonNull(columnAttributes);
            Objects.requireNonNull(preferencesString);
            Objects.requireNonNull(setColumnWidth);
            Map<Attribute<?>, ColumnPreferences> columnPreferences = ColumnPreferences.fromString(columnAttributes, preferencesString);
            ArrayList columnAttributesWithoutPreferences = new ArrayList();
            for (Attribute<?> attribute : columnAttributes) {
                ColumnPreferences preferences = columnPreferences.get(attribute);
                if (preferences == null) {
                    columnAttributesWithoutPreferences.add(attribute);
                    continue;
                }
                setColumnWidth.accept(attribute, preferences.width());
            }
            List<Attribute<?>> visibleColumnAttributes = columnPreferences.values().stream().filter(ColumnPreferences::visible).sorted(Comparator.comparingInt(ColumnPreferences::index)).map(ColumnPreferences::attribute).collect(Collectors.toList());
            visibleColumnAttributes.addAll(0, columnAttributesWithoutPreferences);
            tableModel.setVisibleColumns(visibleColumnAttributes);
        }

        public static interface ConditionPreferences {
            public static final String CONDITIONS_KEY = "conditions";
            public static final String AUTO_ENABLE_KEY = "ae";
            public static final String CASE_SENSITIVE_KEY = "cs";
            public static final String AUTOMATIC_WILDCARD_KEY = "aw";

            public Attribute<?> attribute();

            public boolean autoEnable();

            public boolean caseSensitive();

            public ColumnConditionModel.AutomaticWildcard automaticWildcard();

            public JSONObject toJSONObject();

            public static ConditionPreferences conditionPreferences(Attribute<?> attribute, boolean autoEnable, boolean caseSensitive, ColumnConditionModel.AutomaticWildcard automaticWildcard) {
                return new DefaultConditionPreferences(attribute, autoEnable, caseSensitive, automaticWildcard);
            }

            public static String toString(Map<Attribute<?>, ConditionPreferences> conditionPreferences) {
                Objects.requireNonNull(conditionPreferences);
                JSONObject jsonConditionPreferences = new JSONObject();
                conditionPreferences.forEach((attribute, preferences) -> jsonConditionPreferences.put(attribute.name(), (Object)preferences.toJSONObject()));
                JSONObject preferencesRoot = new JSONObject();
                preferencesRoot.put(CONDITIONS_KEY, (Object)jsonConditionPreferences);
                return preferencesRoot.toString();
            }

            public static Map<Attribute<?>, ConditionPreferences> fromString(Collection<Attribute<?>> attributes, String preferencesString) {
                Objects.requireNonNull(preferencesString);
                JSONObject jsonObject = new JSONObject(preferencesString).getJSONObject(CONDITIONS_KEY);
                return Objects.requireNonNull(attributes).stream().map(attribute -> DefaultConditionPreferences.conditionPreferences(attribute, Objects.requireNonNull(jsonObject))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(ConditionPreferences::attribute, Function.identity()));
            }

            public static void apply(EntityTableModel<?> tableModel, List<Attribute<?>> columnAttributes, String preferencesString) {
                Objects.requireNonNull(tableModel);
                Objects.requireNonNull(columnAttributes);
                Objects.requireNonNull(preferencesString);
                Map<Attribute<?>, ConditionPreferences> conditionPreferences = ConditionPreferences.fromString(columnAttributes, preferencesString);
                for (Attribute<?> attribute : columnAttributes) {
                    ColumnConditionModel conditionModel;
                    ConditionPreferences preferences = conditionPreferences.get(attribute);
                    if (preferences == null || (conditionModel = tableModel.conditionModel().conditionModel(attribute)) == null) continue;
                    conditionModel.caseSensitive().set((Object)preferences.caseSensitive());
                    conditionModel.autoEnable().set((Object)preferences.autoEnable());
                    conditionModel.automaticWildcard().set((Object)preferences.automaticWildcard());
                }
            }
        }
    }
}

