/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.event.Event;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.model.AbstractEntityEditModel;
import is.codion.framework.model.DefaultForeignKeyDetailModelLink;
import is.codion.framework.model.DetailModelLink;
import is.codion.framework.model.EntityModel;
import is.codion.framework.model.EntityTableModel;
import is.codion.framework.model.ForeignKeyDetailModelLink;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DefaultEntityModel<M extends DefaultEntityModel<M, E, T>, E extends AbstractEntityEditModel, T extends EntityTableModel<E>>
implements EntityModel<M, E, T> {
    private static final String DETAIL_MODEL_PARAMETER = "detailModel";
    private final E editModel;
    private final T tableModel;
    private final Map<M, DetailModelLink<M, E, T>> detailModels = new HashMap<M, DetailModelLink<M, E, T>>();
    private final Event<Collection<M>> activeDetailModelsEvent = Event.event();

    public DefaultEntityModel(E editModel) {
        Objects.requireNonNull(editModel, "editModel");
        this.editModel = editModel;
        this.tableModel = null;
        this.bindEventsInternal();
    }

    public DefaultEntityModel(T tableModel) {
        Objects.requireNonNull(tableModel, "tableModel");
        this.editModel = (AbstractEntityEditModel)tableModel.editModel();
        this.tableModel = tableModel;
        this.bindEventsInternal();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + ": " + this.entityType();
    }

    @Override
    public final EntityType entityType() {
        return ((AbstractEntityEditModel)this.editModel).entityType();
    }

    @Override
    public final EntityConnectionProvider connectionProvider() {
        return ((AbstractEntityEditModel)this.editModel).connectionProvider();
    }

    @Override
    public final Entities entities() {
        return ((AbstractEntityEditModel)this.editModel).connectionProvider().entities();
    }

    @Override
    public final EntityDefinition entityDefinition() {
        return ((AbstractEntityEditModel)this.editModel).entityDefinition();
    }

    @Override
    public final <C extends E> C editModel() {
        return (C)this.editModel;
    }

    @Override
    public final <C extends T> C tableModel() {
        if (this.tableModel == null) {
            throw new IllegalStateException("Entity model " + this + " does not contain a table model");
        }
        return (C)this.tableModel;
    }

    @Override
    public final boolean containsTableModel() {
        return this.tableModel != null;
    }

    @Override
    @SafeVarargs
    public final void addDetailModels(M ... detailModels) {
        Objects.requireNonNull(detailModels, "detailModels");
        for (M detailModel : detailModels) {
            this.addDetailModel((DetailModelLink)detailModel);
        }
    }

    @Override
    public final ForeignKeyDetailModelLink<M, E, T> addDetailModel(M detailModel) {
        Objects.requireNonNull(detailModel, DETAIL_MODEL_PARAMETER);
        Collection foreignKeys = ((AbstractEntityEditModel)((DefaultEntityModel)detailModel).editModel()).entityDefinition().foreignKeys().get(((AbstractEntityEditModel)this.editModel).entityType());
        if (foreignKeys.isEmpty()) {
            throw new IllegalArgumentException("Entity " + ((AbstractEntityEditModel)((DefaultEntityModel)detailModel).editModel()).entityType() + " does not reference " + ((AbstractEntityEditModel)this.editModel).entityType() + " via a foreign key");
        }
        return this.addDetailModel(detailModel, (ForeignKey)foreignKeys.iterator().next());
    }

    @Override
    public final ForeignKeyDetailModelLink<M, E, T> addDetailModel(M detailModel, ForeignKey foreignKey) {
        Objects.requireNonNull(detailModel, DETAIL_MODEL_PARAMETER);
        Objects.requireNonNull(foreignKey, "foreignKey");
        return this.addDetailModel((DetailModelLink)new DefaultForeignKeyDetailModelLink(detailModel, foreignKey));
    }

    @Override
    public final <L extends DetailModelLink<M, E, T>> L addDetailModel(L detailModelLink) {
        Objects.requireNonNull(detailModelLink, "detailModelLink");
        if (this == detailModelLink.detailModel()) {
            throw new IllegalArgumentException("A model can not be its own detail model");
        }
        if (this.detailModels.containsKey(detailModelLink.detailModel())) {
            throw new IllegalArgumentException("Detail model " + detailModelLink.detailModel() + " has already been added");
        }
        this.detailModels.put((DefaultEntityModel)detailModelLink.detailModel(), detailModelLink);
        detailModelLink.active().addDataListener((Consumer)new ActiveDetailModelListener(detailModelLink));
        return detailModelLink;
    }

    @Override
    public final boolean containsDetailModel(Class<? extends M> modelClass) {
        Objects.requireNonNull(modelClass, "modelClass");
        return this.detailModels.keySet().stream().anyMatch(detailModel -> detailModel.getClass().equals(modelClass));
    }

    @Override
    public final boolean containsDetailModel(EntityType entityType) {
        Objects.requireNonNull(entityType, "entityType");
        return this.detailModels.keySet().stream().anyMatch(detailModel -> detailModel.entityType().equals(entityType));
    }

    @Override
    public final boolean containsDetailModel(M detailModel) {
        return this.detailModels.containsKey(Objects.requireNonNull(detailModel, DETAIL_MODEL_PARAMETER));
    }

    @Override
    public final Collection<M> detailModels() {
        return Collections.unmodifiableCollection(this.detailModels.keySet());
    }

    @Override
    public final <L extends DetailModelLink<M, E, T>> L detailModelLink(M detailModel) {
        if (!this.detailModels.containsKey(Objects.requireNonNull(detailModel))) {
            throw new IllegalStateException("Detail model not found: " + detailModel);
        }
        return (L)this.detailModels.get(detailModel);
    }

    @Override
    public final Collection<M> activeDetailModels() {
        return this.detailModels.values().stream().filter(detailModelLink -> (Boolean)detailModelLink.active().get()).map(DetailModelLink::detailModel).collect(Collectors.toList());
    }

    @Override
    public final void addActiveDetailModelsListener(Consumer<Collection<M>> listener) {
        this.activeDetailModelsEvent.addDataListener(listener);
    }

    @Override
    public final void removeActiveDetailModelsListener(Consumer<Collection<M>> listener) {
        this.activeDetailModelsEvent.removeDataListener(listener);
    }

    @Override
    public final <C extends M> C detailModel(Class<C> modelClass) {
        Objects.requireNonNull(modelClass, "modelClass");
        return (C)this.detailModels.keySet().stream().filter(detailModel -> detailModel.getClass().equals(modelClass)).findFirst().orElseThrow(() -> new IllegalArgumentException("Detail model of type " + modelClass.getName() + " not found in model: " + this));
    }

    @Override
    public final <C extends M> C detailModel(EntityType entityType) {
        Objects.requireNonNull(entityType, "entityType");
        return (C)this.detailModels.keySet().stream().filter(detailModel -> detailModel.entityType().equals(entityType)).findFirst().orElseThrow(() -> new IllegalArgumentException("No detail model for entity " + entityType + " found in model: " + this));
    }

    @Override
    public void savePreferences() {
        if (this.containsTableModel()) {
            this.tableModel().savePreferences();
        }
        this.detailModels().forEach(EntityModel::savePreferences);
    }

    private void onMasterSelectionChanged() {
        List<Entity> activeEntities = this.activeEntities();
        for (DefaultEntityModel detailModel : this.activeDetailModels()) {
            this.detailModels.get(detailModel).onSelection(activeEntities);
        }
    }

    private List<Entity> activeEntities() {
        if (this.tableModel != null && ((Boolean)this.tableModel.selectionModel().selectionNotEmpty().get()).booleanValue()) {
            return this.tableModel.selectionModel().getSelectedItems();
        }
        if (((Boolean)((AbstractEntityEditModel)this.editModel).exists().not().get()).booleanValue()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(((AbstractEntityEditModel)this.editModel).entity());
    }

    private void bindEventsInternal() {
        ((AbstractEntityEditModel)this.editModel).addAfterInsertListener(this::onInsert);
        ((AbstractEntityEditModel)this.editModel).addAfterUpdateListener(this::onUpdate);
        ((AbstractEntityEditModel)this.editModel).addAfterDeleteListener(this::onDelete);
        if (this.containsTableModel()) {
            this.tableModel.addSelectionListener(this::onMasterSelectionChanged);
        } else {
            ((AbstractEntityEditModel)this.editModel).addEntityListener(entity -> this.onMasterSelectionChanged());
        }
    }

    private void onInsert(Collection<Entity> insertedEntities) {
        this.detailModels.keySet().forEach(detailModel -> this.detailModels.get(detailModel).onInsert(insertedEntities));
    }

    private void onUpdate(Map<Entity.Key, Entity> updatedEntities) {
        this.detailModels.keySet().forEach(detailModel -> this.detailModels.get(detailModel).onUpdate(updatedEntities));
    }

    private void onDelete(Collection<Entity> deletedEntities) {
        this.detailModels.keySet().forEach(detailModel -> this.detailModels.get(detailModel).onDelete(deletedEntities));
    }

    private final class ActiveDetailModelListener
    implements Consumer<Boolean> {
        private final DetailModelLink<?, ?, ?> detailModelLink;

        private ActiveDetailModelListener(DetailModelLink<?, ?, ?> detailModelLink) {
            this.detailModelLink = detailModelLink;
        }

        @Override
        public void accept(Boolean active) {
            DefaultEntityModel.this.activeDetailModelsEvent.accept(DefaultEntityModel.this.activeDetailModels());
            if (active.booleanValue()) {
                this.detailModelLink.onSelection(DefaultEntityModel.this.activeEntities());
            }
        }
    }
}

