/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.Configuration;
import is.codion.common.property.PropertyValue;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.Value;
import is.codion.common.value.ValueSet;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.model.DefaultEntitySearchModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public interface EntitySearchModel {
    public static final PropertyValue<Integer> DEFAULT_LIMIT = Configuration.integerValue((String)"is.codion.framework.model.EntitySearchModel.defaultLimit");

    public EntityType entityType();

    public EntityConnectionProvider connectionProvider();

    public Value<Entity> entity();

    public ValueSet<Entity> entities();

    public String description();

    public Collection<Column<String>> columns();

    public void reset();

    public Value<Character> wildcard();

    public Value<Integer> limit();

    public List<Entity> search();

    public Value<Supplier<Condition>> condition();

    public Value<Function<Entity, String>> stringFunction();

    public StateObserver searchStringModified();

    public StateObserver selectionEmpty();

    public Map<Column<String>, Settings> settings();

    public Value<String> searchString();

    public Value<String> separator();

    public boolean singleSelection();

    public static Builder builder(EntityType entityType, EntityConnectionProvider connectionProvider) {
        return new DefaultEntitySearchModel.DefaultBuilder(entityType, connectionProvider);
    }

    public static interface Builder {
        public Builder columns(Collection<Column<String>> var1);

        public Builder stringFunction(Function<Entity, String> var1);

        public Builder description(String var1);

        public Builder singleSelection(boolean var1);

        public Builder separator(String var1);

        public Builder limit(int var1);

        public EntitySearchModel build();
    }

    public static interface Settings {
        public State wildcardPrefix();

        public State wildcardPostfix();

        public State caseSensitive();
    }
}

