/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.state.State;
import is.codion.common.user.User;
import is.codion.common.version.Version;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.model.AbstractEntityEditModel;
import is.codion.framework.model.DefaultEntityModel;
import is.codion.framework.model.EntityApplicationModel;
import is.codion.framework.model.EntityEditModel;
import is.codion.framework.model.EntityModel;
import is.codion.framework.model.EntityTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DefaultEntityApplicationModel<M extends DefaultEntityModel<M, E, T>, E extends AbstractEntityEditModel, T extends EntityTableModel<E>>
implements EntityApplicationModel<M, E, T> {
    private final EntityConnectionProvider connectionProvider;
    private final Version version;
    private final List<M> entityModels = new ArrayList<M>();
    private final State warnAboutUnsavedData = State.state((boolean)((Boolean)EntityEditModel.WARN_ABOUT_UNSAVED_DATA.get()));

    public DefaultEntityApplicationModel(EntityConnectionProvider connectionProvider) {
        this(connectionProvider, null);
    }

    public DefaultEntityApplicationModel(EntityConnectionProvider connectionProvider, Version version) {
        this.connectionProvider = Objects.requireNonNull(connectionProvider, "connectionProvider");
        this.version = version;
    }

    @Override
    public final User user() {
        return this.connectionProvider.connection().user();
    }

    @Override
    public final EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public final Optional<Version> version() {
        return Optional.ofNullable(this.version);
    }

    @Override
    public final Entities entities() {
        return this.connectionProvider.entities();
    }

    @Override
    @SafeVarargs
    public final void addEntityModels(M ... entityModels) {
        Objects.requireNonNull(entityModels, "entityModels");
        for (M entityModel : entityModels) {
            this.addEntityModel(entityModel);
        }
    }

    @Override
    public final void addEntityModel(M entityModel) {
        if (this.entityModels.contains(Objects.requireNonNull(entityModel))) {
            throw new IllegalArgumentException("Entity model " + entityModel + " has already been added");
        }
        this.entityModels.add(entityModel);
    }

    @Override
    public final boolean containsEntityModel(Class<? extends M> modelClass) {
        return this.entityModels.stream().anyMatch(entityModel -> entityModel.getClass().equals(modelClass));
    }

    @Override
    public final boolean containsEntityModel(EntityType entityType) {
        return this.entityModels.stream().anyMatch(entityModel -> entityModel.entityType().equals(entityType));
    }

    @Override
    public final boolean containsEntityModel(M entityModel) {
        return this.entityModels.contains(entityModel);
    }

    @Override
    public final List<M> entityModels() {
        return Collections.unmodifiableList(this.entityModels);
    }

    @Override
    public final void refresh() {
        for (DefaultEntityModel entityModel : this.entityModels) {
            if (!entityModel.containsTableModel()) continue;
            entityModel.tableModel().refresh();
        }
    }

    @Override
    public final <C extends M> C entityModel(Class<C> modelClass) {
        for (DefaultEntityModel model : this.entityModels) {
            if (!model.getClass().equals(modelClass)) continue;
            return (C)model;
        }
        throw new IllegalArgumentException("EntityModel of type: " + modelClass + " not found");
    }

    @Override
    public final <C extends M> C entityModel(EntityType entityType) {
        for (DefaultEntityModel entityModel : this.entityModels) {
            if (!entityModel.entityType().equals(entityType)) continue;
            return (C)entityModel;
        }
        throw new IllegalArgumentException("EntityModel for type " + entityType + " not  found in model: " + this);
    }

    @Override
    public final State warnAboutUnsavedData() {
        return this.warnAboutUnsavedData;
    }

    @Override
    public final boolean containsUnsavedData() {
        return DefaultEntityApplicationModel.existingEntityModified(this.entityModels);
    }

    @Override
    public void savePreferences() {
        this.entityModels().forEach(EntityModel::savePreferences);
    }

    private static boolean existingEntityModified(Collection<? extends EntityModel<?, ?, ?>> models) {
        for (EntityModel<?, ?, ?> model : models) {
            Object editModel = model.editModel();
            if ((!((Boolean)editModel.exists().get()).booleanValue() || !((Boolean)editModel.modified().get()).booleanValue()) && !DefaultEntityApplicationModel.existingEntityModified(model.detailModels())) continue;
            return true;
        }
        return false;
    }
}

