/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class EntityEditEvents {
    private static final EntityEditListener EDIT_LISTENER = new EntityEditListener();

    private EntityEditEvents() {
    }

    public static void addInsertListener(EntityType entityType, Consumer<Collection<Entity>> listener) {
        EDIT_LISTENER.addInsertListener(entityType, listener);
    }

    public static void addUpdateListener(EntityType entityType, Consumer<Map<Entity.Key, Entity>> listener) {
        EDIT_LISTENER.addUpdateListener(entityType, listener);
    }

    public static void addDeleteListener(EntityType entityType, Consumer<Collection<Entity>> listener) {
        EDIT_LISTENER.addDeleteListener(entityType, listener);
    }

    public static void removeInsertListener(EntityType entityType, Consumer<Collection<Entity>> listener) {
        EDIT_LISTENER.removeInsertListener(entityType, listener);
    }

    public static void removeUpdateListener(EntityType entityType, Consumer<Map<Entity.Key, Entity>> listener) {
        EDIT_LISTENER.removeUpdateListener(entityType, listener);
    }

    public static void removeDeleteListener(EntityType entityType, Consumer<Collection<Entity>> listener) {
        EDIT_LISTENER.removeDeleteListener(entityType, listener);
    }

    public static void notifyInserted(Collection<Entity> insertedEntities) {
        EDIT_LISTENER.notifyInserted(Objects.requireNonNull(insertedEntities));
    }

    public static void notifyUpdated(Map<Entity.Key, Entity> updatedEntities) {
        EDIT_LISTENER.notifyUpdated(Objects.requireNonNull(updatedEntities));
    }

    public static void notifyDeleted(Collection<Entity> deletedEntities) {
        EDIT_LISTENER.notifyDeleted(Objects.requireNonNull(deletedEntities));
    }

    private static final class EntityEditListener {
        private final Map<EntityType, Listeners<Collection<Entity>>> insertListeners = new ConcurrentHashMap<EntityType, Listeners<Collection<Entity>>>();
        private final Map<EntityType, Listeners<Map<Entity.Key, Entity>>> updateListeners = new ConcurrentHashMap<EntityType, Listeners<Map<Entity.Key, Entity>>>();
        private final Map<EntityType, Listeners<Collection<Entity>>> deleteListeners = new ConcurrentHashMap<EntityType, Listeners<Collection<Entity>>>();

        private EntityEditListener() {
        }

        private void addInsertListener(EntityType entityType, Consumer<Collection<Entity>> listener) {
            this.insertListeners(entityType).addDataListener(listener);
        }

        private void removeInsertListener(EntityType entityType, Consumer<Collection<Entity>> listener) {
            this.insertListeners(entityType).removeDataListener(listener);
        }

        private void addUpdateListener(EntityType entityType, Consumer<Map<Entity.Key, Entity>> listener) {
            this.updateListeners(entityType).addDataListener(listener);
        }

        private void removeUpdateListener(EntityType entityType, Consumer<Map<Entity.Key, Entity>> listener) {
            this.updateListeners(entityType).removeDataListener(listener);
        }

        private void addDeleteListener(EntityType entityType, Consumer<Collection<Entity>> listener) {
            this.deleteListeners(entityType).addDataListener(listener);
        }

        private void removeDeleteListener(EntityType entityType, Consumer<Collection<Entity>> listener) {
            this.deleteListeners(entityType).removeDataListener(listener);
        }

        private void notifyInserted(Collection<Entity> inserted) {
            Entity.mapToType(inserted).forEach(this::notifyInserted);
        }

        private void notifyInserted(EntityType entityType, Collection<Entity> inserted) {
            Listeners<Collection<Entity>> listeners = this.insertListeners.get(entityType);
            if (listeners != null) {
                listeners.onEvent(inserted);
            }
        }

        private void notifyUpdated(Map<Entity.Key, Entity> updated) {
            updated.entrySet().stream().collect(Collectors.groupingBy(entry -> ((Entity.Key)entry.getKey()).entityType(), LinkedHashMap::new, Collectors.toList())).forEach(this::notifyUpdated);
        }

        private void notifyUpdated(EntityType entityType, List<Map.Entry<Entity.Key, Entity>> updated) {
            Listeners<Map<Entity.Key, Entity>> listeners = this.updateListeners.get(entityType);
            if (listeners != null) {
                listeners.onEvent(updated.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
        }

        private void notifyDeleted(Collection<Entity> deleted) {
            Entity.mapToType(deleted).forEach(this::notifyDeleted);
        }

        private void notifyDeleted(EntityType entityType, Collection<Entity> deleted) {
            Listeners<Collection<Entity>> listeners = this.deleteListeners.get(entityType);
            if (listeners != null) {
                listeners.onEvent(deleted);
            }
        }

        private Listeners<Collection<Entity>> insertListeners(EntityType entityType) {
            return this.insertListeners.computeIfAbsent(Objects.requireNonNull(entityType), type -> new Listeners());
        }

        private Listeners<Map<Entity.Key, Entity>> updateListeners(EntityType entityType) {
            return this.updateListeners.computeIfAbsent(Objects.requireNonNull(entityType), type -> new Listeners());
        }

        private Listeners<Collection<Entity>> deleteListeners(EntityType entityType) {
            return this.deleteListeners.computeIfAbsent(Objects.requireNonNull(entityType), type -> new Listeners());
        }

        private static final class Listeners<T> {
            private final List<WeakReference<Consumer<T>>> listenerReferences = new ArrayList<WeakReference<Consumer<T>>>();

            private Listeners() {
            }

            private synchronized void onEvent(T data) {
                Objects.requireNonNull(data);
                Iterator<WeakReference<Consumer<T>>> iterator = this.listenerReferences.iterator();
                while (iterator.hasNext()) {
                    Consumer listener = (Consumer)iterator.next().get();
                    if (listener == null) {
                        iterator.remove();
                        continue;
                    }
                    listener.accept(data);
                }
            }

            private synchronized void addDataListener(Consumer<T> listener) {
                Objects.requireNonNull(listener);
                for (WeakReference<Consumer<T>> reference : this.listenerReferences) {
                    if (reference.get() != listener) continue;
                    return;
                }
                this.listenerReferences.add(new WeakReference<Consumer<T>>(listener));
            }

            private synchronized void removeDataListener(Consumer<T> listener) {
                Objects.requireNonNull(listener);
                this.listenerReferences.removeIf(reference -> reference.get() == null || reference.get() == listener);
            }
        }
    }
}

