/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.Conjunction;
import is.codion.common.NullOrEmpty;
import is.codion.common.Operator;
import is.codion.common.event.Event;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.model.table.TableConditionModel;
import is.codion.common.value.Value;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.condition.ColumnCondition;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.model.EntityTableConditionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class DefaultEntityTableConditionModel<C extends Attribute<?>>
implements EntityTableConditionModel<C> {
    private static final Supplier<Condition> NULL_CONDITION_SUPPLIER = () -> null;
    private final EntityDefinition entityDefinition;
    private final EntityConnectionProvider connectionProvider;
    private final TableConditionModel<C> conditionModel;
    private final Event<?> conditionChangedEvent = Event.event();
    private final Value<Supplier<Condition>> additionalWhere = Value.value(NULL_CONDITION_SUPPLIER, NULL_CONDITION_SUPPLIER);
    private final Value<Supplier<Condition>> additionalHaving = Value.value(NULL_CONDITION_SUPPLIER, NULL_CONDITION_SUPPLIER);
    private final NoneAggregatePredicate noneAggregatePredicate = new NoneAggregatePredicate();
    private final AggregatePredicate aggregatePredicate = new AggregatePredicate();

    DefaultEntityTableConditionModel(EntityType entityType, EntityConnectionProvider connectionProvider, ColumnConditionModel.Factory<C> conditionModelFactory) {
        this.entityDefinition = connectionProvider.entities().definition(Objects.requireNonNull(entityType, "entityType"));
        this.connectionProvider = Objects.requireNonNull(connectionProvider, "connectionProvider");
        this.conditionModel = TableConditionModel.tableConditionModel(this.createConditionModels(entityType, conditionModelFactory));
        this.bindEvents();
    }

    @Override
    public EntityType entityType() {
        return this.entityDefinition.entityType();
    }

    @Override
    public <T> boolean setEqualConditionValues(Attribute<T> attribute, Collection<T> values) {
        boolean aggregateColumn = attribute instanceof Column && this.entityDefinition.columns().definition((Column)attribute).aggregate();
        Condition condition = aggregateColumn ? this.having(Conjunction.AND) : this.where(Conjunction.AND);
        ColumnConditionModel columnConditionModel = (ColumnConditionModel)this.conditionModel.conditionModels().get(attribute);
        if (columnConditionModel != null) {
            columnConditionModel.operator().set((Object)Operator.EQUAL);
            columnConditionModel.setEqualValues(values != null && values.isEmpty() ? null : values);
            columnConditionModel.enabled().set((Object)(!NullOrEmpty.nullOrEmpty(values) ? 1 : 0));
        }
        return !condition.equals(aggregateColumn ? this.having(Conjunction.AND) : this.where(Conjunction.AND));
    }

    @Override
    public Condition where(Conjunction conjunction) {
        Objects.requireNonNull(conjunction);
        Collection<Condition> conditions = this.conditions(this.noneAggregatePredicate, (Condition)((Supplier)this.additionalWhere.get()).get());
        return conditions.isEmpty() ? Condition.all((EntityType)this.entityDefinition.entityType()) : Condition.combination((Conjunction)conjunction, conditions);
    }

    @Override
    public Condition having(Conjunction conjunction) {
        Objects.requireNonNull(conjunction);
        Collection<Condition> conditions = this.conditions(this.aggregatePredicate, (Condition)((Supplier)this.additionalHaving.get()).get());
        return conditions.isEmpty() ? Condition.all((EntityType)this.entityDefinition.entityType()) : Condition.combination((Conjunction)conjunction, conditions);
    }

    @Override
    public Value<Supplier<Condition>> additionalWhere() {
        return this.additionalWhere;
    }

    @Override
    public Value<Supplier<Condition>> additionalHaving() {
        return this.additionalHaving;
    }

    public Map<C, ColumnConditionModel<C, ?>> conditionModels() {
        return this.conditionModel.conditionModels();
    }

    public <T> ColumnConditionModel<? extends C, T> conditionModel(C columnIdentifier) {
        return this.conditionModel.conditionModel(columnIdentifier);
    }

    @Override
    public <A extends Attribute<T>, T> ColumnConditionModel<A, T> attributeModel(A columnIdentifier) {
        return this.conditionModel((C)columnIdentifier);
    }

    public boolean enabled() {
        return this.conditionModel.enabled();
    }

    public boolean enabled(C columnIdentifier) {
        return this.conditionModel.enabled(columnIdentifier);
    }

    public void addChangeListener(Runnable listener) {
        this.conditionModel.addChangeListener(listener);
    }

    public void removeChangeListener(Runnable listener) {
        this.conditionModel.removeChangeListener(listener);
    }

    public void clear() {
        this.conditionModel.clear();
    }

    private Collection<Condition> conditions(Predicate<ColumnConditionModel<?, ?>> conditionModelTypePredicate, Condition additionalCondition) {
        List conditions = this.conditionModel.conditionModels().values().stream().filter(model -> (Boolean)model.enabled().get()).filter(conditionModelTypePredicate).map(DefaultEntityTableConditionModel::condition).collect(Collectors.toCollection(ArrayList::new));
        if (additionalCondition != null) {
            conditions.add(additionalCondition);
        }
        return conditions;
    }

    private void bindEvents() {
        this.conditionModel.conditionModels().values().forEach(columnConditionModel -> columnConditionModel.addChangeListener(this.conditionChangedEvent));
        this.additionalWhere.addListener(this.conditionChangedEvent);
        this.additionalHaving.addListener(this.conditionChangedEvent);
    }

    private Collection<ColumnConditionModel<C, ?>> createConditionModels(EntityType entityType, ColumnConditionModel.Factory<C> conditionModelFactory) {
        ArrayList models = new ArrayList();
        EntityDefinition definition = this.connectionProvider.entities().definition(entityType);
        definition.columns().definitions().forEach(columnDefinition -> conditionModelFactory.createConditionModel((Object)columnDefinition.attribute()).ifPresent(models::add));
        definition.foreignKeys().definitions().forEach(foreignKeyDefinition -> conditionModelFactory.createConditionModel((Object)foreignKeyDefinition.attribute()).ifPresent(models::add));
        return models.stream().map(model -> model).collect(Collectors.toList());
    }

    private static Condition condition(ColumnConditionModel<?, ?> conditionModel) {
        if (conditionModel.columnIdentifier() instanceof ForeignKey) {
            return DefaultEntityTableConditionModel.foreignKeyCondition(conditionModel);
        }
        return DefaultEntityTableConditionModel.columnCondition(conditionModel);
    }

    private static Condition foreignKeyCondition(ColumnConditionModel<?, Entity> conditionModel) {
        ForeignKey foreignKey = (ForeignKey)conditionModel.columnIdentifier();
        Collection values = (Collection)conditionModel.equalValues().get();
        switch ((Operator)conditionModel.operator().get()) {
            case EQUAL: {
                return values.isEmpty() ? foreignKey.isNull() : foreignKey.in(values);
            }
            case NOT_EQUAL: {
                return values.isEmpty() ? foreignKey.isNotNull() : foreignKey.notIn(values);
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + conditionModel.operator().get() + " for foreign key condition");
    }

    private static <T> ColumnCondition<T> columnCondition(ColumnConditionModel<?, T> conditionModel) {
        Column column = (Column)conditionModel.columnIdentifier();
        switch ((Operator)conditionModel.operator().get()) {
            case EQUAL: {
                return DefaultEntityTableConditionModel.equalCondition(conditionModel, column);
            }
            case NOT_EQUAL: {
                return DefaultEntityTableConditionModel.notEqualCondition(conditionModel, column);
            }
            case LESS_THAN: {
                return column.lessThan(conditionModel.getUpperBound());
            }
            case LESS_THAN_OR_EQUAL: {
                return column.lessThanOrEqualTo(conditionModel.getUpperBound());
            }
            case GREATER_THAN: {
                return column.greaterThan(conditionModel.getLowerBound());
            }
            case GREATER_THAN_OR_EQUAL: {
                return column.greaterThanOrEqualTo(conditionModel.getLowerBound());
            }
            case BETWEEN_EXCLUSIVE: {
                return column.betweenExclusive(conditionModel.getLowerBound(), conditionModel.getUpperBound());
            }
            case BETWEEN: {
                return column.between(conditionModel.getLowerBound(), conditionModel.getUpperBound());
            }
            case NOT_BETWEEN_EXCLUSIVE: {
                return column.notBetweenExclusive(conditionModel.getLowerBound(), conditionModel.getUpperBound());
            }
            case NOT_BETWEEN: {
                return column.notBetween(conditionModel.getLowerBound(), conditionModel.getUpperBound());
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + conditionModel.operator().get());
    }

    private static <T> ColumnCondition<T> equalCondition(ColumnConditionModel<?, T> conditionModel, Column<T> column) {
        Collection equalToValues = conditionModel.getEqualValues();
        if (equalToValues.isEmpty()) {
            return column.isNull();
        }
        if (column.type().isString() && equalToValues.size() == 1) {
            return DefaultEntityTableConditionModel.singleStringEqualCondition(conditionModel, column, (String)equalToValues.iterator().next());
        }
        if (column.type().isCharacter() && equalToValues.size() == 1) {
            return DefaultEntityTableConditionModel.singleCharacterEqualCondition(conditionModel, column, (Character)equalToValues.iterator().next());
        }
        return column.in(equalToValues);
    }

    private static <T> ColumnCondition<T> notEqualCondition(ColumnConditionModel<?, T> conditionModel, Column<T> column) {
        Collection equalToValues = conditionModel.getEqualValues();
        if (equalToValues.isEmpty()) {
            return column.isNotNull();
        }
        if (column.type().isString() && equalToValues.size() == 1) {
            return DefaultEntityTableConditionModel.singleStringNotEqualCondition(conditionModel, column, (String)equalToValues.iterator().next());
        }
        if (column.type().isCharacter() && equalToValues.size() == 1) {
            return DefaultEntityTableConditionModel.singleCharacterNotEqualCondition(conditionModel, column, (Character)equalToValues.iterator().next());
        }
        return column.notIn(equalToValues);
    }

    private static <T> ColumnCondition<T> singleStringEqualCondition(ColumnConditionModel<?, T> conditionModel, Column<T> column, String value) {
        boolean caseSensitive = (Boolean)conditionModel.caseSensitive().get();
        if (DefaultEntityTableConditionModel.containsWildcards(value)) {
            return caseSensitive ? column.like(value) : column.likeIgnoreCase(value);
        }
        return caseSensitive ? column.equalTo((Object)value) : column.equalToIgnoreCase(value);
    }

    private static <T> ColumnCondition<T> singleCharacterEqualCondition(ColumnConditionModel<?, T> conditionModel, Column<T> column, Character value) {
        return (Boolean)conditionModel.caseSensitive().get() != false ? column.equalTo((Object)value) : column.equalToIgnoreCase(value);
    }

    private static <T> ColumnCondition<T> singleStringNotEqualCondition(ColumnConditionModel<?, T> conditionModel, Column<T> column, String value) {
        boolean caseSensitive = (Boolean)conditionModel.caseSensitive().get();
        if (DefaultEntityTableConditionModel.containsWildcards(value)) {
            return caseSensitive ? column.notLike(value) : column.notLikeIgnoreCase(value);
        }
        return caseSensitive ? column.notEqualTo((Object)value) : column.notEqualToIgnoreCase(value);
    }

    private static <T> ColumnCondition<T> singleCharacterNotEqualCondition(ColumnConditionModel<?, T> conditionModel, Column<T> column, Character value) {
        return (Boolean)conditionModel.caseSensitive().get() != false ? column.notEqualTo((Object)value) : column.notEqualToIgnoreCase(value);
    }

    private static boolean containsWildcards(String value) {
        return value != null && (value.contains("%") || value.contains("_"));
    }

    private final class NoneAggregatePredicate
    implements Predicate<ColumnConditionModel<?, ?>> {
        private NoneAggregatePredicate() {
        }

        @Override
        public boolean test(ColumnConditionModel<?, ?> conditionModel) {
            return !(conditionModel.columnIdentifier() instanceof Column) || !DefaultEntityTableConditionModel.this.entityDefinition.columns().definition((Column)conditionModel.columnIdentifier()).aggregate();
        }
    }

    private final class AggregatePredicate
    implements Predicate<ColumnConditionModel<?, ?>> {
        private AggregatePredicate() {
        }

        @Override
        public boolean test(ColumnConditionModel<?, ?> conditionModel) {
            return conditionModel.columnIdentifier() instanceof Column && DefaultEntityTableConditionModel.this.entityDefinition.columns().definition((Column)conditionModel.columnIdentifier()).aggregate();
        }
    }
}

