/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model;

import is.codion.common.db.exception.DatabaseException;
import is.codion.common.db.exception.UpdateException;
import is.codion.common.event.Event;
import is.codion.common.state.State;
import is.codion.common.state.StateObserver;
import is.codion.common.value.AbstractValue;
import is.codion.common.value.Value;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.EntityValidator;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.domain.entity.attribute.TransientAttributeDefinition;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.model.EntityEditEvents;
import is.codion.framework.model.EntityEditModel;
import is.codion.framework.model.EntitySearchModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityEditModel
implements EntityEditModel {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEntityEditModel.class);
    private static final String ENTITIES = "entities";
    private final Event<Collection<Entity>> beforeInsertEvent = Event.event();
    private final Event<Collection<Entity>> afterInsertEvent = Event.event();
    private final Event<Map<Entity.Key, Entity>> beforeUpdateEvent = Event.event();
    private final Event<Map<Entity.Key, Entity>> afterUpdateEvent = Event.event();
    private final Event<Collection<Entity>> beforeDeleteEvent = Event.event();
    private final Event<Collection<Entity>> afterDeleteEvent = Event.event();
    private final Event<?> insertUpdateOrDeleteEvent = Event.event();
    private final Event<State> confirmOverwriteEvent = Event.event();
    private final Event<Entity> entityEvent = Event.event();
    private final Event<Attribute<?>> valueChangeEvent = Event.event();
    private final State entityValid = State.state();
    private final State entityExists = State.state((boolean)false);
    private final State entityModified = State.state();
    private final State primaryKeyNull = State.state((boolean)true);
    private final State readOnly = State.state();
    private final State insertEnabled = State.state((boolean)true);
    private final State updateEnabled = State.state((boolean)true);
    private final State updateMultipleEnabled = State.state((boolean)true);
    private final State deleteEnabled = State.state((boolean)true);
    private final State overwriteWarning = State.state((boolean)((Boolean)WARN_ABOUT_UNSAVED_DATA.get()));
    private final State editEvents = State.state((boolean)((Boolean)EDIT_EVENTS.get()));
    private final Map<Attribute<?>, State> attributeModifiedMap = new HashMap();
    private final Map<Attribute<?>, State> attributeNullMap = new HashMap();
    private final Map<Attribute<?>, State> attributeValidMap = new HashMap();
    private final Entity entity;
    private final EntityConnectionProvider connectionProvider;
    private final EntityValidator validator;
    private final Map<ForeignKey, EntitySearchModel> entitySearchModels = new HashMap<ForeignKey, EntitySearchModel>();
    private final Map<Attribute<?>, Value<?>> editModelValues = new ConcurrentHashMap();
    private final Map<Attribute<?>, State> persistValues = new ConcurrentHashMap();
    private final Map<Attribute<?>, Event<?>> valueEditEvents = new ConcurrentHashMap();
    private final Map<Attribute<?>, Event<?>> valueChangeEvents = new ConcurrentHashMap();
    private final Map<Attribute<?>, Supplier<?>> defaultValueSuppliers = new ConcurrentHashMap();
    private final Value<Predicate<Entity>> modifiedPredicate;
    private final Value<Predicate<Entity>> existsPredicate;

    protected AbstractEntityEditModel(EntityType entityType, EntityConnectionProvider connectionProvider) {
        this(Objects.requireNonNull(entityType), Objects.requireNonNull(connectionProvider), connectionProvider.entities().definition(entityType).validator());
    }

    protected AbstractEntityEditModel(EntityType entityType, EntityConnectionProvider connectionProvider, EntityValidator validator) {
        this.entity = Objects.requireNonNull(connectionProvider).entities().entity(entityType);
        this.connectionProvider = connectionProvider;
        this.validator = Objects.requireNonNull(validator);
        this.modifiedPredicate = Value.value(Entity::modified, Entity::modified);
        this.existsPredicate = Value.value((Object)this.entity.definition().exists(), (Object)this.entity.definition().exists());
        this.readOnly.set((Object)this.entityDefinition().readOnly());
        this.configurePersistentForeignKeys();
        this.bindEventsInternal();
        this.setEntity(this.defaultEntity(AttributeDefinition::defaultValue));
    }

    @Override
    public final Entities entities() {
        return this.connectionProvider.entities();
    }

    @Override
    public final EntityDefinition entityDefinition() {
        return this.entity.definition();
    }

    public final String toString() {
        return this.getClass() + ", " + this.entity.entityType();
    }

    @Override
    public final <T> void setDefault(Attribute<T> attribute, Supplier<T> defaultValue) {
        this.entityDefinition().attributes().definition(attribute);
        this.defaultValueSuppliers.put(attribute, Objects.requireNonNull(defaultValue, "defaultValue"));
    }

    @Override
    public final State overwriteWarning() {
        return this.overwriteWarning;
    }

    @Override
    public final State editEvents() {
        return this.editEvents;
    }

    @Override
    public final State persist(Attribute<?> attribute) {
        this.entityDefinition().attributes().definition(attribute);
        return this.persistValues.computeIfAbsent(attribute, k -> State.state());
    }

    @Override
    public final State readOnly() {
        return this.readOnly;
    }

    @Override
    public final State insertEnabled() {
        return this.insertEnabled;
    }

    @Override
    public final State updateEnabled() {
        return this.updateEnabled;
    }

    @Override
    public final State updateMultipleEnabled() {
        return this.updateMultipleEnabled;
    }

    @Override
    public final State deleteEnabled() {
        return this.deleteEnabled;
    }

    @Override
    public final StateObserver exists() {
        return this.entityExists.observer();
    }

    @Override
    public final StateObserver primaryKeyNull() {
        return this.primaryKeyNull.observer();
    }

    @Override
    public final void set(Entity entity) {
        if (this.setEntityAllowed()) {
            this.setEntity(entity);
        }
    }

    @Override
    public final void setDefaults() {
        if (this.setEntityAllowed()) {
            this.setEntity(null);
        }
    }

    @Override
    public final EntityType entityType() {
        return this.entity.entityType();
    }

    @Override
    public final EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public final void replace(ForeignKey foreignKey, Collection<Entity> entities) {
        this.replaceForeignKey(Objects.requireNonNull(foreignKey), Objects.requireNonNull(entities));
    }

    @Override
    public final Entity entity() {
        return this.entity.immutable();
    }

    @Override
    public final Entity referencedEntity(ForeignKey foreignKey) {
        return this.entity.referencedEntity(foreignKey);
    }

    @Override
    public StateObserver modified() {
        return this.entityModified.observer();
    }

    @Override
    public final StateObserver modified(Attribute<?> attribute) {
        this.entityDefinition().attributes().definition(attribute);
        return this.attributeModifiedMap.computeIfAbsent(attribute, k -> State.state(((Boolean)this.entityExists.get() != false && this.entity.modified(attribute) ? 1 : 0) != 0)).observer();
    }

    @Override
    public final <T> T get(Attribute<T> attribute) {
        return (T)this.entity.get(attribute);
    }

    @Override
    public final <T> Optional<T> optional(Attribute<T> attribute) {
        return this.entity.optional(attribute);
    }

    @Override
    public final <T> T put(Attribute<T> attribute, T value) {
        this.entityDefinition().attributes().definition(attribute);
        Map<Attribute<?>, Object> dependingValues = this.dependingValues(attribute);
        Object previousValue = this.entity.put(attribute, value);
        if (!Objects.equals(value, previousValue)) {
            this.notifyValueEdit(attribute, value, dependingValues);
        }
        return (T)previousValue;
    }

    @Override
    public final <T> T remove(Attribute<T> attribute) {
        this.entityDefinition().attributes().definition(attribute);
        Object value = null;
        if (this.entity.contains(attribute)) {
            Map<Attribute<?>, Object> dependingValues = this.dependingValues(attribute);
            value = this.entity.remove(attribute);
            this.notifyValueEdit(attribute, null, dependingValues);
        }
        return (T)value;
    }

    @Override
    public final boolean nullable(Attribute<?> attribute) {
        return this.validator.nullable(this.entity, attribute);
    }

    @Override
    public final StateObserver isNull(Attribute<?> attribute) {
        return this.nullObserver(attribute);
    }

    @Override
    public final StateObserver isNotNull(Attribute<?> attribute) {
        return this.nullObserver(attribute).not();
    }

    @Override
    public final StateObserver valid() {
        return this.entityValid.observer();
    }

    @Override
    public final StateObserver valid(Attribute<?> attribute) {
        return this.validObserver(attribute);
    }

    @Override
    public final void validate(Attribute<?> attribute) throws ValidationException {
        this.validator.validate(this.entity, attribute);
    }

    @Override
    public final void validate() throws ValidationException {
        this.validate(this.entity);
    }

    @Override
    public final void validate(Collection<? extends Entity> entities) throws ValidationException {
        for (Entity entity : entities) {
            this.validate(entity);
        }
    }

    @Override
    public void validate(Entity entity) throws ValidationException {
        if (entity.entityType().equals(this.entityType())) {
            this.validator.validate(entity);
        } else {
            entity.definition().validator().validate(entity);
        }
    }

    @Override
    public final EntityValidator validator() {
        return this.validator;
    }

    @Override
    public final Entity insert() throws DatabaseException, ValidationException {
        if (((Boolean)this.readOnly.get()).booleanValue() || !((Boolean)this.insertEnabled.get()).booleanValue()) {
            throw new IllegalStateException("Edit model is readOnly or inserting is not enabled!");
        }
        Entity toInsert = this.entity.copy();
        if (this.entityDefinition().primaryKey().generated()) {
            toInsert.clearPrimaryKey();
        }
        toInsert.save();
        Collection<Entity> insertedEntities = this.insertEntities(Collections.singletonList(toInsert));
        if (insertedEntities.isEmpty()) {
            throw new RuntimeException("Insert did not return an entity, usually caused by a misconfigured key generator");
        }
        Entity inserted = insertedEntities.iterator().next();
        this.setEntity(inserted);
        this.notifyAfterInsert(Collections.unmodifiableCollection(insertedEntities));
        return inserted;
    }

    @Override
    public final Collection<Entity> insert(Collection<? extends Entity> entities) throws DatabaseException, ValidationException {
        if (((Boolean)this.readOnly.get()).booleanValue() || !((Boolean)this.insertEnabled.get()).booleanValue()) {
            throw new IllegalStateException("Edit model is readOnly or inserting is not enabled!");
        }
        Objects.requireNonNull(entities, ENTITIES);
        if (entities.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<Entity> insertedEntities = this.insertEntities(entities);
        this.notifyAfterInsert(Collections.unmodifiableCollection(insertedEntities));
        return insertedEntities;
    }

    @Override
    public final Entity update() throws DatabaseException, ValidationException {
        Collection<Entity> updated = this.update(Collections.singletonList(this.entity.copy()));
        if (updated.isEmpty()) {
            throw new UpdateException("Active entity is not modified");
        }
        return updated.iterator().next();
    }

    @Override
    public final Collection<Entity> update(Collection<? extends Entity> entities) throws DatabaseException, ValidationException {
        Objects.requireNonNull(entities, ENTITIES);
        if (((Boolean)this.readOnly.get()).booleanValue() || !((Boolean)this.updateEnabled.get()).booleanValue()) {
            throw new IllegalStateException("Edit model is readOnly or updating is not enabled!");
        }
        if (entities.size() > 1 && !((Boolean)this.updateMultipleEnabled.get()).booleanValue()) {
            throw new IllegalStateException("Batch update of entities is not enabled");
        }
        if (entities.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<Entity> modifiedEntities = this.modified(entities);
        if (modifiedEntities.isEmpty()) {
            return Collections.emptyList();
        }
        this.notifyBeforeUpdate(AbstractEntityEditModel.mapToOriginalPrimaryKey(modifiedEntities, entities));
        this.validate(modifiedEntities);
        LOG.debug("{} - update {}", (Object)this, entities);
        ArrayList<Entity> updatedEntities = new ArrayList<Entity>(this.update(new ArrayList<Entity>(modifiedEntities), this.connectionProvider.connection()));
        int index = updatedEntities.indexOf(this.entity);
        if (index >= 0) {
            this.setEntity((Entity)updatedEntities.get(index));
        }
        this.notifyAfterUpdate(AbstractEntityEditModel.mapToOriginalPrimaryKey(modifiedEntities, updatedEntities));
        return updatedEntities;
    }

    @Override
    public final void delete() throws DatabaseException {
        Entity originalEntity = this.entity.copy();
        originalEntity.revert();
        this.delete(Collections.singletonList(originalEntity));
    }

    @Override
    public final void delete(Collection<? extends Entity> entities) throws DatabaseException {
        Objects.requireNonNull(entities, ENTITIES);
        if (((Boolean)this.readOnly.get()).booleanValue() || !((Boolean)this.deleteEnabled.get()).booleanValue()) {
            throw new IllegalStateException("Edit model is readOnly or deleting is not enabled!");
        }
        if (entities.isEmpty()) {
            return;
        }
        LOG.debug("{} - delete {}", (Object)this, entities);
        this.notifyBeforeDelete(Collections.unmodifiableCollection(entities));
        this.delete(entities, this.connectionProvider.connection());
        if (entities.contains(this.entity)) {
            this.setDefaults();
        }
        this.notifyAfterDelete(Collections.unmodifiableCollection(entities));
    }

    @Override
    public final void refreshEntity() {
        try {
            if (((Boolean)this.entityExists.get()).booleanValue()) {
                this.set(this.connectionProvider().connection().select(this.entity.primaryKey()));
            }
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean containsSearchModel(ForeignKey foreignKey) {
        this.entityDefinition().foreignKeys().definition(foreignKey);
        Map<ForeignKey, EntitySearchModel> map = this.entitySearchModels;
        synchronized (map) {
            return this.entitySearchModels.containsKey(foreignKey);
        }
    }

    @Override
    public EntitySearchModel createForeignKeySearchModel(ForeignKey foreignKey) {
        this.entityDefinition().foreignKeys().definition(foreignKey);
        Collection searchColumns = this.entities().definition(foreignKey.referencedType()).columns().searchColumns();
        if (searchColumns.isEmpty()) {
            throw new IllegalStateException("No search columns defined for entity: " + foreignKey.referencedType());
        }
        return EntitySearchModel.builder(foreignKey.referencedType(), this.connectionProvider).columns(searchColumns).singleSelection(true).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final EntitySearchModel foreignKeySearchModel(ForeignKey foreignKey) {
        this.entityDefinition().foreignKeys().definition(foreignKey);
        Map<ForeignKey, EntitySearchModel> map = this.entitySearchModels;
        synchronized (map) {
            EntitySearchModel entitySearchModel = this.entitySearchModels.get(foreignKey);
            if (entitySearchModel == null) {
                entitySearchModel = this.createForeignKeySearchModel(foreignKey);
                this.entitySearchModels.put(foreignKey, entitySearchModel);
            }
            return entitySearchModel;
        }
    }

    @Override
    public final <T> Value<T> value(Attribute<T> attribute) {
        this.entityDefinition().attributes().definition(attribute);
        return this.editModelValues.computeIfAbsent(attribute, k -> new EditModelValue(this, attribute));
    }

    @Override
    public final <T> void removeEditListener(Attribute<T> attribute, Consumer<T> listener) {
        this.entityDefinition().attributes().definition(attribute);
        if (this.valueEditEvents.containsKey(attribute)) {
            this.valueEditEvents.get(attribute).removeDataListener(listener);
        }
    }

    @Override
    public final <T> void addEditListener(Attribute<T> attribute, Consumer<T> listener) {
        this.entityDefinition().attributes().definition(attribute);
        this.valueEditEvents.computeIfAbsent(attribute, k -> Event.event()).addDataListener(listener);
    }

    @Override
    public final <T> void removeValueListener(Attribute<T> attribute, Consumer<T> listener) {
        this.entityDefinition().attributes().definition(attribute);
        if (this.valueChangeEvents.containsKey(attribute)) {
            this.valueChangeEvents.get(attribute).removeDataListener(listener);
        }
    }

    @Override
    public final <T> void addValueListener(Attribute<T> attribute, Consumer<T> listener) {
        this.entityDefinition().attributes().definition(attribute);
        this.valueChangeEvents.computeIfAbsent(attribute, k -> Event.event()).addDataListener(listener);
    }

    @Override
    public final void removeValueChangeListener(Consumer<Attribute<?>> listener) {
        this.valueChangeEvent.removeDataListener(listener);
    }

    @Override
    public final void addValueChangeListener(Consumer<Attribute<?>> listener) {
        this.valueChangeEvent.addDataListener(listener);
    }

    @Override
    public final void removeEntityListener(Consumer<Entity> listener) {
        this.entityEvent.removeDataListener(listener);
    }

    @Override
    public final void addEntityListener(Consumer<Entity> listener) {
        this.entityEvent.addDataListener(listener);
    }

    @Override
    public final void removeBeforeInsertListener(Consumer<Collection<Entity>> listener) {
        this.beforeInsertEvent.removeDataListener(listener);
    }

    @Override
    public final void addBeforeInsertListener(Consumer<Collection<Entity>> listener) {
        this.beforeInsertEvent.addDataListener(listener);
    }

    @Override
    public final void removeAfterInsertListener(Consumer<Collection<Entity>> listener) {
        this.afterInsertEvent.removeDataListener(listener);
    }

    @Override
    public final void addAfterInsertListener(Consumer<Collection<Entity>> listener) {
        this.afterInsertEvent.addDataListener(listener);
    }

    @Override
    public final void removeBeforeUpdateListener(Consumer<Map<Entity.Key, Entity>> listener) {
        this.beforeUpdateEvent.removeDataListener(listener);
    }

    @Override
    public final void addBeforeUpdateListener(Consumer<Map<Entity.Key, Entity>> listener) {
        this.beforeUpdateEvent.addDataListener(listener);
    }

    @Override
    public final void removeAfterUpdateListener(Consumer<Map<Entity.Key, Entity>> listener) {
        this.afterUpdateEvent.removeDataListener(listener);
    }

    @Override
    public final void addAfterUpdateListener(Consumer<Map<Entity.Key, Entity>> listener) {
        this.afterUpdateEvent.addDataListener(listener);
    }

    @Override
    public final void addBeforeDeleteListener(Consumer<Collection<Entity>> listener) {
        this.beforeDeleteEvent.addDataListener(listener);
    }

    @Override
    public final void removeBeforeDeleteListener(Consumer<Collection<Entity>> listener) {
        this.beforeDeleteEvent.removeDataListener(listener);
    }

    @Override
    public final void removeAfterDeleteListener(Consumer<Collection<Entity>> listener) {
        this.afterDeleteEvent.removeDataListener(listener);
    }

    @Override
    public final void addAfterDeleteListener(Consumer<Collection<Entity>> listener) {
        this.afterDeleteEvent.addDataListener(listener);
    }

    @Override
    public final void removeInsertUpdateOrDeleteListener(Runnable listener) {
        this.insertUpdateOrDeleteEvent.removeListener(listener);
    }

    @Override
    public final void addInsertUpdateOrDeleteListener(Runnable listener) {
        this.insertUpdateOrDeleteEvent.addListener(listener);
    }

    @Override
    public final void addConfirmOverwriteListener(Consumer<State> listener) {
        this.confirmOverwriteEvent.addDataListener(listener);
    }

    @Override
    public final void removeConfirmOverwriteListener(Consumer<State> listener) {
        this.confirmOverwriteEvent.removeDataListener(listener);
    }

    protected Collection<Entity> insert(Collection<? extends Entity> entities, EntityConnection connection) throws DatabaseException {
        return Objects.requireNonNull(connection).insertSelect(entities);
    }

    protected Collection<Entity> update(Collection<? extends Entity> entities, EntityConnection connection) throws DatabaseException {
        return Objects.requireNonNull(connection).updateSelect(entities);
    }

    protected void delete(Collection<? extends Entity> entities, EntityConnection connection) throws DatabaseException {
        Objects.requireNonNull(connection).delete(Entity.primaryKeys(entities));
    }

    protected Collection<Entity> modified(Collection<? extends Entity> entities) {
        return Objects.requireNonNull(entities).stream().filter(Entity::modified).collect(Collectors.toList());
    }

    protected void replaceForeignKey(ForeignKey foreignKey, Collection<Entity> values) {
        Entity currentForeignKeyValue = this.referencedEntity(foreignKey);
        if (currentForeignKeyValue != null) {
            for (Entity replacementValue : values) {
                if (!currentForeignKeyValue.equals(replacementValue)) continue;
                this.put((Attribute)foreignKey, null);
                this.put((Attribute)foreignKey, (Object)replacementValue);
            }
        }
    }

    protected final Value<Predicate<Entity>> modifiedPredicate() {
        return this.modifiedPredicate;
    }

    protected final Value<Predicate<Entity>> existsPredicate() {
        return this.existsPredicate;
    }

    protected final State modifiedState() {
        return this.entityModified;
    }

    protected final void notifyBeforeInsert(Collection<Entity> entitiesToInsert) {
        this.beforeInsertEvent.accept(entitiesToInsert);
    }

    protected final void notifyAfterInsert(Collection<Entity> insertedEntities) {
        this.afterInsertEvent.accept(insertedEntities);
        if (((Boolean)this.editEvents.get()).booleanValue()) {
            EntityEditEvents.notifyInserted(insertedEntities);
        }
    }

    protected final void notifyBeforeUpdate(Map<Entity.Key, Entity> entitiesToUpdate) {
        this.beforeUpdateEvent.accept(entitiesToUpdate);
    }

    protected final void notifyAfterUpdate(Map<Entity.Key, Entity> updatedEntities) {
        this.afterUpdateEvent.accept(updatedEntities);
        if (((Boolean)this.editEvents.get()).booleanValue()) {
            EntityEditEvents.notifyUpdated(updatedEntities);
        }
    }

    protected final void notifyBeforeDelete(Collection<Entity> entitiesToDelete) {
        this.beforeDeleteEvent.accept(entitiesToDelete);
    }

    protected final void notifyAfterDelete(Collection<Entity> deletedEntities) {
        this.afterDeleteEvent.accept(deletedEntities);
        if (((Boolean)this.editEvents.get()).booleanValue()) {
            EntityEditEvents.notifyDeleted(deletedEntities);
        }
    }

    private Collection<Entity> insertEntities(Collection<? extends Entity> entities) throws DatabaseException, ValidationException {
        this.notifyBeforeInsert(Collections.unmodifiableCollection(entities));
        this.validate(entities);
        LOG.debug("{} - insert {}", (Object)this, entities);
        return this.insert(entities, this.connectionProvider.connection());
    }

    private boolean setEntityAllowed() {
        if (((Boolean)this.overwriteWarning.get()).booleanValue() && ((Boolean)this.exists().get()).booleanValue() && ((Boolean)this.modified().get()).booleanValue()) {
            State confirmation = State.state((boolean)true);
            this.confirmOverwriteEvent.accept((Object)confirmation);
            return (Boolean)confirmation.get();
        }
        return true;
    }

    private void setEntity(Entity entity) {
        Map affectedAttributes = this.entity.set(entity == null ? this.defaultEntity(this::defaultValue) : entity);
        Iterator iterator = affectedAttributes.keySet().iterator();
        while (iterator.hasNext()) {
            Attribute affectedAttribute;
            Attribute objectAttribute = affectedAttribute = (Attribute)iterator.next();
            this.notifyValueChange(objectAttribute, this.entity.get(objectAttribute));
        }
        if (affectedAttributes.isEmpty()) {
            this.updateEntityStates();
        }
        this.updateAttributeModifiedStates();
        this.entityEvent.accept((Object)entity);
    }

    private StateObserver nullObserver(Attribute<?> attribute) {
        this.entityDefinition().attributes().definition(attribute);
        return this.attributeNullMap.computeIfAbsent(attribute, k -> State.state((boolean)this.entity.isNull(attribute))).observer();
    }

    private StateObserver validObserver(Attribute<?> attribute) {
        this.entityDefinition().attributes().definition(attribute);
        return this.attributeValidMap.computeIfAbsent(attribute, k -> State.state((boolean)this.isValid(attribute))).observer();
    }

    private boolean isValid(Attribute<?> attribute) {
        try {
            this.validate(attribute);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    private void configurePersistentForeignKeys() {
        if (((Boolean)EntityEditModel.PERSIST_FOREIGN_KEYS.get()).booleanValue()) {
            this.entityDefinition().foreignKeys().get().forEach(foreignKey -> this.persist((Attribute<?>)foreignKey).set((Object)this.foreignKeyWritable((ForeignKey)foreignKey)));
        }
    }

    private boolean foreignKeyWritable(ForeignKey foreignKey) {
        return foreignKey.references().stream().map(ForeignKey.Reference::column).map(arg_0 -> ((EntityDefinition.Columns)this.entityDefinition().columns()).definition(arg_0)).filter(ColumnDefinition.class::isInstance).map(ColumnDefinition.class::cast).anyMatch(columnDefinition -> !columnDefinition.readOnly());
    }

    private Entity defaultEntity(ValueSupplier valueSupplier) {
        EntityDefinition definition = this.entityDefinition();
        Entity newEntity = definition.entity();
        AbstractEntityEditModel.addColumnValues(valueSupplier, definition, newEntity);
        AbstractEntityEditModel.addTransientValues(valueSupplier, definition, newEntity);
        AbstractEntityEditModel.addForeignKeyValues(valueSupplier, definition, newEntity);
        newEntity.save();
        return newEntity;
    }

    private <T> T defaultValue(AttributeDefinition<T> attributeDefinition) {
        if (((Boolean)this.persist(attributeDefinition.attribute()).get()).booleanValue()) {
            if (attributeDefinition instanceof ForeignKeyDefinition) {
                return (T)this.entity.referencedEntity((ForeignKey)attributeDefinition.attribute());
            }
            return (T)this.entity.get(attributeDefinition.attribute());
        }
        return this.defaultValueSuppliers.computeIfAbsent(attributeDefinition.attribute(), k -> () -> ((AttributeDefinition)attributeDefinition).defaultValue()).get();
    }

    private void bindEventsInternal() {
        this.afterDeleteEvent.addListener(this.insertUpdateOrDeleteEvent);
        this.afterInsertEvent.addListener(this.insertUpdateOrDeleteEvent);
        this.afterUpdateEvent.addListener(this.insertUpdateOrDeleteEvent);
    }

    private Map<Attribute<?>, Object> dependingValues(Attribute<?> attribute) {
        return this.dependingValues(attribute, new LinkedHashMap());
    }

    private Map<Attribute<?>, Object> dependingValues(Attribute<?> attribute, Map<Attribute<?>, Object> dependingValues) {
        this.addDependingDerivedAttributes(attribute, dependingValues);
        if (attribute instanceof Column) {
            this.addDependingForeignKeys((Column)attribute, dependingValues);
        } else if (attribute instanceof ForeignKey) {
            this.addDependingReferencedColumns((ForeignKey)attribute, dependingValues);
        }
        return dependingValues;
    }

    private void addDependingDerivedAttributes(Attribute<?> attribute, Map<Attribute<?>, Object> dependingValues) {
        this.entityDefinition().attributes().derivedFrom(attribute).forEach(derivedAttribute -> {
            dependingValues.put((Attribute<?>)derivedAttribute, this.get((Attribute)derivedAttribute));
            this.addDependingDerivedAttributes((Attribute<?>)derivedAttribute, dependingValues);
        });
    }

    private void addDependingForeignKeys(Column<?> column, Map<Attribute<?>, Object> dependingValues) {
        this.entityDefinition().foreignKeys().definitions(column).forEach(foreignKeyDefinition -> dependingValues.put((Attribute<?>)foreignKeyDefinition.attribute(), this.get((Attribute)foreignKeyDefinition.attribute())));
    }

    private void addDependingReferencedColumns(ForeignKey foreignKey, Map<Attribute<?>, Object> dependingValues) {
        foreignKey.references().forEach(reference -> dependingValues.put((Attribute<?>)reference.column(), this.get((Attribute)reference.column())));
    }

    private <T> void notifyValueEdit(Attribute<T> attribute, T value, Map<Attribute<?>, Object> dependingValues) {
        this.notifyValueChange(attribute, value);
        Event<?> editEvent = this.valueEditEvents.get(attribute);
        if (editEvent != null) {
            editEvent.accept(value);
        }
        dependingValues.forEach((dependingAttribute, previousValue) -> {
            Object currentValue = this.get((Attribute)dependingAttribute);
            if (!Objects.equals(previousValue, currentValue)) {
                this.notifyValueEdit((Attribute)dependingAttribute, currentValue, Collections.emptyMap());
            }
        });
    }

    private <T> void notifyValueChange(Attribute<T> attribute, T value) {
        this.updateEntityStates();
        this.updateAttributeStates(attribute);
        Event<?> changeEvent = this.valueChangeEvents.get(attribute);
        if (changeEvent != null) {
            changeEvent.accept(value);
        }
        this.valueChangeEvent.accept(attribute);
    }

    private void updateEntityStates() {
        this.entityExists.set((Object)((Predicate)this.existsPredicate.get()).test(this.entity));
        this.entityModified.set((Object)((Predicate)this.modifiedPredicate.get()).test(this.entity));
        this.entityValid.set((Object)this.validator.valid(this.entity));
        this.primaryKeyNull.set((Object)this.entity.primaryKey().isNull());
    }

    private <T> void updateAttributeStates(Attribute<T> attribute) {
        State modifiedState;
        State validState;
        State nullState = this.attributeNullMap.get(attribute);
        if (nullState != null) {
            nullState.set((Object)this.entity.isNull(attribute));
        }
        if ((validState = this.attributeValidMap.get(attribute)) != null) {
            validState.set((Object)this.isValid(attribute));
        }
        if ((modifiedState = this.attributeModifiedMap.get(attribute)) != null) {
            this.updateAttributeModifiedState(attribute, modifiedState);
        }
    }

    private void updateAttributeModifiedStates() {
        this.attributeModifiedMap.forEach(this::updateAttributeModifiedState);
    }

    private void updateAttributeModifiedState(Attribute<?> attribute, State modifiedState) {
        modifiedState.set((Object)(((Predicate)this.existsPredicate.get()).test(this.entity) && this.entity.modified(attribute) ? 1 : 0));
    }

    private static void addColumnValues(ValueSupplier valueSupplier, EntityDefinition definition, Entity newEntity) {
        definition.columns().definitions().stream().filter(columnDefinition -> !definition.foreignKeys().foreignKeyColumn(columnDefinition.attribute())).filter(columnDefinition -> !columnDefinition.columnHasDefaultValue() || columnDefinition.hasDefaultValue()).map(columnDefinition -> columnDefinition).forEach(attributeDefinition -> newEntity.put(attributeDefinition.attribute(), valueSupplier.get(attributeDefinition)));
    }

    private static void addTransientValues(ValueSupplier valueSupplier, EntityDefinition definition, Entity newEntity) {
        definition.attributes().definitions().stream().filter(TransientAttributeDefinition.class::isInstance).filter(attributeDefinition -> !attributeDefinition.derived()).map(attributeDefinition -> attributeDefinition).forEach(attributeDefinition -> newEntity.put(attributeDefinition.attribute(), valueSupplier.get(attributeDefinition)));
    }

    private static void addForeignKeyValues(ValueSupplier valueSupplier, EntityDefinition definition, Entity newEntity) {
        definition.foreignKeys().definitions().forEach(foreignKeyDefinition -> newEntity.put((Attribute)foreignKeyDefinition.attribute(), (Object)((Entity)valueSupplier.get(foreignKeyDefinition))));
    }

    private static Map<Entity.Key, Entity> mapToOriginalPrimaryKey(Collection<Entity> entitiesBeforeUpdate, Collection<? extends Entity> entitiesAfterUpdate) {
        ArrayList<? extends Entity> entitiesAfterUpdateCopy = new ArrayList<Entity>(entitiesAfterUpdate);
        HashMap<Entity.Key, Entity> keyMap = new HashMap<Entity.Key, Entity>(entitiesBeforeUpdate.size());
        for (Entity entity : entitiesBeforeUpdate) {
            keyMap.put(entity.originalPrimaryKey(), AbstractEntityEditModel.findAndRemove(entity.primaryKey(), entitiesAfterUpdateCopy.listIterator()));
        }
        return Collections.unmodifiableMap(keyMap);
    }

    private static Entity findAndRemove(Entity.Key primaryKey, ListIterator<Entity> iterator) {
        while (iterator.hasNext()) {
            Entity current = iterator.next();
            if (!current.primaryKey().equals(primaryKey)) continue;
            iterator.remove();
            return current;
        }
        return null;
    }

    private static interface ValueSupplier {
        public <T> T get(AttributeDefinition<T> var1);
    }

    private static final class EditModelValue<T>
    extends AbstractValue<T> {
        private final EntityEditModel editModel;
        private final Attribute<T> attribute;

        private EditModelValue(EntityEditModel editModel, Attribute<T> attribute) {
            this.editModel = editModel;
            this.attribute = attribute;
            this.editModel.addValueListener(attribute, valueChange -> this.notifyListeners());
        }

        public T get() {
            return this.editModel.get(this.attribute);
        }

        protected void setValue(T value) {
            this.editModel.put(this.attribute, value);
        }
    }
}

