/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model.test;

import is.codion.common.Operator;
import is.codion.common.db.exception.DatabaseException;
import is.codion.common.model.table.ColumnConditionModel;
import is.codion.common.user.User;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.db.local.LocalEntityConnectionProvider;
import is.codion.framework.domain.Domain;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.model.EntityEditModel;
import is.codion.framework.model.EntityTableModel;
import is.codion.framework.model.test.TestDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractEntityTableModelTest<EditModel extends EntityEditModel, TableModel extends EntityTableModel<EditModel>> {
    private static final User UNIT_TEST_USER = User.parse((String)System.getProperty("codion.test.user", "scott:tiger"));
    private static final EntityConnectionProvider CONNECTION_PROVIDER = ((LocalEntityConnectionProvider.Builder)LocalEntityConnectionProvider.builder().user(UNIT_TEST_USER)).domain((Domain)new TestDomain()).build();
    private final EntityConnectionProvider connectionProvider;
    protected final List<Entity> testEntities = AbstractEntityTableModelTest.initTestEntities(CONNECTION_PROVIDER.entities());
    protected final TableModel testModel;

    protected AbstractEntityTableModelTest() {
        this.connectionProvider = CONNECTION_PROVIDER;
        this.testModel = this.createTestTableModel();
    }

    @Test
    public void select() {
        TableModel tableModel = this.createTableModel(TestDomain.Employee.TYPE, this.connectionProvider);
        tableModel.refresh();
        List keys = tableModel.entities().primaryKeys(TestDomain.Employee.TYPE, (Object[])new Integer[]{1, 2});
        Entity.Key pk1 = (Entity.Key)keys.get(0);
        Entity.Key pk2 = (Entity.Key)keys.get(1);
        tableModel.select(Collections.singletonList(pk1));
        Entity selectedPK1 = (Entity)tableModel.selectionModel().getSelectedItem();
        Assertions.assertEquals((Object)pk1, (Object)selectedPK1.primaryKey());
        Assertions.assertEquals((int)1, (int)tableModel.selectionModel().selectionCount());
        tableModel.select(Collections.singletonList(pk2));
        Entity selectedPK2 = (Entity)tableModel.selectionModel().getSelectedItem();
        Assertions.assertEquals((Object)pk2, (Object)selectedPK2.primaryKey());
        Assertions.assertEquals((int)1, (int)tableModel.selectionModel().selectionCount());
        tableModel.select((Collection)keys);
        List selectedItems = tableModel.selectionModel().getSelectedItems();
        for (Entity selected : selectedItems) {
            Assertions.assertTrue((boolean)keys.contains(selected.primaryKey()));
        }
        Assertions.assertEquals((int)2, (int)tableModel.selectionModel().selectionCount());
    }

    @Test
    public void selectedEntitiesIterator() {
        TableModel tableModel = this.createTableModel(TestDomain.Employee.TYPE, this.connectionProvider);
        tableModel.refresh();
        tableModel.selectionModel().setSelectedIndexes(Arrays.asList(0, 3, 5));
        Iterator iterator = tableModel.selectionModel().getSelectedItems().iterator();
        Assertions.assertEquals(tableModel.visibleItems().get(0), iterator.next());
        Assertions.assertEquals(tableModel.visibleItems().get(3), iterator.next());
        Assertions.assertEquals(tableModel.visibleItems().get(5), iterator.next());
    }

    @Test
    public void onInsert() throws DatabaseException, ValidationException {
        TableModel deptModel = this.createDepartmentTableModel();
        deptModel.refresh();
        Entities entities = deptModel.entities();
        deptModel.onInsert().set((Object)EntityTableModel.OnInsert.ADD_BOTTOM);
        Entity dept = entities.builder(TestDomain.Department.TYPE).with(TestDomain.Department.ID, (Object)-10).with(TestDomain.Department.LOCATION, (Object)"Nowhere1").with(TestDomain.Department.NAME, (Object)"HELLO").build();
        int count = deptModel.getRowCount();
        deptModel.editModel().insert(Collections.singletonList(dept));
        Assertions.assertEquals((int)(count + 1), (int)deptModel.getRowCount());
        Assertions.assertEquals((Object)dept, deptModel.visibleItems().get(deptModel.getRowCount() - 1));
        deptModel.onInsert().set((Object)EntityTableModel.OnInsert.ADD_TOP_SORTED);
        Entity dept2 = entities.builder(TestDomain.Department.TYPE).with(TestDomain.Department.ID, (Object)-20).with(TestDomain.Department.LOCATION, (Object)"Nowhere2").with(TestDomain.Department.NAME, (Object)"NONAME").build();
        deptModel.editModel().insert(Collections.singletonList(dept2));
        Assertions.assertEquals((int)(count + 2), (int)deptModel.getRowCount());
        Assertions.assertEquals((Object)dept2, deptModel.visibleItems().get(2));
        deptModel.onInsert().set((Object)EntityTableModel.OnInsert.DO_NOTHING);
        Entity dept3 = entities.builder(TestDomain.Department.TYPE).with(TestDomain.Department.ID, (Object)-30).with(TestDomain.Department.LOCATION, (Object)"Nowhere3").with(TestDomain.Department.NAME, (Object)"NONAME2").build();
        deptModel.editModel().insert(Collections.singletonList(dept3));
        Assertions.assertEquals((int)(count + 2), (int)deptModel.getRowCount());
        deptModel.refresh();
        Assertions.assertEquals((int)(count + 3), (int)deptModel.getRowCount());
        deptModel.editModel().delete(Arrays.asList(dept, dept2, dept3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeDeletedEntities() throws DatabaseException {
        TableModel tableModel = this.createTableModel(TestDomain.Employee.TYPE, this.connectionProvider);
        tableModel.refresh();
        Entities entities = tableModel.entities();
        Entity.Key pk1 = entities.primaryKey(TestDomain.Employee.TYPE, (Object)1);
        Entity.Key pk2 = entities.primaryKey(TestDomain.Employee.TYPE, (Object)2);
        tableModel.connectionProvider().connection().beginTransaction();
        try {
            tableModel.select(Collections.singletonList(pk1));
            tableModel.selectionModel().setSelectedIndex(0);
            Entity selected = (Entity)tableModel.selectionModel().getSelectedItem();
            tableModel.removeDeleted().set((Object)true);
            tableModel.deleteSelected();
            Assertions.assertFalse((boolean)tableModel.containsItem((Object)selected));
            tableModel.select(Collections.singletonList(pk2));
            selected = (Entity)tableModel.selectionModel().getSelectedItem();
            tableModel.removeDeleted().set((Object)false);
            tableModel.deleteSelected();
            Assertions.assertTrue((boolean)tableModel.containsItem((Object)selected));
        }
        finally {
            tableModel.connectionProvider().connection().rollbackTransaction();
        }
    }

    @Test
    public void findSingle() {
        TableModel tableModel = this.createTableModel(TestDomain.Employee.TYPE, this.connectionProvider);
        tableModel.refresh();
        Entities entities = tableModel.entities();
        Entity.Key pk1 = entities.primaryKey(TestDomain.Employee.TYPE, (Object)1);
        Assertions.assertTrue((boolean)tableModel.find(pk1).isPresent());
        Entity.Key pk2 = entities.primaryKey(TestDomain.Employee.TYPE, (Object)-66);
        Assertions.assertFalse((boolean)tableModel.find(pk2).isPresent());
    }

    @Test
    public void entityType() {
        Assertions.assertEquals((Object)TestDomain.Detail.TYPE, (Object)this.testModel.entityType());
    }

    @Test
    public void deleteNotEnabled() {
        this.testModel.editModel().deleteEnabled().set((Object)false);
        this.testModel.refresh();
        this.testModel.selectionModel().setSelectedIndexes(Collections.singletonList(0));
        Assertions.assertThrows(IllegalStateException.class, () -> this.testModel.deleteSelected());
    }

    @Test
    public void testTheRest() {
        Assertions.assertNotNull((Object)this.testModel.connectionProvider());
        Assertions.assertNotNull((Object)this.testModel.editModel());
        Assertions.assertFalse((boolean)((Boolean)this.testModel.editModel().readOnly().get()));
        this.testModel.refresh();
    }

    @Test
    public void findMultiple() {
        this.testModel.refresh();
        Entities entities = this.testModel.entities();
        Entity tmpEnt = entities.builder(TestDomain.Detail.TYPE).with(TestDomain.Detail.ID, (Object)3L).build();
        Assertions.assertEquals((Object)"c", (Object)((Entity)this.testModel.find(tmpEnt.primaryKey()).orElseThrow(RuntimeException::new)).get(TestDomain.Detail.STRING));
        ArrayList<Entity.Key> keys = new ArrayList<Entity.Key>();
        keys.add(tmpEnt.primaryKey());
        tmpEnt = entities.builder(TestDomain.Detail.TYPE).with(TestDomain.Detail.ID, (Object)2L).build();
        keys.add(tmpEnt.primaryKey());
        tmpEnt = entities.builder(TestDomain.Detail.TYPE).with(TestDomain.Detail.ID, (Object)1L).build();
        keys.add(tmpEnt.primaryKey());
        Collection entitiesByKey = this.testModel.find(keys);
        Assertions.assertEquals((int)3, (int)entitiesByKey.size());
    }

    @Test
    public void limit() {
        TableModel tableModel = this.createTableModel(TestDomain.Employee.TYPE, this.connectionProvider);
        tableModel.limit().set((Object)6);
        tableModel.refresh();
        Assertions.assertEquals((int)6, (int)tableModel.getRowCount());
        ColumnConditionModel commissionConditionModel = tableModel.conditionModel().attributeModel(TestDomain.Employee.COMMISSION);
        commissionConditionModel.operator().set((Object)Operator.EQUAL);
        commissionConditionModel.enabled().set((Object)true);
        tableModel.refresh();
        commissionConditionModel.enabled().set((Object)false);
        tableModel.refresh();
        Assertions.assertEquals((int)6, (int)tableModel.getRowCount());
        tableModel.limit().set((Object)-1);
        tableModel.refresh();
        Assertions.assertEquals((int)16, (int)tableModel.getRowCount());
    }

    @Test
    public void setColumns() {
        TableModel empModel = this.createTableModel(TestDomain.Employee.TYPE, this.connectionProvider);
        empModel.setVisibleColumns(new Attribute[]{TestDomain.Employee.COMMISSION, TestDomain.Employee.DEPARTMENT_FK, TestDomain.Employee.HIREDATE});
    }

    @Test
    public void conditionChangedListener() {
        TableModel empModel = this.createTableModel(TestDomain.Employee.TYPE, this.connectionProvider);
        AtomicInteger counter = new AtomicInteger();
        Runnable conditionChangedListener = counter::incrementAndGet;
        empModel.conditionChanged().addListener(conditionChangedListener);
        ColumnConditionModel commissionModel = empModel.conditionModel().attributeModel(TestDomain.Employee.COMMISSION);
        commissionModel.enabled().set((Object)true);
        Assertions.assertEquals((int)1, (int)counter.get());
        commissionModel.enabled().set((Object)false);
        Assertions.assertEquals((int)2, (int)counter.get());
        commissionModel.operator().set((Object)Operator.GREATER_THAN_OR_EQUAL);
        commissionModel.setLowerBound((Object)1200.0);
        Assertions.assertEquals((int)3, (int)counter.get());
        empModel.conditionChanged().removeListener(conditionChangedListener);
    }

    @Test
    public void testSearchState() {
        TableModel empModel = this.createTableModel(TestDomain.Employee.TYPE, this.connectionProvider);
        Assertions.assertFalse((boolean)((Boolean)empModel.conditionChanged().get()));
        ColumnConditionModel jobModel = empModel.conditionModel().attributeModel(TestDomain.Employee.JOB);
        jobModel.setEqualValue((Object)"job");
        Assertions.assertTrue((boolean)((Boolean)empModel.conditionChanged().get()));
        jobModel.enabled().set((Object)false);
        Assertions.assertFalse((boolean)((Boolean)empModel.conditionChanged().get()));
        jobModel.enabled().set((Object)true);
        Assertions.assertTrue((boolean)((Boolean)empModel.conditionChanged().get()));
        empModel.refresh();
        Assertions.assertFalse((boolean)((Boolean)empModel.conditionChanged().get()));
    }

    protected final EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    protected abstract TableModel createTestTableModel();

    protected abstract TableModel createDepartmentTableModel();

    protected abstract TableModel createTableModel(EntityType var1, EntityConnectionProvider var2);

    protected abstract TableModel createTableModel(EditModel var1);

    protected abstract EditModel createEditModel(EntityType var1, EntityConnectionProvider var2);

    private static List<Entity> initTestEntities(Entities entities) {
        ArrayList<Entity> testEntities = new ArrayList<Entity>(5);
        String[] stringValues = new String[]{"a", "b", "c", "d", "e"};
        for (int i = 0; i < 5; ++i) {
            testEntities.add(entities.builder(TestDomain.Detail.TYPE).with(TestDomain.Detail.ID, (Object)((long)i + 1L)).with(TestDomain.Detail.INT, (Object)(i + 1)).with(TestDomain.Detail.STRING, (Object)stringValues[i]).build());
        }
        return testEntities;
    }
}

