/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.model.test;

import is.codion.common.db.exception.DatabaseException;
import is.codion.common.user.User;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.EntityConnectionProvider;
import is.codion.framework.db.local.LocalEntityConnectionProvider;
import is.codion.framework.domain.Domain;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.domain.entity.exception.ValidationException;
import is.codion.framework.model.AbstractEntityEditModel;
import is.codion.framework.model.DefaultEntityModel;
import is.codion.framework.model.EntityTableModel;
import is.codion.framework.model.ForeignKeyDetailModelLink;
import is.codion.framework.model.test.TestDomain;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractEntityModelTest<Model extends DefaultEntityModel<Model, EditModel, TableModel>, EditModel extends AbstractEntityEditModel, TableModel extends EntityTableModel<EditModel>> {
    private static final User UNIT_TEST_USER = User.parse((String)System.getProperty("codion.test.user", "scott:tiger"));
    protected static final EntityConnectionProvider CONNECTION_PROVIDER = ((LocalEntityConnectionProvider.Builder)LocalEntityConnectionProvider.builder().user(UNIT_TEST_USER)).domain((Domain)new TestDomain()).build();
    private final EntityConnectionProvider connectionProvider = CONNECTION_PROVIDER;
    protected final Model departmentModel = this.createDepartmentModel();

    protected AbstractEntityModelTest() {
    }

    @Test
    public void testUpdatePrimaryKey() throws DatabaseException, ValidationException {
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        this.departmentModel.tableModel().refresh();
        AbstractEntityEditModel deptEditModel = this.departmentModel.editModel();
        EntityTableModel deptTableModel = this.departmentModel.tableModel();
        Entity.Key operationsKey = deptEditModel.entities().primaryKey(TestDomain.Department.TYPE, (Object)40);
        deptTableModel.select(Collections.singletonList(operationsKey));
        Assertions.assertTrue((boolean)((Boolean)deptTableModel.selectionModel().selectionNotEmpty().get()));
        deptEditModel.put(TestDomain.Department.ID, (Object)80);
        Assertions.assertFalse((boolean)((Boolean)deptTableModel.selectionModel().selectionEmpty().get()));
        deptEditModel.update();
        Assertions.assertFalse((boolean)((Boolean)deptTableModel.selectionModel().selectionEmpty().get()));
        Entity operations = (Entity)deptTableModel.selectionModel().getSelectedItem();
        Assertions.assertEquals((int)80, (Integer)((Integer)operations.get(TestDomain.Department.ID)));
        deptTableModel.includeCondition().set(item -> !Objects.equals(80, item.get(TestDomain.Department.ID)));
        deptEditModel.set(operations);
        deptEditModel.put(TestDomain.Department.ID, (Object)40);
        deptEditModel.update();
        deptTableModel.filterItems();
        Assertions.assertTrue((boolean)deptTableModel.filteredItems().isEmpty());
    }

    @Test
    public void testDetailModels() throws DatabaseException, ValidationException {
    }

    @Test
    public void detailModelNotFound() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.departmentModel.detailModel(TestDomain.Department.TYPE));
    }

    @Test
    public void clear() {
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        this.departmentModel.tableModel().refresh();
        Assertions.assertTrue((this.departmentModel.tableModel().getRowCount() > 0 ? 1 : 0) != 0);
        DefaultEntityModel employeeModel = this.departmentModel.detailModel(TestDomain.Employee.TYPE);
        employeeModel.tableModel().refresh();
        Assertions.assertTrue((employeeModel.tableModel().getRowCount() > 0 ? 1 : 0) != 0);
        this.departmentModel.detailModels().forEach(detailModel -> detailModel.tableModel().clear());
        Assertions.assertEquals((int)0, (int)employeeModel.tableModel().getRowCount());
        this.departmentModel.tableModel().clear();
        Assertions.assertEquals((int)0, (int)this.departmentModel.tableModel().getRowCount());
    }

    @Test
    public void constructorNullTableModel() {
        Assertions.assertThrows(NullPointerException.class, () -> new DefaultEntityModel((EntityTableModel)null));
    }

    @Test
    public void clearEditModelClearTableSelection() {
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        this.departmentModel.tableModel().refresh();
        this.departmentModel.tableModel().selectionModel().setSelectedIndexes(Arrays.asList(1, 2, 3));
        Assertions.assertTrue((boolean)((Boolean)this.departmentModel.tableModel().selectionModel().selectionNotEmpty().get()));
        Assertions.assertTrue((boolean)((Boolean)this.departmentModel.editModel().exists().get()));
        this.departmentModel.editModel().setDefaults();
        Assertions.assertTrue((boolean)((Boolean)this.departmentModel.tableModel().selectionModel().selectionEmpty().get()));
    }

    @Test
    public void test() throws Exception {
        Assertions.assertNotNull((Object)this.departmentModel.editModel());
    }

    @Test
    public void detailModel() throws Exception {
        this.departmentModel.detailModel(this.departmentModel.detailModel(TestDomain.Employee.TYPE).getClass());
        Assertions.assertTrue((boolean)this.departmentModel.containsDetailModel(TestDomain.Employee.TYPE));
        DefaultEntityModel detailModel = this.departmentModel.detailModel(TestDomain.Employee.TYPE);
        Assertions.assertTrue((boolean)this.departmentModel.containsDetailModel(detailModel));
        Assertions.assertTrue((boolean)this.departmentModel.containsDetailModel(this.departmentModel.detailModel(TestDomain.Employee.TYPE).getClass()));
        Assertions.assertEquals((int)1, (int)this.departmentModel.detailModels().size(), (String)"Only one detail model should be in DepartmentModel");
        Assertions.assertEquals((int)1, (int)this.departmentModel.activeDetailModels().size());
        this.departmentModel.detailModel(TestDomain.Employee.TYPE);
        Assertions.assertTrue((boolean)this.departmentModel.activeDetailModels().contains(this.departmentModel.detailModel(TestDomain.Employee.TYPE)));
        Assertions.assertNotNull((Object)this.departmentModel.detailModel(TestDomain.Employee.TYPE));
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        this.departmentModel.tableModel().refresh();
        this.departmentModel.detailModel(TestDomain.Employee.TYPE).tableModel().refresh();
        Assertions.assertTrue((this.departmentModel.detailModel(TestDomain.Employee.TYPE).tableModel().getRowCount() > 0 ? 1 : 0) != 0);
        EntityConnection connection = this.departmentModel.connectionProvider().connection();
        Entity department = connection.selectSingle((Condition)TestDomain.Department.NAME.equalTo((Object)"SALES"));
        this.departmentModel.tableModel().selectionModel().setSelectedItem((Object)department);
        List salesEmployees = connection.select(TestDomain.Employee.DEPARTMENT_FK.equalTo(department));
        Assertions.assertFalse((boolean)salesEmployees.isEmpty());
        this.departmentModel.tableModel().selectionModel().setSelectedItem((Object)department);
        Collection employeesFromDetailModel = this.departmentModel.detailModel(TestDomain.Employee.TYPE).tableModel().items();
        Assertions.assertTrue((boolean)salesEmployees.containsAll(employeesFromDetailModel), (String)"Filtered list should contain all employees for department");
    }

    @Test
    public void addSameDetailModelTwice() {
        Object model = this.createDepartmentModelWithoutDetailModel();
        Object employeeModel = this.createEmployeeModel();
        Assertions.assertThrows(IllegalArgumentException.class, () -> model.addDetailModels(new DefaultEntityModel[]{employeeModel, employeeModel}));
    }

    @Test
    public void addModelAsItsOwnDetailModel() {
        Object model = this.createDepartmentModelWithoutDetailModel();
        Assertions.assertThrows(IllegalArgumentException.class, () -> model.addDetailModel(model));
    }

    @Test
    public void activateDeactivateDetailModel() {
        this.departmentModel.detailModelLink(this.departmentModel.detailModel(TestDomain.Employee.TYPE)).active().set((Object)false);
        Assertions.assertTrue((boolean)this.departmentModel.activeDetailModels().isEmpty());
        this.departmentModel.detailModelLink(this.departmentModel.detailModel(TestDomain.Employee.TYPE)).active().set((Object)true);
        Assertions.assertFalse((boolean)this.departmentModel.activeDetailModels().isEmpty());
        Assertions.assertTrue((boolean)this.departmentModel.activeDetailModels().contains(this.departmentModel.detailModel(TestDomain.Employee.TYPE)));
    }

    @Test
    public void searchByInsertedEntity() throws DatabaseException, ValidationException {
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        DefaultEntityModel employeeModel = this.departmentModel.detailModel(TestDomain.Employee.TYPE);
        ForeignKeyDetailModelLink link = (ForeignKeyDetailModelLink)this.departmentModel.detailModelLink(employeeModel);
        link.searchByInsertedEntity().set((Object)true);
        Assertions.assertTrue((boolean)((Boolean)link.searchByInsertedEntity().get()));
        AbstractEntityEditModel editModel = this.departmentModel.editModel();
        editModel.put(TestDomain.Department.ID, (Object)100);
        editModel.put(TestDomain.Department.NAME, (Object)"Name");
        editModel.put(TestDomain.Department.LOCATION, (Object)"Loc");
        Entity inserted = editModel.insert();
        Collection equalsValues = employeeModel.tableModel().conditionModel().attributeModel((Attribute)TestDomain.Employee.DEPARTMENT_FK).getEqualValues();
        Assertions.assertEquals((Object)inserted, equalsValues.iterator().next());
        editModel.delete();
    }

    @Test
    public void clearForeignKeyOnEmptySelection() throws DatabaseException {
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        DefaultEntityModel employeeModel = this.departmentModel.detailModel(TestDomain.Employee.TYPE);
        AbstractEntityEditModel employeeEditModel = employeeModel.editModel();
        ForeignKeyDetailModelLink link = (ForeignKeyDetailModelLink)this.departmentModel.detailModelLink(employeeModel);
        link.clearForeignKeyOnEmptySelection().set((Object)false);
        Entity dept = employeeModel.connectionProvider().connection().selectSingle((Condition)TestDomain.Department.ID.equalTo((Object)10));
        this.departmentModel.tableModel().refresh();
        this.departmentModel.tableModel().selectionModel().setSelectedItem((Object)dept);
        Assertions.assertEquals((Object)dept, (Object)employeeEditModel.get((Attribute)TestDomain.Employee.DEPARTMENT_FK));
        this.departmentModel.tableModel().selectionModel().clearSelection();
        Assertions.assertEquals((Object)dept, (Object)employeeEditModel.get((Attribute)TestDomain.Employee.DEPARTMENT_FK));
        link.clearForeignKeyOnEmptySelection().set((Object)true);
        this.departmentModel.tableModel().selectionModel().setSelectedItem((Object)dept);
        Assertions.assertEquals((Object)dept, (Object)employeeEditModel.get((Attribute)TestDomain.Employee.DEPARTMENT_FK));
        this.departmentModel.tableModel().selectionModel().clearSelection();
        Assertions.assertTrue((boolean)((Boolean)employeeEditModel.isNull((Attribute)TestDomain.Employee.DEPARTMENT_FK).get()));
        link.clearForeignKeyOnEmptySelection().set((Object)false);
        this.departmentModel.tableModel().selectionModel().setSelectedItem((Object)dept);
        Assertions.assertEquals((Object)dept, (Object)employeeEditModel.get((Attribute)TestDomain.Employee.DEPARTMENT_FK));
    }

    @Test
    public void refreshOnSelection() throws DatabaseException {
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        DefaultEntityModel employeeModel = this.departmentModel.detailModel(TestDomain.Employee.TYPE);
        EntityTableModel employeeTableModel = employeeModel.tableModel();
        ForeignKeyDetailModelLink link = (ForeignKeyDetailModelLink)this.departmentModel.detailModelLink(employeeModel);
        link.refreshOnSelection().set((Object)false);
        Entity dept = employeeModel.connectionProvider().connection().selectSingle((Condition)TestDomain.Department.ID.equalTo((Object)10));
        this.departmentModel.tableModel().refresh();
        this.departmentModel.tableModel().selectionModel().setSelectedItem((Object)dept);
        Assertions.assertEquals((int)0, (int)employeeTableModel.getRowCount());
        link.refreshOnSelection().set((Object)true);
        this.departmentModel.tableModel().selectionModel().setSelectedItem((Object)dept);
        Assertions.assertNotEquals((int)0, (int)employeeTableModel.getRowCount());
    }

    @Test
    public void insertDifferentTypes() throws DatabaseException, ValidationException {
        if (!this.departmentModel.containsTableModel()) {
            return;
        }
        Entity dept = this.departmentModel.connectionProvider().entities().builder(TestDomain.Department.TYPE).with(TestDomain.Department.ID, (Object)-42).with(TestDomain.Department.NAME, (Object)"Name").with(TestDomain.Department.LOCATION, (Object)"Loc").build();
        Entity emp = this.connectionProvider.connection().selectSingle((Condition)TestDomain.Employee.ID.equalTo((Object)8)).clearPrimaryKey();
        emp.put(TestDomain.Employee.NAME, (Object)"NewName");
        Model model = this.createDepartmentModelWithoutDetailModel();
        model.editModel().insert(Arrays.asList(dept, emp));
        Assertions.assertTrue((boolean)model.tableModel().containsItem((Object)dept));
        Assertions.assertFalse((boolean)model.tableModel().containsItem((Object)emp));
        model.editModel().delete(Arrays.asList(dept, emp));
        Assertions.assertFalse((boolean)model.tableModel().containsItem((Object)dept));
    }

    protected final EntityConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    protected abstract Model createDepartmentModel();

    protected abstract Model createDepartmentModelWithoutDetailModel();

    protected abstract Model createEmployeeModel();
}

