/*
 * This file is part of Codion.
 *
 * Codion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Codion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Codion.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Copyright (c) 2019 - 2024, Björn Darri Sigurðsson.
 */
package is.codion.framework.json.domain;

import is.codion.framework.domain.entity.condition.ColumnCondition;

import com.fasterxml.jackson.core.JsonGenerator;

import java.io.IOException;
import java.io.Serial;
import java.io.Serializable;

import static java.util.Objects.requireNonNull;

final class ColumnConditionSerializer implements Serializable {

	@Serial
	private static final long serialVersionUID = 1;

	private final EntityObjectMapper entityObjectMapper;

	ColumnConditionSerializer(EntityObjectMapper entityObjectMapper) {
		this.entityObjectMapper = requireNonNull(entityObjectMapper);
	}

	void serialize(ColumnCondition<?> condition, JsonGenerator generator) throws IOException {
		generator.writeStartObject();
		generator.writeStringField("type", "column");
		generator.writeStringField("column", condition.column().name());
		generator.writeStringField("operator", condition.operator().name());
		generator.writeBooleanField("caseSensitive", condition.caseSensitive());
		generator.writeFieldName("values");
		generator.writeStartArray();
		for (Object value : condition.values()) {
			entityObjectMapper.writeValue(generator, value);
		}
		generator.writeEndArray();
		generator.writeEndObject();
	}
}
