/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.domain;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.json.domain.ConditionDeserializer;
import is.codion.framework.json.domain.ConditionSerializer;
import is.codion.framework.json.domain.EntityDeserializer;
import is.codion.framework.json.domain.EntityKeyDeserializer;
import is.codion.framework.json.domain.EntityKeySerializer;
import is.codion.framework.json.domain.EntitySerializer;
import is.codion.framework.json.domain.EntityTypeKeyDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;

public final class EntityObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;
    public static final TypeReference<List<Entity.Key>> KEY_LIST_REFERENCE = new TypeReference<List<Entity.Key>>(){};
    public static final TypeReference<List<Entity>> ENTITY_LIST_REFERENCE = new TypeReference<List<Entity>>(){};
    private final SimpleModule module;
    private final EntitySerializer entitySerializer;
    private final EntityDeserializer entityDeserializer;
    private final ConditionSerializer conditionSerializer;
    private final ConditionDeserializer conditionDeserializer;
    private final Entities entities;

    EntityObjectMapper(Entities entities) {
        this.entities = Objects.requireNonNull(entities, "entities");
        this.entitySerializer = new EntitySerializer(this);
        this.entityDeserializer = new EntityDeserializer(entities, this);
        this.conditionSerializer = new ConditionSerializer(this);
        this.conditionDeserializer = new ConditionDeserializer(this);
        this.module = new SimpleModule();
        this.module.addSerializer(Entity.class, (JsonSerializer)this.entitySerializer);
        this.module.addDeserializer(Entity.class, (JsonDeserializer)this.entityDeserializer);
        this.module.addSerializer(Entity.Key.class, (JsonSerializer)new EntityKeySerializer(this));
        this.module.addDeserializer(Entity.Key.class, (JsonDeserializer)new EntityKeyDeserializer(this));
        this.module.addKeyDeserializer(EntityType.class, (KeyDeserializer)new EntityTypeKeyDeserializer(entities));
        this.module.addSerializer(Condition.class, (JsonSerializer)this.conditionSerializer);
        this.module.addDeserializer(Condition.class, (JsonDeserializer)this.conditionDeserializer);
        this.registerModule((Module)this.module);
        this.registerModule((Module)new JavaTimeModule());
        this.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
    }

    public Entities entities() {
        return this.entities;
    }

    public Module module() {
        return this.module;
    }

    public EntityObjectMapper setIncludeForeignKeyValues(boolean includeForeignKeyValues) {
        this.entitySerializer.setIncludeForeignKeyValues(includeForeignKeyValues);
        return this;
    }

    public EntityObjectMapper setIncludeNullValues(boolean includeNullValues) {
        this.entitySerializer.setIncludeNullValues(includeNullValues);
        return this;
    }

    public void serializeCondition(Condition condition, JsonGenerator generator) throws IOException {
        this.conditionSerializer.serialize(condition, generator);
    }

    public Condition deserializeCondition(EntityDefinition definition, JsonNode conditionNode) throws IOException {
        return this.conditionDeserializer.deserialize(definition, conditionNode);
    }

    public List<Entity> deserializeEntities(String jsonString) throws JsonProcessingException {
        return (List)this.readValue(jsonString, ENTITY_LIST_REFERENCE);
    }

    public List<Entity> deserializeEntities(InputStream inputStream) throws IOException {
        return (List)this.readValue(inputStream, ENTITY_LIST_REFERENCE);
    }

    public List<Entity.Key> deserializeKeys(String jsonString) throws JsonProcessingException {
        return (List)this.readValue(jsonString, KEY_LIST_REFERENCE);
    }

    public List<Entity.Key> deserializeKeys(InputStream inputStream) throws IOException {
        return (List)this.readValue(inputStream, KEY_LIST_REFERENCE);
    }

    public <T> void addSerializer(Class<? extends T> clazz, StdSerializer<T> serializer) {
        this.module.addSerializer(Objects.requireNonNull(clazz), (JsonSerializer)Objects.requireNonNull(serializer));
    }

    public <T> void addDeserializer(Class<T> clazz, StdDeserializer<? extends T> deserializer) {
        this.module.addDeserializer(Objects.requireNonNull(clazz), (JsonDeserializer)Objects.requireNonNull(deserializer));
    }

    public static EntityObjectMapper entityObjectMapper(Entities entities) {
        return new EntityObjectMapper(entities);
    }
}

