/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.domain;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class EntityDeserializer
extends StdDeserializer<Entity> {
    private static final long serialVersionUID = 1L;
    private final Entities entities;
    private final EntityObjectMapper entityObjectMapper;
    private final Map<String, EntityDefinition> definitions = new ConcurrentHashMap<String, EntityDefinition>();

    EntityDeserializer(Entities entities, EntityObjectMapper entityObjectMapper) {
        super(Entity.class);
        this.entities = entities;
        this.entityObjectMapper = entityObjectMapper;
    }

    public Entity deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonNode entityNode = (JsonNode)parser.getCodec().readTree(parser);
        EntityDefinition definition = this.definitions.computeIfAbsent(entityNode.get("entityType").asText(), arg_0 -> ((Entities)this.entities).definition(arg_0));
        Entity entity = definition.entity(this.valueMap(entityNode, definition), this.originalValueMap(entityNode, definition));
        JsonNode immutable = entityNode.get("immutable");
        if (immutable != null && immutable.booleanValue()) {
            entity = entity.immutable();
        }
        return entity;
    }

    private Map<Attribute<?>, Object> valueMap(JsonNode node, EntityDefinition definition) throws JsonProcessingException {
        return this.attributeValueMap(definition, node.get("values"));
    }

    private Map<Attribute<?>, Object> originalValueMap(JsonNode node, EntityDefinition definition) throws JsonProcessingException {
        JsonNode originalValues = node.get("original");
        if (originalValues != null) {
            return this.attributeValueMap(definition, originalValues);
        }
        return null;
    }

    private Map<Attribute<?>, Object> attributeValueMap(EntityDefinition definition, JsonNode values) throws JsonProcessingException {
        HashMap valueMap = new HashMap();
        Iterator fields = values.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            AttributeDefinition attributeDefinition = definition.attributes().definition(definition.attributes().get((String)field.getKey()));
            valueMap.put(attributeDefinition.attribute(), this.entityObjectMapper.readValue(((JsonNode)field.getValue()).toString(), attributeDefinition.attribute().type().valueClass()));
        }
        return valueMap;
    }
}

