/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.domain;

import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public interface EntityObjectMapperFactory {
    default public EntityObjectMapper entityObjectMapper(Entities entities) {
        return EntityObjectMapper.entityObjectMapper(entities);
    }

    public boolean compatibleWith(DomainType var1);

    public static EntityObjectMapperFactory instance(DomainType domainType) {
        Objects.requireNonNull(domainType);
        try {
            ServiceLoader<EntityObjectMapperFactory> loader = ServiceLoader.load(EntityObjectMapperFactory.class);
            for (EntityObjectMapperFactory factory : loader) {
                if (!factory.compatibleWith(domainType)) continue;
                return factory;
            }
            return mapperDomainType -> true;
        }
        catch (ServiceConfigurationError e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

