/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.domain;

import com.fasterxml.jackson.databind.JsonNode;
import is.codion.common.Conjunction;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.json.domain.ConditionDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

final class ConditionCombinationDeserializer {
    private final ConditionDeserializer conditionDeserializer;

    ConditionCombinationDeserializer(ConditionDeserializer conditionDeserializer) {
        this.conditionDeserializer = Objects.requireNonNull(conditionDeserializer);
    }

    Condition.Combination deserialize(EntityDefinition definition, JsonNode jsonNode) throws IOException {
        Conjunction conjunction = Conjunction.valueOf((String)jsonNode.get("conjunction").asText());
        JsonNode conditionsNode = jsonNode.get("conditions");
        ArrayList<Condition> conditions = new ArrayList<Condition>(conditionsNode.size());
        for (JsonNode conditionNode : conditionsNode) {
            conditions.add(this.conditionDeserializer.deserialize(definition, conditionNode));
        }
        return Condition.combination((Conjunction)conjunction, conditions);
    }
}

