/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.domain;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.AttributeDefinition;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class EntitySerializer
extends StdSerializer<Entity> {
    private static final long serialVersionUID = 1L;
    private boolean includeForeignKeyValues = true;
    private boolean includeNullValues = true;
    private final EntityObjectMapper mapper;

    EntitySerializer(EntityObjectMapper mapper) {
        super(Entity.class);
        this.mapper = mapper;
    }

    public void serialize(Entity entity, JsonGenerator generator, SerializerProvider provider) throws IOException {
        Objects.requireNonNull(entity, "entity");
        generator.writeStartObject();
        generator.writeStringField("entityType", entity.entityType().name());
        generator.writeFieldName("values");
        this.writeValues(entity, generator, entity.entrySet());
        if (entity.modified()) {
            generator.writeFieldName("originalValues");
            this.writeValues(entity, generator, entity.originalEntrySet());
        }
        if (!entity.mutable()) {
            generator.writeBooleanField("immutable", Boolean.TRUE.booleanValue());
        }
        generator.writeEndObject();
    }

    void setIncludeForeignKeyValues(boolean includeForeignKeyValues) {
        this.includeForeignKeyValues = includeForeignKeyValues;
    }

    void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    private void writeValues(Entity entity, JsonGenerator generator, Set<Map.Entry<Attribute<?>, Object>> entrySet) throws IOException {
        generator.writeStartObject();
        EntityDefinition definition = entity.definition();
        for (Map.Entry<Attribute<?>, Object> entry : entrySet) {
            AttributeDefinition attributeDefinition = definition.attributes().definition(entry.getKey());
            if (!this.include(attributeDefinition, entity)) continue;
            generator.writeFieldName(attributeDefinition.attribute().name());
            this.mapper.writeValue(generator, entry.getValue());
        }
        generator.writeEndObject();
    }

    private boolean include(AttributeDefinition<?> attributeDefinition, Entity entity) {
        if (!this.includeForeignKeyValues && attributeDefinition instanceof ForeignKeyDefinition) {
            return false;
        }
        return this.includeNullValues || !entity.isNull(attributeDefinition.attribute());
    }
}

