/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.domain;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ColumnDefinition;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class EntityKeyDeserializer
extends StdDeserializer<Entity.Key> {
    private static final long serialVersionUID = 1L;
    private final EntityObjectMapper entityObjectMapper;
    private final Map<String, EntityDefinition> definitions = new ConcurrentHashMap<String, EntityDefinition>();

    EntityKeyDeserializer(EntityObjectMapper entityObjectMapper) {
        super(Entity.Key.class);
        this.entityObjectMapper = entityObjectMapper;
    }

    public Entity.Key deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = parser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(parser);
        EntityDefinition definition = this.definitions.computeIfAbsent(node.get("entityType").asText(), arg_0 -> ((Entities)this.entityObjectMapper.entities()).definition(arg_0));
        JsonNode values = node.get("values");
        Entity.Key.Builder builder = this.entityObjectMapper.entities().keyBuilder(definition.entityType());
        Iterator fields = values.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            ColumnDefinition columnDefinition = definition.columns().definition((Column)definition.attributes().get((String)field.getKey()));
            builder.with(columnDefinition.attribute(), this.entityObjectMapper.readValue(((JsonNode)field.getValue()).toString(), columnDefinition.attribute().type().valueClass()));
        }
        return builder.build();
    }
}

