/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.domain;

import com.fasterxml.jackson.core.JsonGenerator;
import is.codion.framework.domain.entity.condition.ColumnCondition;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.json.domain.ColumnConditionSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

final class ConditionCombinationSerializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ColumnConditionSerializer columnConditionSerializer;

    ConditionCombinationSerializer(ColumnConditionSerializer columnConditionSerializer) {
        this.columnConditionSerializer = Objects.requireNonNull(columnConditionSerializer);
    }

    void serialize(Condition.Combination combination, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", "combination");
        generator.writeStringField("conjunction", combination.conjunction().name());
        generator.writeArrayFieldStart("conditions");
        for (Condition condition : combination.conditions()) {
            if (condition instanceof Condition.Combination) {
                this.serialize((Condition.Combination)condition, generator);
                continue;
            }
            if (!(condition instanceof ColumnCondition)) continue;
            this.columnConditionSerializer.serialize((ColumnCondition)condition, generator);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }
}

