/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.domain;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.io.IOException;
import java.util.Objects;

final class EntityKeySerializer
extends StdSerializer<Entity.Key> {
    private static final long serialVersionUID = 1L;
    private final EntityObjectMapper entityObjectMapper;

    EntityKeySerializer(EntityObjectMapper entityObjectMapper) {
        super(Entity.Key.class);
        this.entityObjectMapper = entityObjectMapper;
    }

    public void serialize(Entity.Key key, JsonGenerator generator, SerializerProvider provider) throws IOException {
        Objects.requireNonNull(key, "key");
        generator.writeStartObject();
        generator.writeStringField("entityType", key.entityType().name());
        generator.writeFieldName("values");
        this.writeValues(key, generator);
        generator.writeEndObject();
    }

    private void writeValues(Entity.Key key, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        for (Column column : key.columns()) {
            generator.writeFieldName(column.name());
            this.entityObjectMapper.writeValue(generator, key.get(column));
        }
        generator.writeEndObject();
    }
}

