/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.domain;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import is.codion.framework.domain.entity.condition.ColumnCondition;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.domain.entity.condition.CustomCondition;
import is.codion.framework.json.domain.ColumnConditionSerializer;
import is.codion.framework.json.domain.ConditionCombinationSerializer;
import is.codion.framework.json.domain.CustomConditionSerializer;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.io.IOException;

final class ConditionSerializer
extends StdSerializer<Condition> {
    private static final long serialVersionUID = 1L;
    private final ColumnConditionSerializer columnConditionSerializer;
    private final ConditionCombinationSerializer conditionCombinationSerializer;
    private final CustomConditionSerializer customConditionSerializer;

    ConditionSerializer(EntityObjectMapper entityObjectMapper) {
        super(Condition.class);
        this.columnConditionSerializer = new ColumnConditionSerializer(entityObjectMapper);
        this.conditionCombinationSerializer = new ConditionCombinationSerializer(this.columnConditionSerializer);
        this.customConditionSerializer = new CustomConditionSerializer(entityObjectMapper);
    }

    public void serialize(Condition condition, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("entityType", condition.entityType().name());
        generator.writeFieldName("condition");
        this.serialize(condition, generator);
        generator.writeEndObject();
    }

    void serialize(Condition condition, JsonGenerator generator) throws IOException {
        if (condition instanceof Condition.Combination) {
            Condition.Combination combination = (Condition.Combination)condition;
            this.conditionCombinationSerializer.serialize(combination, generator);
        } else if (condition instanceof ColumnCondition) {
            ColumnCondition columnCondition = (ColumnCondition)condition;
            this.columnConditionSerializer.serialize(columnCondition, generator);
        } else if (condition instanceof CustomCondition) {
            CustomCondition customCondition = (CustomCondition)condition;
            this.customConditionSerializer.serialize(customCondition, generator);
        } else if (condition instanceof Condition.All) {
            generator.writeStartObject();
            generator.writeStringField("type", "all");
            generator.writeStringField("entityType", condition.entityType().name());
            generator.writeEndObject();
        } else {
            throw new IllegalArgumentException("Unknown condition type: " + condition.getClass());
        }
    }
}

