/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.domain;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import is.codion.framework.domain.entity.Entities;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.json.domain.ColumnConditionDeserializer;
import is.codion.framework.json.domain.ConditionCombinationDeserializer;
import is.codion.framework.json.domain.CustomConditionDeserializer;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.io.IOException;
import java.util.Objects;

final class ConditionDeserializer
extends StdDeserializer<Condition> {
    private static final long serialVersionUID = 1L;
    final EntityObjectMapper entityObjectMapper;
    final Entities entities;
    private final ColumnConditionDeserializer columnConditionDeserializer;
    private final ConditionCombinationDeserializer conditionCombinationDeserializer;
    private final CustomConditionDeserializer customConditionDeserializer;

    ConditionDeserializer(EntityObjectMapper entityObjectMapper) {
        super(Condition.class);
        this.entityObjectMapper = Objects.requireNonNull(entityObjectMapper);
        this.columnConditionDeserializer = new ColumnConditionDeserializer(entityObjectMapper);
        this.conditionCombinationDeserializer = new ConditionCombinationDeserializer(this);
        this.customConditionDeserializer = new CustomConditionDeserializer(entityObjectMapper);
        this.entities = entityObjectMapper.entities();
    }

    public Condition deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        EntityType entityType = this.entities.domainType().entityType(node.get("entityType").asText());
        JsonNode conditionNode = node.get("condition");
        return this.deserialize(this.entities.definition(entityType), conditionNode);
    }

    Condition deserialize(EntityDefinition definition, JsonNode conditionNode) throws IOException {
        JsonNode type = conditionNode.get("type");
        String typeString = type.asText();
        if ("combination".equals(typeString)) {
            return this.conditionCombinationDeserializer.deserialize(definition, conditionNode);
        }
        if ("column".equals(typeString)) {
            return this.columnConditionDeserializer.deserialize(definition, conditionNode);
        }
        if ("custom".equals(typeString)) {
            return this.customConditionDeserializer.deserialize(definition, conditionNode);
        }
        if ("all".equals(typeString)) {
            return Condition.all((EntityType)definition.entityType());
        }
        throw new IllegalArgumentException("Unknown condition type: " + type);
    }
}

