/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.domain;

import com.fasterxml.jackson.core.JsonGenerator;
import is.codion.framework.domain.entity.condition.ColumnCondition;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

final class ColumnConditionSerializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EntityObjectMapper entityObjectMapper;

    ColumnConditionSerializer(EntityObjectMapper entityObjectMapper) {
        this.entityObjectMapper = Objects.requireNonNull(entityObjectMapper);
    }

    void serialize(ColumnCondition<?> condition, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("type", "column");
        generator.writeStringField("column", condition.column().name());
        generator.writeStringField("operator", condition.operator().name());
        generator.writeBooleanField("caseSensitive", condition.caseSensitive());
        generator.writeFieldName("values");
        generator.writeStartArray();
        for (Object value : condition.values()) {
            this.entityObjectMapper.writeValue(generator, value);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }
}

