/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.db;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.json.db.CountDeserializer;
import is.codion.framework.json.db.CountSerializer;
import is.codion.framework.json.db.SelectDeserializer;
import is.codion.framework.json.db.SelectSerializer;
import is.codion.framework.json.db.UpdateDeserializer;
import is.codion.framework.json.db.UpdateSerializer;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.util.Objects;

public final class DatabaseObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    private DatabaseObjectMapper(EntityObjectMapper entityObjectMapper) {
        this.registerModule(Objects.requireNonNull(entityObjectMapper).module());
        SimpleModule module = new SimpleModule();
        module.addSerializer(EntityConnection.Select.class, (JsonSerializer)new SelectSerializer(entityObjectMapper));
        module.addDeserializer(EntityConnection.Select.class, (JsonDeserializer)new SelectDeserializer(entityObjectMapper));
        module.addSerializer(EntityConnection.Update.class, (JsonSerializer)new UpdateSerializer(entityObjectMapper));
        module.addDeserializer(EntityConnection.Update.class, (JsonDeserializer)new UpdateDeserializer(entityObjectMapper));
        module.addSerializer(EntityConnection.Count.class, (JsonSerializer)new CountSerializer(entityObjectMapper));
        module.addDeserializer(EntityConnection.Count.class, (JsonDeserializer)new CountDeserializer(entityObjectMapper));
        this.registerModule((Module)module);
    }

    public static DatabaseObjectMapper databaseObjectMapper(EntityObjectMapper entityObjectMapper) {
        return new DatabaseObjectMapper(entityObjectMapper);
    }
}

