/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.db;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.io.IOException;

final class CountDeserializer
extends StdDeserializer<EntityConnection.Count> {
    private static final long serialVersionUID = 1L;
    private final EntityObjectMapper entityObjectMapper;

    CountDeserializer(EntityObjectMapper entityObjectMapper) {
        super(EntityConnection.Count.class);
        this.entityObjectMapper = entityObjectMapper;
    }

    public EntityConnection.Count deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonNode jsonNode = (JsonNode)parser.getCodec().readTree(parser);
        EntityType entityType = this.entityObjectMapper.entities().domainType().entityType(jsonNode.get("entityType").asText());
        EntityDefinition definition = this.entityObjectMapper.entities().definition(entityType);
        JsonNode whereNode = jsonNode.get("where");
        Condition where = this.entityObjectMapper.deserializeCondition(definition, whereNode);
        JsonNode havingNode = jsonNode.get("having");
        Condition having = this.entityObjectMapper.deserializeCondition(definition, havingNode);
        return EntityConnection.Count.builder((Condition)where).having(having).build();
    }
}

