/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.db;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

final class SelectSerializer
extends StdSerializer<EntityConnection.Select> {
    private static final long serialVersionUID = 1L;
    private final EntityObjectMapper entityObjectMapper;

    SelectSerializer(EntityObjectMapper entityObjectMapper) {
        super(EntityConnection.Select.class);
        this.entityObjectMapper = entityObjectMapper;
    }

    public void serialize(EntityConnection.Select select, JsonGenerator generator, SerializerProvider provider) throws IOException {
        Collection attributes;
        Map foreignKeyFetchDepths;
        int conditionFetchDepth;
        int offset;
        int limit;
        generator.writeStartObject();
        generator.writeStringField("entityType", select.where().entityType().name());
        generator.writeFieldName("where");
        this.entityObjectMapper.serializeCondition(select.where(), generator);
        generator.writeFieldName("having");
        this.entityObjectMapper.serializeCondition(select.having(), generator);
        OrderBy orderBy = select.orderBy().orElse(null);
        if (orderBy != null) {
            generator.writeFieldName("orderBy");
            generator.writeStartArray();
            for (OrderBy.OrderByColumn orderByColumn : orderBy.orderByColumns()) {
                generator.writeString(orderByColumn.column().name() + ":" + (orderByColumn.ascending() ? "asc" : "desc") + ":" + orderByColumn.nullOrder().name());
            }
            generator.writeEndArray();
        }
        if ((limit = select.limit().orElse(-1)) != -1) {
            generator.writeObjectField("limit", (Object)limit);
        }
        if ((offset = select.offset().orElse(-1)) != -1) {
            generator.writeObjectField("offset", (Object)offset);
        }
        if (select.forUpdate()) {
            generator.writeObjectField("forUpdate", (Object)select.forUpdate());
        }
        if (select.queryTimeout() != 0) {
            generator.writeObjectField("queryTimeout", (Object)select.queryTimeout());
        }
        if ((conditionFetchDepth = select.fetchDepth().orElse(-1)) != -1) {
            generator.writeObjectField("fetchDepth", (Object)conditionFetchDepth);
        }
        if (!(foreignKeyFetchDepths = select.foreignKeyFetchDepths()).isEmpty()) {
            generator.writeFieldName("fkFetchDepth");
            generator.writeStartObject();
            for (Map.Entry entry : foreignKeyFetchDepths.entrySet()) {
                generator.writeObjectField(((ForeignKey)entry.getKey()).name(), entry.getValue());
            }
            generator.writeEndObject();
        }
        if (!(attributes = select.attributes()).isEmpty()) {
            generator.writeFieldName("attributes");
            generator.writeStartArray();
            for (Attribute attribute : attributes) {
                generator.writeString(attribute.name());
            }
            generator.writeEndArray();
            generator.writeEndObject();
        }
    }
}

