/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.db;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.entity.EntityDefinition;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.OrderBy;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class SelectDeserializer
extends StdDeserializer<EntityConnection.Select> {
    private static final long serialVersionUID = 1L;
    private final EntityObjectMapper entityObjectMapper;

    SelectDeserializer(EntityObjectMapper entityObjectMapper) {
        super(EntityConnection.Select.class);
        this.entityObjectMapper = entityObjectMapper;
    }

    public EntityConnection.Select deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonNode queryTimeout;
        JsonNode attributes;
        JsonNode fkFetchDepth;
        JsonNode fetchDepth;
        JsonNode forUpdate;
        JsonNode offset;
        JsonNode limit;
        JsonNode orderBy;
        JsonNode jsonNode = (JsonNode)parser.getCodec().readTree(parser);
        EntityType entityType = this.entityObjectMapper.entities().domainType().entityType(jsonNode.get("entityType").asText());
        EntityDefinition definition = this.entityObjectMapper.entities().definition(entityType);
        JsonNode whereConditionNode = jsonNode.get("where");
        Condition whereCondition = this.entityObjectMapper.deserializeCondition(definition, whereConditionNode);
        EntityConnection.Select.Builder selectBuilder = EntityConnection.Select.where((Condition)whereCondition);
        JsonNode havingCondition = jsonNode.get("having");
        if (havingCondition != null) {
            selectBuilder.having(this.entityObjectMapper.deserializeCondition(definition, havingCondition));
        }
        if ((orderBy = jsonNode.get("orderBy")) != null && !orderBy.isNull()) {
            selectBuilder.orderBy(SelectDeserializer.deserializeOrderBy(definition, orderBy));
        }
        if ((limit = jsonNode.get("limit")) != null && !limit.isNull()) {
            selectBuilder.limit(Integer.valueOf(limit.asInt()));
        }
        if ((offset = jsonNode.get("offset")) != null && !offset.isNull()) {
            selectBuilder.offset(Integer.valueOf(offset.asInt()));
        }
        if ((forUpdate = jsonNode.get("forUpdate")) != null && !forUpdate.isNull() && forUpdate.asBoolean()) {
            selectBuilder.forUpdate();
        }
        if ((fetchDepth = jsonNode.get("fetchDepth")) != null && !fetchDepth.isNull()) {
            selectBuilder.fetchDepth(fetchDepth.asInt());
        }
        if ((fkFetchDepth = jsonNode.get("fkFetchDepth")) != null && !fkFetchDepth.isNull()) {
            for (ForeignKey foreignKey : definition.foreignKeys().get()) {
                JsonNode fetchDepthNode = fkFetchDepth.get(foreignKey.name());
                if (fetchDepthNode == null) continue;
                selectBuilder.fetchDepth(foreignKey, fetchDepthNode.asInt());
            }
        }
        if ((attributes = jsonNode.get("attributes")) != null && !attributes.isNull()) {
            selectBuilder.attributes(SelectDeserializer.deserializeAttributes(definition, attributes));
        }
        if ((queryTimeout = jsonNode.get("queryTimeout")) != null && !queryTimeout.isNull()) {
            selectBuilder.queryTimeout(queryTimeout.asInt());
        }
        return selectBuilder.build();
    }

    private static OrderBy deserializeOrderBy(EntityDefinition definition, JsonNode jsonNode) {
        if (jsonNode.isEmpty()) {
            return null;
        }
        OrderBy.Builder builder = OrderBy.builder();
        block8: for (JsonNode node : jsonNode) {
            String[] split = node.asText().split(":");
            Column column = (Column)definition.attributes().get(split[0]);
            String order = split[1];
            OrderBy.NullOrder nullOrder = OrderBy.NullOrder.valueOf((String)split[2]);
            if ("asc".equals(order)) {
                switch (nullOrder) {
                    case NULLS_FIRST: {
                        builder.ascendingNullsFirst(new Column[]{column});
                        continue block8;
                    }
                    case NULLS_LAST: {
                        builder.ascendingNullsLast(new Column[]{column});
                        continue block8;
                    }
                }
                builder.ascending(new Column[]{column});
                continue;
            }
            switch (nullOrder) {
                case NULLS_FIRST: {
                    builder.descendingNullsFirst(new Column[]{column});
                    continue block8;
                }
                case NULLS_LAST: {
                    builder.descendingNullsLast(new Column[]{column});
                    continue block8;
                }
            }
            builder.descending(new Column[]{column});
        }
        return builder.build();
    }

    private static List<Attribute<?>> deserializeAttributes(EntityDefinition definition, JsonNode jsonNode) {
        ArrayList attributes = new ArrayList(jsonNode.size());
        for (JsonNode node : jsonNode) {
            attributes.add(definition.attributes().get(node.asText()));
        }
        return attributes;
    }
}

