/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.json.db;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.json.domain.EntityObjectMapper;
import java.io.IOException;
import java.util.Map;

final class UpdateSerializer
extends StdSerializer<EntityConnection.Update> {
    private static final long serialVersionUID = 1L;
    private final EntityObjectMapper entityObjectMapper;

    UpdateSerializer(EntityObjectMapper entityObjectMapper) {
        super(EntityConnection.Update.class);
        this.entityObjectMapper = entityObjectMapper;
    }

    public void serialize(EntityConnection.Update update, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("entityType", update.where().entityType().name());
        generator.writeFieldName("condition");
        this.entityObjectMapper.serializeCondition(update.where(), generator);
        generator.writeFieldName("values");
        generator.writeStartObject();
        for (Map.Entry columnValue : update.columnValues().entrySet()) {
            generator.writeFieldName(((Column)columnValue.getKey()).name());
            this.entityObjectMapper.writeValue(generator, columnValue.getValue());
        }
        generator.writeEndObject();
        generator.writeEndObject();
    }
}

