/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.i18n;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public final class FrameworkMessages {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(FrameworkMessages.class.getName());
    private static final String FILE = "file";
    private static final String FILE_MNEMONIC = "file_mnemonic";
    private static final String EXIT = "exit";
    private static final String EXIT_MNEMONIC = "exit_mnemonic";
    private static final String EXIT_TIP = "exit_tip";
    private static final String VIEW = "view";
    private static final String VIEW_MNEMONIC = "view_mnemonic";
    private static final String SUPPORT_TABLES = "support_tables";
    private static final String SUPPORT_TABLES_MNEMONIC = "support_tables_mnemonic";
    private static final String UPDATE = "update";
    private static final String UPDATE_MNEMONIC = "update_mnemonic";
    private static final String UPDATE_TIP = "update_tip";
    private static final String EDIT = "edit";
    private static final String EDIT_SELECTED_TIP = "edit_selected_tip";
    private static final String DELETE = "delete";
    private static final String DELETE_MNEMONIC = "delete_mnemonic";
    private static final String DELETE_CURRENT_TIP = "delete_current_tip";
    private static final String DELETE_SELECTED_TIP = "delete_selected_tip";
    private static final String DEPENDENCIES = "dependencies";
    private static final String DEPENDENCIES_TIP = "dependencies_tip";
    private static final String ADD = "add";
    private static final String ADD_MNEMONIC = "add_mnemonic";
    private static final String ADD_TIP = "add_tip";
    private static final String SAVE = "save";
    private static final String SAVE_MNEMONIC = "save_mnemonic";
    private static final String CONFIRM_EXIT = "confirm_exit";
    private static final String CONFIRM_EXIT_TITLE = "confirm_exit_title";
    private static final String UNSAVED_DATA_WARNING = "unsaved_data_warning";
    private static final String UNSAVED_DATA_WARNING_TITLE = "unsaved_data_warning_title";
    private static final String CONFIRM_UPDATE = "confirm_update";
    private static final String CONFIRM_DELETE_SELECTED = "confirm_delete_selected";
    private static final String CONFIRM_DELETE = "confirm_delete";
    private static final String CONFIRM_INSERT = "confirm_insert";
    private static final String SHOW = "show";
    private static final String NO_RESULTS_FOUND = "no_results_found";
    private static final String SEARCH = "search";
    private static final String FILTER = "filter";
    private static final String SEARCH_MNEMONIC = "search_mnemonic";
    private static final String COPY_CELL = "copy_cell";
    private static final String COPY_TABLE_WITH_HEADER = "copy_table_with_header";
    private static final String SETTINGS = "settings";
    private static final String SELECT_INPUT_FIELD = "select_input_field";
    private static final String SELECT_SEARCH_FIELD = "select_search_field";
    private static final String SELECT_FILTER_FIELD = "select_filter_field";

    private FrameworkMessages() {
    }

    public static String file() {
        return FrameworkMessages.get(FILE);
    }

    public static char fileMnemonic() {
        return FrameworkMessages.get(FILE_MNEMONIC).charAt(0);
    }

    public static String exit() {
        return FrameworkMessages.get(EXIT);
    }

    public static char exitMnemonic() {
        return FrameworkMessages.get(EXIT_MNEMONIC).charAt(0);
    }

    public static String exitTip() {
        return FrameworkMessages.get(EXIT_TIP);
    }

    public static String view() {
        return FrameworkMessages.get(VIEW);
    }

    public static char viewMnemonic() {
        return FrameworkMessages.get(VIEW_MNEMONIC).charAt(0);
    }

    public static String supportTables() {
        return FrameworkMessages.get(SUPPORT_TABLES);
    }

    public static char supportTablesMnemonic() {
        return FrameworkMessages.get(SUPPORT_TABLES_MNEMONIC).charAt(0);
    }

    public static String update() {
        return FrameworkMessages.get(UPDATE);
    }

    public static char updateMnemonic() {
        return FrameworkMessages.get(UPDATE_MNEMONIC).charAt(0);
    }

    public static String updateTip() {
        return FrameworkMessages.get(UPDATE_TIP);
    }

    public static String edit() {
        return FrameworkMessages.get(EDIT);
    }

    public static String editSelectedTip() {
        return FrameworkMessages.get(EDIT_SELECTED_TIP);
    }

    public static String delete() {
        return FrameworkMessages.get(DELETE);
    }

    public static char deleteMnemonic() {
        return FrameworkMessages.get(DELETE_MNEMONIC).charAt(0);
    }

    public static String deleteCurrentTip() {
        return FrameworkMessages.get(DELETE_CURRENT_TIP);
    }

    public static String deleteSelectedTip() {
        return FrameworkMessages.get(DELETE_SELECTED_TIP);
    }

    public static String dependencies() {
        return FrameworkMessages.get(DEPENDENCIES);
    }

    public static String dependenciesTip() {
        return FrameworkMessages.get(DEPENDENCIES_TIP);
    }

    public static String add() {
        return FrameworkMessages.get(ADD);
    }

    public static char addMnemonic() {
        return FrameworkMessages.get(ADD_MNEMONIC).charAt(0);
    }

    public static String addTip() {
        return FrameworkMessages.get(ADD_TIP);
    }

    public static String save() {
        return FrameworkMessages.get(SAVE);
    }

    public static char saveMnemonic() {
        return FrameworkMessages.get(SAVE_MNEMONIC).charAt(0);
    }

    public static String confirmExit() {
        return FrameworkMessages.get(CONFIRM_EXIT);
    }

    public static String confirmExitTitle() {
        return FrameworkMessages.get(CONFIRM_EXIT_TITLE);
    }

    public static String unsavedDataWarning() {
        return FrameworkMessages.get(UNSAVED_DATA_WARNING);
    }

    public static String unsavedDataWarningTitle() {
        return FrameworkMessages.get(UNSAVED_DATA_WARNING_TITLE);
    }

    public static String confirmUpdate() {
        return FrameworkMessages.get(CONFIRM_UPDATE);
    }

    public static String confirmDeleteSelected(int selectionCount) {
        return MessageFormat.format(FrameworkMessages.get(CONFIRM_DELETE_SELECTED), selectionCount);
    }

    public static String confirmDelete() {
        return FrameworkMessages.get(CONFIRM_DELETE);
    }

    public static String confirmInsert() {
        return FrameworkMessages.get(CONFIRM_INSERT);
    }

    public static String show() {
        return FrameworkMessages.get(SHOW);
    }

    public static String noResultsFound() {
        return FrameworkMessages.get(NO_RESULTS_FOUND);
    }

    public static String search() {
        return FrameworkMessages.get(SEARCH);
    }

    public static String filter() {
        return FrameworkMessages.get(FILTER);
    }

    public static char searchMnemonic() {
        return FrameworkMessages.get(SEARCH_MNEMONIC).charAt(0);
    }

    public static String copyCell() {
        return FrameworkMessages.get(COPY_CELL);
    }

    public static String copyTableWithHeader() {
        return FrameworkMessages.get(COPY_TABLE_WITH_HEADER);
    }

    public static String settings() {
        return FrameworkMessages.get(SETTINGS);
    }

    public static String selectInputField() {
        return FrameworkMessages.get(SELECT_INPUT_FIELD);
    }

    public static String selectSearchField() {
        return FrameworkMessages.get(SELECT_SEARCH_FIELD);
    }

    public static String selectFilterField() {
        return FrameworkMessages.get(SELECT_FILTER_FIELD);
    }

    private static String get(String key) {
        return BUNDLE.getString(key);
    }
}

