/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity.attribute;

import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.AbstractAttributeDefinition;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import is.codion.framework.domain.entity.attribute.ForeignKeyDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

final class DefaultForeignKeyDefinition
extends AbstractAttributeDefinition<Entity>
implements ForeignKeyDefinition {
    private static final long serialVersionUID = 1L;
    private final Set<Column<?>> readOnlyColumns;
    private final List<Attribute<?>> attributes;
    private final int fetchDepth;
    private final boolean soft;

    private DefaultForeignKeyDefinition(DefaultForeignKeyDefinitionBuilder builder) {
        super(builder);
        this.readOnlyColumns = builder.readOnlyColumns;
        this.attributes = builder.attributes;
        this.fetchDepth = builder.fetchDepth;
        this.soft = builder.soft;
    }

    @Override
    public ForeignKey attribute() {
        return (ForeignKey)super.attribute();
    }

    @Override
    public int fetchDepth() {
        return this.fetchDepth;
    }

    @Override
    public boolean soft() {
        return this.soft;
    }

    @Override
    public boolean readOnly(Column<?> referenceColumn) {
        return this.readOnlyColumns.contains(referenceColumn);
    }

    @Override
    public List<ForeignKey.Reference<?>> references() {
        return this.attribute().references();
    }

    @Override
    public List<Attribute<?>> attributes() {
        return this.attributes;
    }

    static final class DefaultForeignKeyDefinitionBuilder
    extends AbstractAttributeDefinition.AbstractAttributeDefinitionBuilder<Entity, ForeignKeyDefinition.Builder>
    implements ForeignKeyDefinition.Builder {
        private final Set<Column<?>> readOnlyColumns = new HashSet(1);
        private final EntityType referencedEntityType;
        private final int fetchDepth;
        private final boolean soft;
        private List<Attribute<?>> attributes = Collections.emptyList();

        DefaultForeignKeyDefinitionBuilder(ForeignKey foreignKey, int fetchDepth, boolean soft) {
            super(foreignKey);
            if (fetchDepth < -1) {
                throw new IllegalArgumentException("Fetch depth must be at least -1: " + foreignKey);
            }
            this.referencedEntityType = foreignKey.referencedType();
            this.soft = soft;
            this.fetchDepth = fetchDepth;
        }

        public ForeignKeyDefinition build() {
            return new DefaultForeignKeyDefinition(this);
        }

        @Override
        public ForeignKeyDefinition.Builder readOnly(Column<?> referenceColumn) {
            if (((ForeignKey)this.attribute).reference(referenceColumn) == null) {
                throw new IllegalArgumentException("Column " + referenceColumn + " is not part of foreign key: " + this.attribute);
            }
            this.readOnlyColumns.add(referenceColumn);
            return this;
        }

        @Override
        public ForeignKeyDefinition.Builder attributes(Attribute<?> ... attributes) {
            HashSet attributeSet = new HashSet();
            for (Attribute<?> attribute : Objects.requireNonNull(attributes)) {
                if (!attribute.entityType().equals(this.referencedEntityType)) {
                    throw new IllegalArgumentException("Attribute must be part of the referenced entity");
                }
                attributeSet.add(attribute);
            }
            this.attributes = Collections.unmodifiableList(new ArrayList(attributeSet));
            return this;
        }

        @Override
        public ForeignKeyDefinition.Builder comparator(Comparator<Entity> comparator) {
            throw new UnsupportedOperationException("Foreign key values are compared using the comparator of the underlying entity");
        }
    }
}

