/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.domain.entity;

import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Attribute;
import is.codion.framework.domain.entity.attribute.ForeignKey;
import java.io.Serializable;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class StringFactory {
    private static final String ATTRIBUTE_PARAM = "attribute";

    private StringFactory() {
    }

    public static Builder builder() {
        return new DefaultStringFactoryBuilder();
    }

    private static final class DefaultStringFactoryBuilder
    implements Builder {
        private final List<Function<Entity, String>> valueProviders = new ArrayList<Function<Entity, String>>();
        private EntityType entityType;

        private DefaultStringFactoryBuilder() {
        }

        @Override
        public Builder value(Attribute<?> attribute) {
            this.valueProviders.add(new StringValueProvider(attribute));
            this.validateEntityType(attribute);
            return this;
        }

        @Override
        public Builder value(Attribute<?> attribute, Format format) {
            this.valueProviders.add(new FormattedValueProvider(attribute, format));
            return this;
        }

        @Override
        public Builder value(ForeignKey foreignKey, Attribute<?> attribute) {
            this.valueProviders.add(new ForeignKeyValueProvider(foreignKey, attribute));
            return this;
        }

        @Override
        public Builder text(String text) {
            this.valueProviders.add(new StaticTextProvider(text));
            return this;
        }

        @Override
        public Function<Entity, String> build() {
            return new DefaultStringFactory(this);
        }

        private void validateEntityType(Attribute<?> attribute) {
            if (this.entityType == null) {
                this.entityType = attribute.entityType();
            } else if (!attribute.entityType().equals(this.entityType)) {
                throw new IllegalArgumentException("entityType " + this.entityType + " expected, got: " + attribute.entityType());
            }
        }
    }

    private static final class StaticTextProvider
    implements Function<Entity, String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String text;

        private StaticTextProvider(String text) {
            this.text = Objects.requireNonNull(text, "text");
        }

        @Override
        public String apply(Entity entity) {
            return this.text;
        }
    }

    private static final class StringValueProvider
    implements Function<Entity, String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Attribute<?> attribute;

        private StringValueProvider(Attribute<?> attribute) {
            this.attribute = Objects.requireNonNull(attribute, StringFactory.ATTRIBUTE_PARAM);
        }

        @Override
        public String apply(Entity entity) {
            return entity.string(this.attribute);
        }
    }

    private static final class ForeignKeyValueProvider
    implements Function<Entity, String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ForeignKey foreignKey;
        private final Attribute<?> attribute;

        private ForeignKeyValueProvider(ForeignKey foreignKey, Attribute<?> attribute) {
            this.foreignKey = Objects.requireNonNull(foreignKey, "foreignKey");
            this.attribute = Objects.requireNonNull(attribute, StringFactory.ATTRIBUTE_PARAM);
            if (!attribute.entityType().equals(foreignKey.referencedType())) {
                throw new IllegalArgumentException("Attribute " + attribute + " is not part of entity: " + foreignKey.entityType());
            }
        }

        @Override
        public String apply(Entity entity) {
            if (entity.isNull(this.foreignKey)) {
                return "";
            }
            return entity.entity(this.foreignKey).string(this.attribute);
        }
    }

    private static final class FormattedValueProvider
    implements Function<Entity, String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Attribute<?> attribute;
        private final Format format;

        private FormattedValueProvider(Attribute<?> attribute, Format format) {
            this.attribute = Objects.requireNonNull(attribute, StringFactory.ATTRIBUTE_PARAM);
            this.format = Objects.requireNonNull(format, "format");
        }

        @Override
        public String apply(Entity entity) {
            if (entity.isNull(this.attribute)) {
                return "";
            }
            return this.format.format(entity.get(this.attribute));
        }
    }

    private static final class DefaultStringFactory
    implements Function<Entity, String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<Function<Entity, String>> valueProviders;

        private DefaultStringFactory(DefaultStringFactoryBuilder builder) {
            this.valueProviders = Collections.unmodifiableList(builder.valueProviders);
        }

        @Override
        public String apply(Entity entity) {
            Objects.requireNonNull(entity, "entity");
            if (this.valueProviders.size() == 1) {
                return this.valueProviders.get(0).apply(entity);
            }
            return this.valueProviders.stream().map(valueProvider -> (String)valueProvider.apply(entity)).collect(Collectors.joining());
        }
    }

    public static interface Builder {
        public Builder value(Attribute<?> var1);

        public Builder value(Attribute<?> var1, Format var2);

        public Builder value(ForeignKey var1, Attribute<?> var2);

        public Builder text(String var1);

        public Function<Entity, String> build();
    }
}

